/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.metadatautil;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.Searchable;
import com.amazon.dsi.dataengine.utilities.Updatable;
import com.amazon.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.amazon.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.amazon.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.amazon.sqlengine.dsiext.dataengine.IColumnInfo;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.exceptions.ErrorException;

class AEMetadataCoercer {
    private AECoercionProperties m_properties;

    public AEMetadataCoercer(AECoercionProperties aECoercionProperties) {
        this.m_properties = aECoercionProperties;
    }

    public long calcColumnLength(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        if (sqlTypes.isBinary()) {
            SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo.getType());
            SqlTypes sqlTypes3 = SqlTypes.getValueOf(iColumnInfo2.getType());
            if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.SET_OPERATION && sqlTypes2.isBinary() && sqlTypes3.isBinary()) {
                return Math.max(iColumnInfo.getColumnLength(), iColumnInfo2.getColumnLength());
            }
            throw SQLEngineExceptionFactory.invalidOperationException("Operation for coercion types is not compatible: Operation: " + coercionOperation.name() + "type1: " + iColumnInfo.getType() + "type2: " + iColumnInfo2.getType());
        }
        if (sqlTypes.isChar() || sqlTypes.isWChar()) {
            if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.COMPARISON || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.LIKE || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.SET_OPERATION || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.IN) {
                return Math.max(iColumnInfo.getDisplaySize(), iColumnInfo2.getDisplaySize());
            }
            if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.PLUS || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.CONCAT) {
                long l = iColumnInfo.getDisplaySize() + iColumnInfo2.getDisplaySize();
                return l > 0xFFFFFFFFL ? 0xFFFFFFFFL : l;
            }
            throw SQLEngineExceptionFactory.invalidOperationException("Operation for coercion types is not compatiable: Operation: " + coercionOperation.name() + "type1: " + iColumnInfo.getType() + "type2: " + iColumnInfo2.getType());
        }
        return iColumn.getColumnLength();
    }

    public AEMetadataCoercionHandler.PrecisionScale calcPrecisionScale(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        if (this.isTimeOrTimestamp(sqlTypes)) {
            return this.coerceDatetimePrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
        }
        if (sqlTypes.isExactNum()) {
            return this.coerceExactNumPrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
        }
        return new AEMetadataCoercionHandler.PrecisionScale(iColumn.getTypeMetadata().getPrecision(), iColumn.getTypeMetadata().getScale());
    }

    public boolean coerceIsCurrency(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return !(!iColumnInfo.isCurrency() && !iColumnInfo2.isCurrency() || coercionOperation != AEMetadataCoercionHandler.CoercionOperation.DIVISION && coercionOperation != AEMetadataCoercionHandler.CoercionOperation.PLUS && coercionOperation != AEMetadataCoercionHandler.CoercionOperation.MINUS && coercionOperation != AEMetadataCoercionHandler.CoercionOperation.MULTIPLICATION);
    }

    public boolean coerceIsSigned(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo.getType());
        SqlTypes sqlTypes3 = SqlTypes.getValueOf(iColumnInfo2.getType());
        if (!sqlTypes.isNumber() || sqlTypes == SqlTypes.SQL_BIT) {
            return false;
        }
        if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.MINUS) {
            return true;
        }
        if (!sqlTypes2.isNumber() || !sqlTypes3.isNumber()) {
            return true;
        }
        return iColumnInfo.isSigned() || iColumnInfo2.isSigned();
    }

    public Nullable coerceNullable(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        Nullable nullable = iColumnInfo.getNullable();
        Nullable nullable2 = iColumnInfo2.getNullable();
        if (nullable == Nullable.NULLABLE || nullable2 == Nullable.NULLABLE) {
            return Nullable.NULLABLE;
        }
        if (nullable == Nullable.UNKNOWN || nullable2 == Nullable.UNKNOWN) {
            return Nullable.UNKNOWN;
        }
        return Nullable.NO_NULLS;
    }

    public boolean coerceIsCaseSensitive(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return iColumnInfo.isCaseSensitive() || iColumnInfo2.isCaseSensitive();
    }

    public Searchable coerceSearchability(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        Searchable searchable = iColumnInfo.getSearchable();
        Searchable searchable2 = iColumnInfo2.getSearchable();
        if (searchable == Searchable.PREDICATE_NONE || searchable2 == Searchable.PREDICATE_NONE) {
            return Searchable.PREDICATE_NONE;
        }
        if (searchable == Searchable.PREDICATE_CHAR | searchable2 == Searchable.PREDICATE_CHAR) {
            return Searchable.PREDICATE_CHAR;
        }
        if (searchable == Searchable.PREDICATE_BASIC || searchable2 == Searchable.PREDICATE_BASIC) {
            return Searchable.PREDICATE_BASIC;
        }
        return Searchable.SEARCHABLE;
    }

    public Updatable coerceUpdatability(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return Updatable.READ_ONLY;
    }

    public boolean coerceIsAutoUnique(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return false;
    }

    private AEMetadataCoercionHandler.PrecisionScale coerceExactNumPrecisionScale(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumnInfo.getType());
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo2.getType());
        short s = -1;
        short s2 = -1;
        if (sqlTypes.isNumber() && sqlTypes2.isNumber()) {
            short s3 = iColumnInfo.getScale();
            short s4 = iColumnInfo2.getScale();
            short s5 = iColumnInfo.getPrecision();
            short s6 = iColumnInfo2.getPrecision();
            short s7 = (short)Math.max(s3, s4);
            short s8 = (short)Math.max(s5 - s3, s6 - s4);
            switch (coercionOperation) {
                case COMPARISON: 
                case IN: 
                case SET_OPERATION: {
                    s = (short)(s8 + s7);
                    s2 = s7;
                    break;
                }
                case DIVISION: {
                    s = (short)(s5 - s3 + s4 + Math.max(6, s3 + s6 + 1));
                    s2 = (short)Math.max(6, s3 + s6 + 1);
                    break;
                }
                case MULTIPLICATION: {
                    s = (short)(s5 + s6 + 1);
                    s2 = (short)(s3 + s4);
                    break;
                }
                case PLUS: 
                case MINUS: {
                    s = (short)(s7 + s8 + 1);
                    s2 = s7;
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidOperationException("Coercion result does not match coercion operation: Operator: " + coercionOperation.name() + " , type1: " + sqlTypes.name() + ", type2: " + sqlTypes2.name());
                }
            }
            if (s > this.m_properties.getMaxExactNumPrecision()) {
                s2 = (short)Math.max(Math.min(s4, s3), s2 - (s - this.m_properties.getMaxExactNumPrecision()));
                s = this.m_properties.getMaxExactNumPrecision();
            }
        } else if (sqlTypes.isExactNum()) {
            s = iColumnInfo.getPrecision();
            s2 = iColumnInfo.getScale();
        } else if (sqlTypes2.isExactNum()) {
            s = iColumnInfo2.getPrecision();
            s2 = iColumnInfo2.getScale();
        } else {
            s = this.m_properties.getMaxExactNumPrecision();
            s2 = this.m_properties.getDefaultExactNumScale();
        }
        return new AEMetadataCoercionHandler.PrecisionScale(s, s2);
    }

    private AEMetadataCoercionHandler.PrecisionScale coerceDatetimePrecisionScale(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumnInfo.getType());
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo2.getType());
        SqlTypes sqlTypes3 = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        assert (sqlTypes3 == SqlTypes.SQL_TIME || sqlTypes3 == SqlTypes.SQL_TIMESTAMP);
        short s = -1;
        s = this.isTimeOrTimestamp(sqlTypes) && this.isTimeOrTimestamp(sqlTypes2) ? (short)((short)Math.max(iColumnInfo.getPrecision(), iColumnInfo2.getPrecision())) : (this.isTimeOrTimestamp(sqlTypes) ? (short)iColumnInfo.getPrecision() : (this.isTimeOrTimestamp(sqlTypes2) ? (short)iColumnInfo2.getPrecision() : (sqlTypes3 == SqlTypes.SQL_TIME ? this.m_properties.getMaxTimePrecision() : this.m_properties.getMaxTimestampPrecision())));
        return new AEMetadataCoercionHandler.PrecisionScale(s, s);
    }

    private boolean isTimeOrTimestamp(SqlTypes sqlTypes) {
        return sqlTypes == SqlTypes.SQL_TIME || sqlTypes == SqlTypes.SQL_TIMESTAMP;
    }
}

