/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.BitSet;

public abstract class DSIExtJResultSet
implements IResultSet {
    private BitSet m_needData;

    public abstract String getCatalogName();

    public boolean getDataNeeded(int n) {
        if (null != this.m_needData) {
            return this.m_needData.get(n);
        }
        return false;
    }

    public int getFetchSize() throws ErrorException {
        return 0;
    }

    public boolean hasMoreRows() throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("IResult.hasMoreRows()");
    }

    public abstract String getSchemaName();

    public abstract String getTableName();

    public void onFinishDMLBatch() throws ErrorException {
    }

    public void onFinishRowUpdate() throws ErrorException {
    }

    public void onStartDMLBatch(DMLType dMLType, long l) throws ErrorException {
    }

    public void onStartRowUpdate() {
    }

    public abstract void reset() throws ErrorException;

    public int resolveColumn(DSIExtJResultSet dSIExtJResultSet, int n) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    public void setDataNeeded(int n) throws ErrorException {
        if (null == this.m_needData) {
            this.m_needData = new BitSet(n);
        }
        this.m_needData.set(n);
    }

    public void setFetchSize(int n) throws ErrorException {
    }

    public final boolean supportsHasMoreRows() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DMLType {
        INSERT,
        UPDATE,
        UPSERT,
        DELETE;

    }
}

