/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.datawrapper;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigInteger;

public final class SqlSmallIntDataWrapper
extends DefaultSqlDataWrapper {
    private int m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;

    public BigInteger getBigInt() throws ErrorException, NullPointerException {
        return BigInteger.valueOf(this.getData());
    }

    public double getDouble() throws ErrorException, NullPointerException {
        return this.getData();
    }

    public float getReal() throws ErrorException, NullPointerException {
        return this.getData();
    }

    public long getInteger() throws ErrorException, NullPointerException {
        return this.getData();
    }

    public int getSmallInt() throws ErrorException, NullPointerException {
        return this.getData();
    }

    public int getType() {
        return 5;
    }

    public boolean isNull() {
        return this.m_isNull;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_isNull = false;
        this.m_data = bl ? 1 : 0;
    }

    public void setSmallInt(int n) {
        this.m_isSet = true;
        this.m_data = n;
        this.m_isNull = false;
    }

    public void setTinyInt(short s) {
        this.m_isSet = true;
        this.m_data = s;
        this.m_isNull = false;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    private int getData() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Integer requested, but the data is null.");
        }
        return this.m_data;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case 5: {
                        this.setSmallInt(dataWrapper.getSmallInt());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(5);
            return;
        }
        dataWrapper.setSmallInt(this.m_data);
    }
}

