/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation.join;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.amazon.sqlengine.executor.etree.ETCancelState;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.join.AbstractJoinAlgorithmAdaper;
import com.amazon.sqlengine.executor.etree.relation.join.IMasterJoinUnit;
import com.amazon.sqlengine.executor.etree.relation.join.ISlaveJoinUnit;
import com.amazon.sqlengine.executor.etree.relation.join.InMemJoinUnit;
import com.amazon.sqlengine.executor.etree.relation.join.RelationWrapperJoinUnit;
import com.amazon.sqlengine.utilities.ExternalAlgorithmUtil;
import com.amazon.support.ILogger;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBJoinAlgorithm
extends AbstractJoinAlgorithmAdaper {
    private static final String PACKAGE_NAME = "com.amazon.sqlengine.executor.etree.relation.join";
    private static final String CLASS_NAME = "NBJoinAlgorithm";
    private ETRelationalExpr m_slaveRelation;
    private InMemJoinUnit m_slaveUnit;
    private RelationWrapperJoinUnit m_masterUnit;
    private final boolean m_isMasterOnLeft;
    private boolean m_haveMoreSlaveRows;
    private boolean[] m_slaveDataNeeded;
    private IMemManagerAgent m_memManagerAgent;
    private long m_memAvailable;
    private boolean m_firstUnitsLoaded;
    private ILogger m_logger;
    private final ETCancelState m_cancelState;

    public NBJoinAlgorithm(ETRelationalExpr eTRelationalExpr, ETRelationalExpr eTRelationalExpr2, AEJoin.AEJoinType aEJoinType, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, ETCancelState eTCancelState, ILogger iLogger) throws ErrorException {
        super(aEJoinType);
        int n;
        this.m_logger = iLogger;
        ETRelationalExpr eTRelationalExpr3 = null;
        if (aEJoinType == AEJoin.AEJoinType.RIGHT_OUTER_JOIN) {
            this.m_isMasterOnLeft = true;
            eTRelationalExpr3 = eTRelationalExpr;
            this.m_slaveRelation = eTRelationalExpr2;
        } else {
            this.m_isMasterOnLeft = false;
            eTRelationalExpr3 = eTRelationalExpr2;
            this.m_slaveRelation = eTRelationalExpr;
        }
        IColumn[] iColumnArray = new IColumn[this.m_slaveRelation.getColumnCount()];
        for (n = 0; n < iColumnArray.length; ++n) {
            iColumnArray[n] = this.m_slaveRelation.getColumn(n);
        }
        this.m_cancelState = eTCancelState;
        this.m_slaveDataNeeded = new boolean[this.m_slaveRelation.getColumnCount()];
        for (n = 0; n < this.m_slaveRelation.getColumnCount(); ++n) {
            if (!this.m_slaveRelation.getDataNeeded(n)) continue;
            this.m_slaveDataNeeded[n] = true;
        }
        this.m_slaveUnit = new InMemJoinUnit(iColumnArray, externalAlgorithmProperties, this.m_slaveDataNeeded);
        this.m_haveMoreSlaveRows = true;
        this.m_masterUnit = new RelationWrapperJoinUnit(eTRelationalExpr3, externalAlgorithmProperties, this.m_joinType == AEJoin.AEJoinType.FULL_OUTER_JOIN);
        this.m_firstUnitsLoaded = false;
    }

    @Override
    public boolean moveMasterUnmatch() throws ErrorException {
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "moveMasterUnmatch");
        }
        if (!this.m_haveMoreSlaveRows && this.m_masterUnit.isCurRowUnmatched()) {
            return super.moveMasterUnmatch();
        }
        return this.m_masterUnit.moveToNextRow();
    }

    private void loadSlaveUnit() throws ErrorException {
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "loadSlaveUnit");
        }
        if (!this.m_slaveUnit.canAppendRow()) {
            throw new IllegalStateException("Not enough memory assigned.");
        }
        this.m_cancelState.checkCancel();
        while (this.m_slaveUnit.canAppendRow() && this.m_haveMoreSlaveRows) {
            this.m_slaveUnit.appendRow(this.m_slaveRelation);
            this.m_haveMoreSlaveRows = this.m_slaveRelation.move();
        }
    }

    @Override
    public boolean isMasterJoinUnitOnLeft() {
        return this.m_isMasterOnLeft;
    }

    @Override
    public void closeRelations() {
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "closeRelations");
        }
        this.m_slaveUnit.close();
        this.m_slaveRelation.close();
        this.m_masterUnit.closeRelation();
        this.m_memManagerAgent.recycleMemory(this.m_memAvailable);
        this.m_memAvailable = 0L;
        this.m_memManagerAgent.unregisterConsumer();
    }

    @Override
    public void reset() throws ErrorException {
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "reset");
        }
        this.m_slaveRelation.reset();
        this.m_haveMoreSlaveRows = this.m_slaveRelation.move();
        this.m_masterUnit.reset();
        this.m_slaveUnit.reset();
    }

    @Override
    public Pair<ISlaveJoinUnit, IMasterJoinUnit> loadMasterSlave() throws ErrorException {
        long l;
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "loadMasterSlave");
        }
        if (this.m_firstUnitsLoaded && !this.m_haveMoreSlaveRows || !this.m_firstUnitsLoaded && this.m_joinType != AEJoin.AEJoinType.FULL_OUTER_JOIN && !this.m_haveMoreSlaveRows) {
            if (null != this.m_logger) {
                this.m_logger.logTrace(PACKAGE_NAME, CLASS_NAME, "loadMasterSlave", "No more join units.");
            }
            return null;
        }
        if (this.m_firstUnitsLoaded) {
            this.m_slaveUnit.reset();
            this.m_masterUnit.resetRelation();
        } else {
            this.m_firstUnitsLoaded = true;
        }
        this.loadSlaveUnit();
        if (!this.m_haveMoreSlaveRows && (l = this.m_slaveUnit.reduceMemoryUsage()) > 0L) {
            this.m_memManagerAgent.recycleMemory(l);
            this.m_memAvailable -= l;
        }
        return new Pair<ISlaveJoinUnit, IMasterJoinUnit>(this.m_slaveUnit, this.m_masterUnit);
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_memManagerAgent = iMemManagerAgent;
    }

    @Override
    public long assign(long l) {
        long l2;
        if ((l -= (l2 = this.m_masterUnit.assignMemory(l))) < 0L) {
            throw new IllegalArgumentException("Master unit take more memory than assigned.");
        }
        if (l > 0L && this.m_haveMoreSlaveRows) {
            this.m_slaveUnit.assignMemory(l);
            l2 += l;
        }
        this.m_memAvailable += l2;
        if (null != this.m_logger) {
            this.m_logger.logTrace(PACKAGE_NAME, CLASS_NAME, "assign", "Memory assigned: " + l2);
        }
        return l2;
    }

    @Override
    public long getRequiredMemory() {
        return this.m_slaveUnit.getRequiredMemory() + this.m_masterUnit.getRequiredMemory();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "open");
        }
        this.m_slaveRelation.open(CursorType.FORWARD_ONLY);
        this.m_haveMoreSlaveRows = this.m_slaveRelation.move();
        this.m_masterUnit.openRelation();
        this.m_firstUnitsLoaded = false;
    }
}

