/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.conversions.ConversionUtil;
import com.amazon.sqlengine.executor.conversions.ISqlConverter;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.value.ETUnaryValueExpr;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ETConvert
extends ETUnaryValueExpr {
    private final ETDataRequest m_sourceData;
    private final ISqlConverter m_converter;
    private final boolean m_errorOnTruncation;

    public ETConvert(ETValueExpr eTValueExpr, IColumn iColumn, ISqlConverter iSqlConverter) throws ErrorException {
        this(eTValueExpr, iColumn, iSqlConverter, false);
    }

    public ETConvert(ETValueExpr eTValueExpr, IColumn iColumn, ISqlConverter iSqlConverter, boolean bl) throws ErrorException {
        super(eTValueExpr);
        this.m_sourceData = new ETDataRequest(iColumn);
        this.m_sourceData.setMaxBytes(-1L);
        this.m_sourceData.setOffset(0L);
        this.m_converter = iSqlConverter;
        this.m_errorOnTruncation = bl;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        boolean bl = this.getOperand().retrieveData(this.m_sourceData);
        if (bl) {
            throw new IllegalStateException("Has more data after retrieve all data");
        }
        return ConversionUtil.doConvert(eTDataRequest, this.m_sourceData.getData(), this.m_converter, this.getWarningListener(), this.m_errorOnTruncation);
    }
}

