/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.AEUtils;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.conversions.ConversionUtil;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.ExactNumConverter;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETTruncateFn
extends ETScalarFn {
    public ETTruncateFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (AEUtils.isTypeNumeric(iColumn.getTypeMetadata().getType()));
        assert (2 == this.getNumChildren());
        assert (AEUtils.isTypeNumeric(list2.get(0).getTypeMetadata().getType()));
        assert (list2.get(0).getTypeMetadata().getType() == iColumn.getTypeMetadata().getType());
        assert (4 == list2.get(1).getTypeMetadata().getType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l = iSqlDataWrapper2.getInteger();
        if (l > 32767L || l < -32768L) {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("TRUNCATE", 2);
        }
        switch (iSqlDataWrapper.getType()) {
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.truncate(iSqlDataWrapper.getExactNumber(), (short)l);
                eTDataRequest.getData().setExactNumber(bigDecimal);
                break;
            }
            case -5: {
                BigInteger bigInteger = iSqlDataWrapper.getBigInt();
                if (l < 0L) {
                    bigInteger = -l < 20L ? this.truncate(bigInteger, (short)l) : BigInteger.ZERO;
                }
                eTDataRequest.getData().setBigInt(bigInteger);
                break;
            }
            case 4: {
                long l2 = iSqlDataWrapper.getInteger();
                if (l < 0L) {
                    if (-l < 10L) {
                        BigInteger bigInteger = this.truncate(BigInteger.valueOf(l2), (short)l);
                        l2 = bigInteger.longValue();
                    } else {
                        l2 = 0L;
                    }
                }
                eTDataRequest.getData().setInteger(l2);
                break;
            }
            case 5: {
                int n = iSqlDataWrapper.getSmallInt();
                if (l < 0L) {
                    BigInteger bigInteger = this.truncate(BigInteger.valueOf(n), (short)l);
                    n = bigInteger.intValue();
                }
                eTDataRequest.getData().setSmallInt(n);
                break;
            }
            case -6: {
                short s = iSqlDataWrapper.getTinyInt();
                if (l < 0L) {
                    BigInteger bigInteger = this.truncate(BigInteger.valueOf(s), (short)l);
                    s = bigInteger.shortValue();
                }
                eTDataRequest.getData().setTinyInt(s);
                break;
            }
            case 6: 
            case 8: {
                BigDecimal bigDecimal = this.truncate(new BigDecimal(iSqlDataWrapper.getDouble()), (short)l);
                eTDataRequest.getData().setDouble(bigDecimal.doubleValue());
                break;
            }
            case 7: {
                BigDecimal bigDecimal = this.truncate(new BigDecimal(iSqlDataWrapper.getReal()), (short)l);
                eTDataRequest.getData().setReal((float)bigDecimal.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data type to TRUNCATE scalar: " + this.getArgumentData(0).getType());
            }
        }
        return false;
    }

    private BigInteger truncate(BigInteger bigInteger, short s) {
        if (s < 0) {
            BigInteger bigInteger2 = bigInteger.remainder(BigInteger.TEN.pow(-s));
            bigInteger = bigInteger.subtract(bigInteger2);
        }
        return bigInteger;
    }

    private BigDecimal truncate(BigDecimal bigDecimal, short s) throws ErrorException {
        IColumn iColumn;
        int n;
        boolean bl = false;
        if (0 > s) {
            bl = true;
            s = 0;
        }
        if (0 > (n = (iColumn = this.getInputMetadata(0)).getTypeMetadata().getPrecision() - iColumn.getTypeMetadata().getScale() + s) || n > Short.MAX_VALUE) {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("TRUNCATE", 2);
        }
        ConversionResult conversionResult = new ConversionResult();
        BigDecimal bigDecimal2 = ExactNumConverter.setPrecScale(bigDecimal, (short)n, s, conversionResult);
        ConversionUtil.checkForErrorOnly(conversionResult, false, -1, -1);
        if (bl) {
            bigDecimal2 = bigDecimal2.setScale((int)this.getArgumentData(1).getInteger(), RoundingMode.DOWN);
        }
        return bigDecimal2;
    }
}

