/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.materializer;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEExcept;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESort;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETable;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETop;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.amazon.sqlengine.executor.etree.relation.ETProject;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.ETSelect;
import com.amazon.sqlengine.executor.etree.relation.ETSort;
import com.amazon.sqlengine.executor.etree.relation.ETTable;
import com.amazon.sqlengine.executor.etree.relation.ETTableConstructor;
import com.amazon.sqlengine.executor.etree.relation.ETTop;
import com.amazon.sqlengine.executor.etree.relation.ETUnionAll;
import com.amazon.sqlengine.executor.etree.temptable.SortedTemporaryTable;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.ETValueExprList;
import com.amazon.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.amazon.sqlengine.executor.materializer.ETAggregateMaterializer;
import com.amazon.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.amazon.sqlengine.executor.materializer.ETJoinMaterializer;
import com.amazon.sqlengine.executor.materializer.ETTableMaterializer;
import com.amazon.sqlengine.executor.materializer.ETValueExprMaterializer;
import com.amazon.sqlengine.executor.materializer.MaterializerBase;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.sqlengine.executor.queryplan.IQueryPlan;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETRelationalExprMaterializer
extends MaterializerBase<ETRelationalExpr> {
    private boolean m_errorOnTruncate = false;

    public ETRelationalExprMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public ETRelationalExpr visit(AEAggregate aEAggregate) throws ErrorException {
        return new ETAggregateMaterializer(this, this.getQueryPlan(), this.getContext()).visit(aEAggregate);
    }

    @Override
    public ETRelationalExpr visit(AECrossJoin aECrossJoin) throws ErrorException {
        return new ETJoinMaterializer(this.getQueryPlan(), this.getContext(), aECrossJoin).materialize();
    }

    @Override
    public ETRelationalExpr visit(AEDistinct aEDistinct) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("DISTINCT");
    }

    @Override
    public ETRelationalExpr visit(AEJoin aEJoin) throws ErrorException {
        return new ETJoinMaterializer(this.getQueryPlan(), this.getContext(), aEJoin).materialize();
    }

    @Override
    public ETProject visit(AEProject aEProject) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aEProject);
        ETRelationalExpr eTRelationalExpr = aEProject.getOperand().acceptVisitor(new ETRelationalExprMaterializer(this.getQueryPlan(), this.getContext()));
        ETValueExprList eTValueExprList = new ETValueExprList();
        Iterator iterator = aEProject.getProjectionList().getChildItr();
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
            arrayList.add(aEValueExpr.getColumn());
            eTValueExprList.addNode((IETNode)aEValueExpr.acceptVisitor(new ETValueExprMaterializer(this.getQueryPlan(), this.getContext())));
        }
        return new ETProject(eTRelationalExpr, eTValueExprList, arrayList, blArray);
    }

    @Override
    public ETRelationalExpr visit(AESelect aESelect) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aESelect);
        ETRelationalExpr eTRelationalExpr = aESelect.getOperand().acceptVisitor(this);
        ETBooleanExpr eTBooleanExpr = aESelect.getCondition().acceptVisitor(new ETBoolExprMaterializer(this.getQueryPlan(), this.getContext()));
        return new ETSelect(eTRelationalExpr, eTBooleanExpr, blArray);
    }

    @Override
    public ETRelationalExpr visit(AESort aESort) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aESort.getOperand());
        ETRelationalExpr eTRelationalExpr = aESort.getOperand().acceptVisitor(this);
        int n = eTRelationalExpr.getColumnCount();
        List<IColumn> list = new ArrayList<IColumn>(n);
        for (int i = 0; i < n; ++i) {
            list.add(eTRelationalExpr.getColumn(i));
        }
        MaterializerContext materializerContext = this.getContext();
        TemporaryTableBuilder temporaryTableBuilder = new TemporaryTableBuilder(list, materializerContext.getDataEngineContext().getDataEngine(), materializerContext.getExternalAlgorithmProperties(), materializerContext.getCancelState(), blArray);
        SortedTemporaryTable sortedTemporaryTable = temporaryTableBuilder.sortSpec(aESort.getSortSpecs()).buildSorted();
        if (aESort.getColumnCount() < n) {
            list = list.subList(0, aESort.getColumnCount());
        }
        list = new ArrayList<IColumn>(list);
        return new ETSort(eTRelationalExpr, list, sortedTemporaryTable, blArray);
    }

    @Override
    public ETRelationalExpr visit(AESubQuery aESubQuery) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("subquery");
    }

    @Override
    public ETTable visit(AETable aETable) throws ErrorException {
        ETTable eTTable = aETable.acceptVisitor(new ETTableMaterializer(this.getQueryPlan(), this.getContext()));
        return eTTable;
    }

    @Override
    public ETRelationalExpr visit(AETableConstructor aETableConstructor) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aETableConstructor);
        ETValueExprMaterializer eTValueExprMaterializer = new ETValueExprMaterializer(this.getQueryPlan(), this.getContext());
        List<IColumn> list = aETableConstructor.getResultSetColumns();
        ETTableConstructor eTTableConstructor = null;
        for (int i = aETableConstructor.getNumChildren() - 1; i >= 0; --i) {
            ETValueExprList eTValueExprList = new ETValueExprList();
            int n = 0;
            for (AEValueExpr aEValueExpr : aETableConstructor.getRow(i)) {
                eTValueExprList.addNode(ConvMaterializeUtil.addConversionNodeWhenNeeded(aEValueExpr.acceptVisitor(eTValueExprMaterializer), aEValueExpr.getColumn(), list.get(n++), this.isErrorOnTruncate(), this.getContext()));
            }
            ETTableConstructor eTTableConstructor2 = new ETTableConstructor(eTValueExprList, aETableConstructor.getResultSetColumns(), blArray);
            eTTableConstructor = null == eTTableConstructor ? eTTableConstructor2 : new ETUnionAll(eTTableConstructor2, eTTableConstructor, blArray);
        }
        return eTTableConstructor;
    }

    @Override
    public ETRelationalExpr visit(AETop aETop) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aETop);
        ETRelationalExpr eTRelationalExpr = aETop.getOperand().acceptVisitor(this);
        ETValueExpr eTValueExpr = aETop.getSelectLimitExpr().acceptVisitor(new ETValueExprMaterializer(this.getQueryPlan(), this.getContext()));
        return new ETTop(eTRelationalExpr, blArray, eTValueExpr, aETop.isPercent());
    }

    @Override
    public ETRelationalExpr visit(AEUnion aEUnion) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("UNION");
    }

    @Override
    public ETRelationalExpr visit(AEExcept aEExcept) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("EXCEPT");
    }

    public boolean isErrorOnTruncate() {
        return this.m_errorOnTruncate;
    }

    public void setErrorOnTruncate(boolean bl) {
        this.m_errorOnTruncate = bl;
    }

    private static boolean[] calculateDataNeeded(AERelationalExpr aERelationalExpr) {
        boolean[] blArray = new boolean[aERelationalExpr.getColumnCount()];
        for (int i = 0; i < blArray.length; ++i) {
            if (!aERelationalExpr.getDataNeeded(i)) continue;
            blArray[i] = true;
        }
        return blArray;
    }
}

