/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.BigNum;
import yeti.lang.ByteArray;
import yeti.lang.FloatNum;
import yeti.lang.Fun;
import yeti.lang.IntNum;
import yeti.lang.MList;
import yeti.lang.Num;
import yeti.lang.RatNum;
import yeti.lang.Unsafe;

public final class Core {
    private static final int[] DEC_SHIFT = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final String UNDEF_STR = new String();
    public static final ThreadLocal ARGV = new ThreadLocal(){

        protected Object initialValue() {
            return new MList();
        }
    };
    private static final char[] base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static String replace(String string2, String string3, String string4) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string4.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string4.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + n3;
        }
        if (n2 < string4.length()) {
            stringBuffer.append(string4.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static Num parseNum(String string2) {
        int n;
        String string3 = string2.trim();
        int n2 = string3.length();
        if (n2 == 0) {
            throw new IllegalArgumentException("Number expected");
        }
        int n3 = 10;
        int n4 = n = string3.charAt(0) == '-' ? 1 : 0;
        if (n2 > 2 && string3.charAt(n) == '0') {
            switch (string3.charAt(n + 1)) {
                case 'O': 
                case 'o': {
                    n3 = 2;
                }
                case 'X': 
                case 'x': {
                    string3 = string3.substring(n += 2);
                    if (n != 2) {
                        string3 = "-".concat(string3);
                    }
                    n3 += 6;
                }
            }
        }
        if (n3 == 10) {
            if (string3.indexOf(101) >= 0 || string3.indexOf(69) >= 0) {
                char c2 = string3.charAt(n2 - 1);
                if (c2 == 'e' || c2 == 'E') {
                    return new FloatNum(Double.parseDouble(string3.substring(0, n2 - 1)));
                }
                return new FloatNum(Double.parseDouble(string3));
            }
            int n5 = string3.indexOf(46);
            if (n5 == n2 - 1) {
                string3 = string3.substring(0, n5);
                n5 = -1;
            }
            if (n5 > 0) {
                while (string3.charAt(--n2) == '0') {
                }
                if (string3.charAt(n2) == '.') {
                    string3 = string3.substring(0, n2);
                } else {
                    long l2;
                    if (n2 <= 11 && (l2 = Long.parseLong(string3.substring(0, n5).concat(string3.substring(n5 + 1, n2 + 1)))) >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
                        return new RatNum((int)l2, DEC_SHIFT[n2 - n5]);
                    }
                    return new FloatNum(Double.parseDouble(string3));
                }
            }
        }
        if (n2 - n < 96 / n3 + 10) {
            return new IntNum(Long.parseLong(string3, n3));
        }
        return new BigNum(string3, n3);
    }

    public static String concat(String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            n += stringArray[n2].length();
        }
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[n];
        int n3 = 0;
        int n4 = stringArray.length;
        for (int i = 0; i < n4; ++i) {
            String string2 = stringArray[i];
            n = string2.length();
            string2.getChars(0, n, cArray, n3);
            n3 += n;
        }
        return new String(cArray);
    }

    public static String show(Object object) {
        if (object == null) {
            return "[]";
        }
        if (object instanceof String) {
            int n;
            char[] cArray = ((String)object).toCharArray();
            StringBuffer stringBuffer = new StringBuffer().append('\"');
            int n2 = 0;
            int n3 = cArray.length;
            for (n = 0; n < n3; ++n) {
                String string2;
                if (cArray[n] == '\\') {
                    string2 = "\\\\";
                } else if (cArray[n] == '\"') {
                    string2 = "\\\"";
                } else if (cArray[n] == '\n') {
                    string2 = "\\n";
                } else if (cArray[n] == '\r') {
                    string2 = "\\r";
                } else if (cArray[n] == '\t') {
                    string2 = "\\t";
                } else {
                    if (cArray[n] < '\u0000' || cArray[n] >= ' ') continue;
                    string2 = "000".concat(Integer.toHexString(cArray[n]));
                    string2 = "\\u".concat(string2.substring(string2.length() - 4));
                }
                stringBuffer.append(cArray, n2, n - n2).append(string2);
                n2 = n + 1;
            }
            return stringBuffer.append(cArray, n2, n - n2).append('\"').toString();
        }
        if (object.getClass().isArray()) {
            StringBuffer stringBuffer = new StringBuffer().append('[');
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuffer.append(',');
                }
                if (i == 50 && n > 110) {
                    stringBuffer.append("...");
                    i = n - 50;
                }
                stringBuffer.append(Array.get(object, i));
            }
            return stringBuffer.append(']').toString();
        }
        return object.toString();
    }

    static String read(Reader reader, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = reader.read(cArray, 0, n);
        return n2 < 0 ? null : new String(cArray, 0, n2);
    }

    static String readAll(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[8192];
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AList readAll(int n, Fun fun, Fun fun2) {
        byte[] byArray = new byte[0 < n && n <= 65536 ? n : 8192];
        int n2 = 0;
        try {
            int n3;
            while ((n3 = ((Number)fun.apply(byArray, new IntNum(n2))).intValue()) >= 0) {
                if (byArray.length - (n2 += n3) >= 2048) continue;
                int n4 = byArray.length << 1;
                if (n > 0 && n4 > n) {
                    if (byArray.length >= n) {
                        Unsafe.unsafeThrow(new IOException("Read limit " + n + " exceeded"));
                    }
                    n4 = n;
                }
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
            }
        }
        finally {
            fun2.apply(null);
        }
        return n2 > 0 ? new ByteArray(0, n2, byArray) : null;
    }

    public static void setArgv(String[] stringArray) {
        if (stringArray != null) {
            ARGV.set(new MList(stringArray));
        }
    }

    public static Object badMatch(Object object) {
        throw new IllegalArgumentException("bad match (" + object + ')');
    }

    public static String capitalize(String string2) {
        char[] cArray = string2.toCharArray();
        if (cArray.length == 0) {
            return string2;
        }
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    static String uncapitalize(String string2) {
        char[] cArray = string2.toCharArray();
        if (cArray.length == 0) {
            return string2;
        }
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static String b64enc(byte[] byArray, int n) {
        char[] cArray = new char[(n + 2) / 3 * 4];
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            cArray[n3] = base64[byArray[n2] >>> 2 & 0x3F];
            cArray[n3 + 1] = base64[(byArray[n2] & 3) << 4 | (n > 1 ? byArray[n2 + 1] >>> 4 & 0xF : 0)];
            cArray[n3 + 2] = n > 1 ? base64[(byArray[n2 + 1] & 0xF) << 2 | (n > 2 ? byArray[n2 + 2] >>> 6 & 3 : 0)] : 61;
            cArray[n3 + 3] = n > 2 ? base64[byArray[n2 + 2] & 0x3F] : 61;
            n2 += 3;
            n3 += 4;
            n -= 3;
        }
        return new String(cArray);
    }

    static AList b64dec(String string2) throws Exception {
        int n = 0;
        int n2 = 0;
        byte[] byArray = new byte[string2.length() * 3 / 4];
        int n3 = string2.length();
        for (int i = 0; i < n3; ++i) {
            int n4;
            char c2 = string2.charAt(i);
            int n5 = c2 == '+' ? 62 : (c2 == '/' ? 63 : (c2 >= 'A' && c2 <= 'Z' ? c2 - 65 : (c2 >= 'a' && c2 <= 'z' ? c2 - 71 : (n4 = c2 >= '0' && c2 <= '9' ? c2 + 4 : -1))));
            if (n4 == -1) {
                if (c2 != '=') continue;
                break;
            }
            switch (n) {
                case 0: {
                    byArray[n2] = (byte)(n4 << 2);
                    break;
                }
                case 1: {
                    int n6 = n2;
                    byArray[n6] = (byte)(byArray[n6] | n4 >>> 4);
                    byArray[n2 + 1] = (byte)((n4 & 0xF) << 4);
                    break;
                }
                case 2: {
                    int n7 = n2 + 1;
                    byArray[n7] = (byte)(byArray[n7] | n4 >>> 2);
                    byArray[n2 + 2] = (byte)((n4 & 3) << 6);
                    break;
                }
                case 3: {
                    int n8 = n2 + 2;
                    byArray[n8] = (byte)(byArray[n8] | n4);
                    n2 += 3;
                    n = -1;
                }
            }
            ++n;
        }
        if (n > 0) {
            n2 += n - 1;
        }
        return n2 > 0 ? new ByteArray(0, n2, byArray) : null;
    }

    public static byte[] bytes(AList aList) {
        if (aList == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AIter aIter = aList;
            aList = null;
            while (aIter != null) {
                aIter = aIter.write(byteArrayOutputStream);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

