/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import yeti.lang.FloatNum;
import yeti.lang.IntNum;
import yeti.lang.Num;
import yeti.lang.RatNum;

public final class BigNum
extends Num {
    private final BigInteger v;

    public BigNum(long l2) {
        this.v = BigInteger.valueOf(l2);
    }

    public BigNum(BigInteger bigInteger) {
        this.v = bigInteger;
    }

    public BigNum(String string2, int n) {
        this.v = new BigInteger(string2, n);
    }

    public Num add(Num num) {
        return num.add(this.v);
    }

    public Num add(RatNum ratNum) {
        return ratNum.add(this.v);
    }

    public Num add(BigInteger bigInteger) {
        return new BigNum(bigInteger.add(this.v));
    }

    public Num add(long l2) {
        return new BigNum(this.v.add(BigInteger.valueOf(l2)));
    }

    public Num mul(Num num) {
        return num.mul(this.v);
    }

    public Num mul(long l2) {
        return new BigNum(this.v.multiply(BigInteger.valueOf(l2)));
    }

    public Num mul(RatNum ratNum) {
        return ratNum.mul(this.v);
    }

    public Num mul(BigInteger bigInteger) {
        return new BigNum(bigInteger.multiply(this.v));
    }

    public Num div(Num num) {
        return new FloatNum(this.v.doubleValue() / num.doubleValue());
    }

    public Num div(long l2) {
        return new FloatNum(this.v.doubleValue() / (double)l2);
    }

    public Num divFrom(long l2) {
        return new FloatNum((double)l2 / this.v.doubleValue());
    }

    public Num divFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() / this.v.doubleValue());
    }

    public Num intDiv(Num num) {
        return num.intDivFrom(this.v);
    }

    public Num intDiv(int n) {
        return new BigNum(this.v.divide(BigInteger.valueOf(n)));
    }

    public Num intDivFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.divide(this.v));
    }

    public Num intDivFrom(long l2) {
        return new IntNum(BigInteger.valueOf(l2).divide(this.v).longValue());
    }

    public Num rem(Num num) {
        return num.remFrom(this.v);
    }

    public Num rem(int n) {
        return new IntNum(this.v.remainder(BigInteger.valueOf(n)).longValue());
    }

    public Num remFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.remainder(this.v));
    }

    public Num remFrom(long l2) {
        return new IntNum(BigInteger.valueOf(l2).remainder(this.v).longValue());
    }

    public Num sub(Num num) {
        return num.subFrom(this.v);
    }

    public Num sub(long l2) {
        return new BigNum(this.v.subtract(BigInteger.valueOf(l2)));
    }

    public Num subFrom(long l2) {
        return new BigNum(BigInteger.valueOf(l2).subtract(this.v));
    }

    public Num subFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() - this.v.doubleValue());
    }

    public Num subFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.subtract(this.v));
    }

    public Num shl(int n) {
        return new BigNum(this.v.shiftLeft(n));
    }

    public Num and(Num num) {
        return num.and(this.v);
    }

    public Num and(BigInteger bigInteger) {
        return new BigNum(this.v.and(bigInteger));
    }

    public Num or(Num num) {
        return new BigNum(this.v.or(num.toBigInteger()));
    }

    public Num or(long l2) {
        return new BigNum(this.v.or(BigInteger.valueOf(l2)));
    }

    public Num xor(Num num) {
        return new BigNum(this.v.xor(num.toBigInteger()));
    }

    public Num xor(long l2) {
        return new BigNum(this.v.xor(BigInteger.valueOf(l2)));
    }

    public byte byteValue() {
        return this.v.byteValue();
    }

    public short shortValue() {
        return this.v.shortValue();
    }

    public int intValue() {
        return this.v.intValue();
    }

    public long longValue() {
        return this.v.longValue();
    }

    public float floatValue() {
        return this.v.floatValue();
    }

    public double doubleValue() {
        return this.v.doubleValue();
    }

    public BigInteger toBigInteger() {
        return this.v;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.v);
    }

    public int compareTo(Object object) {
        return ((Num)object).rCompare(this.v);
    }

    public int rCompare(long l2) {
        return BigInteger.valueOf(l2).compareTo(this.v);
    }

    public int rCompare(RatNum ratNum) {
        return -ratNum.rCompare(this.v);
    }

    public int rCompare(BigInteger bigInteger) {
        return bigInteger.compareTo(this.v);
    }

    public String toString() {
        return this.v.toString();
    }

    public int hashCode() {
        if (this.v.bitLength() > 63) {
            return this.v.hashCode();
        }
        long l2 = this.v.longValue();
        return (int)(l2 ^ l2 >>> 32);
    }
}

