/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.io.Serializable;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.Fun;
import yeti.lang.IntNum;
import yeti.lang.LList;
import yeti.lang.MList;
import yeti.lang.MapList;
import yeti.lang.Num;
import yeti.lang.RangeIter;

public final class ListRange
extends AList
implements Serializable {
    final Num first;
    final Num last;
    final AList rest;
    final int inc;

    private ListRange(Num num, Num num2, AList aList) {
        this.first = num;
        this.last = num2;
        this.rest = aList;
        this.inc = 1;
    }

    private ListRange(Num num, Num num2, AList aList, int n) {
        this.first = num;
        this.last = num2;
        this.rest = aList;
        this.inc = n;
    }

    public static AList range(Object object, Object object2, AList aList) {
        Num num = (Num)object;
        return num.compareTo(object2) > 0 ? aList : new ListRange(num, (Num)object2, aList);
    }

    public Object first() {
        return this.first;
    }

    public AList rest() {
        Num num = this.first.add(this.inc);
        if (num.compareTo(this.last) * this.inc > 0) {
            return this.rest;
        }
        return new ListRange(num, this.last, this.rest, this.inc);
    }

    public AIter next() {
        Num num = this.first.add(this.inc);
        if (num.compareTo(this.last) * this.inc > 0) {
            return this.rest;
        }
        return new RangeIter(num, this.last, this.rest, this.inc);
    }

    public AList take(int n, int n2) {
        Num num;
        Num num2 = this.first;
        if (n2 == 0) {
            return null;
        }
        if (n > 0 && (num2 = num2.add(this.inc * n)).compareTo(this.last) * this.inc > 0) {
            if (this.rest == null) {
                return null;
            }
            return this.rest.take(n - (this.last.sub(this.first).intValue() * this.inc + 1), n2);
        }
        AList aList = null;
        if (n2 < 0) {
            num = this.last;
            aList = this.rest;
        } else {
            num = num2.add(this.inc * (n2 - 1));
            if (num.compareTo(this.last) * this.inc > 0) {
                if (this.rest != null) {
                    aList = this.rest.take(0, num.sub(this.last).intValue() * this.inc);
                }
                num = this.last;
            }
        }
        return new ListRange(num2, num, aList, this.inc);
    }

    public int hashCode() {
        int n = 1;
        Object object = this.first;
        while (object.compareTo(this.last) <= 0) {
            n = 31 * n + object.hashCode();
            object = ((Num)object).add(this.inc);
        }
        for (object = this.rest; object != null; object = ((AIter)object).next()) {
            Object object2 = ((AIter)object).first();
            n = 31 * n + (object2 == null ? 0 : object2.hashCode());
        }
        return n;
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        AIter aIter;
        if (!(object instanceof AList)) {
            return false;
        }
        AIter aIter2 = (AList)object;
        for (aIter = this; aIter2 != null && aIter != null && ((object3 = aIter2.first()) == (object2 = ((AIter)aIter).first()) || object3 != null && object3.equals(object2)); aIter2 = aIter2.next(), aIter = ((AIter)aIter).next()) {
        }
        return aIter2 == null && aIter == null;
    }

    public int compareTo(Object object) {
        AIter aIter;
        AIter aIter2 = this;
        for (aIter = (AIter)object; aIter2 != null && aIter != null; aIter2 = ((AIter)aIter2).next(), aIter = aIter.next()) {
            int n = ((Comparable)((AIter)aIter2).first()).compareTo(aIter.first());
            if (n == 0) continue;
            return n;
        }
        if (aIter2 != null) {
            return 1;
        }
        if (aIter != null) {
            return -1;
        }
        return 0;
    }

    public void forEach(Object object) {
        Fun fun = (Fun)object;
        if (this.inc > 0 && this.first.rCompare(Integer.MIN_VALUE) < 0 && this.last.rCompare(Integer.MAX_VALUE) > 0) {
            if (this.first.compareTo(this.last) <= 0) {
                int n = this.last.intValue();
                for (int i = this.first.intValue(); i <= n; ++i) {
                    fun.apply(new IntNum(i));
                }
            }
        } else if (this.inc < 0 && this.first.rCompare(Integer.MAX_VALUE) > 0 && this.last.rCompare(Integer.MIN_VALUE) < 0) {
            if (this.first.compareTo(this.last) >= 0) {
                int n = this.last.intValue();
                for (int i = this.first.intValue(); i >= n; --i) {
                    fun.apply(new IntNum(i));
                }
            }
        } else {
            Num num = this.first;
            while (num.compareTo(this.last) * this.inc <= 0) {
                fun.apply(num);
                num = num.add(this.inc);
            }
        }
        if (this.rest != null) {
            this.rest.forEach(object);
        }
    }

    public Object fold(Fun fun, Object object) {
        if (this.inc > 0 && this.first.rCompare(Integer.MIN_VALUE) < 0 && this.last.rCompare(Integer.MAX_VALUE) > 0) {
            if (this.first.compareTo(this.last) <= 0) {
                int n = this.last.intValue();
                for (int i = this.first.intValue(); i <= n; ++i) {
                    object = fun.apply(object, new IntNum(i));
                }
            }
        } else if (this.inc < 0 && this.first.rCompare(Integer.MAX_VALUE) > 0 && this.last.rCompare(Integer.MIN_VALUE) < 0) {
            if (this.first.compareTo(this.last) >= 0) {
                int n = this.last.intValue();
                for (int i = this.first.intValue(); i >= n; --i) {
                    object = fun.apply(object, new IntNum(i));
                }
            }
        } else {
            Num num = this.first;
            while (num.compareTo(this.last) * this.inc <= 0) {
                object = fun.apply(object, num);
                num = num.add(this.inc);
            }
        }
        if (this.rest == null) {
            return object;
        }
        return this.rest.fold(fun, object);
    }

    public AList reverse() {
        AList aList = new ListRange(this.last, this.first, null, -this.inc);
        for (AIter aIter = this.rest; aIter != null; aIter = aIter.next()) {
            aList = new LList(aIter.first(), aList);
        }
        return aList;
    }

    public AList find(Fun fun) {
        if (this.inc > 0 && this.first.rCompare(Integer.MIN_VALUE) < 0 && this.last.rCompare(Integer.MAX_VALUE) > 0) {
            if (this.first.compareTo(this.last) <= 0) {
                int n = this.last.intValue();
                for (int i = this.first.intValue(); i <= n; ++i) {
                    IntNum intNum = new IntNum(i);
                    if (fun.apply(intNum) != Boolean.TRUE) continue;
                    return new ListRange(intNum, this.last, this.rest);
                }
            }
        } else {
            Num num = this.first;
            while (num.compareTo(this.last) * this.inc <= 0) {
                if (fun.apply(num) == Boolean.TRUE) {
                    return new ListRange(num, this.last, this.rest, this.inc);
                }
                num = num.add(this.inc);
            }
        }
        if (this.rest == null) {
            return null;
        }
        return this.rest.find(fun);
    }

    public AList smap(Fun fun) {
        MList mList;
        int n;
        int n2;
        if (this.inc > 0 && this.first.rCompare(Integer.MIN_VALUE) < 0 && this.last.rCompare(Integer.MAX_VALUE) > 0) {
            n2 = this.first.intValue();
            if (n2 > (n = this.last.intValue())) {
                return this.rest.smap(fun);
            }
            mList = new MList();
            mList.reserve(n - n2 + 1);
            while (n2 <= n) {
                mList.add(fun.apply(new IntNum(n2++)));
            }
        } else if (this.inc < 0 && this.first.rCompare(Integer.MAX_VALUE) > 0 && this.last.rCompare(Integer.MIN_VALUE) < 0) {
            n2 = this.first.intValue();
            if (n2 < (n = this.last.intValue())) {
                return this.rest.smap(fun);
            }
            mList = new MList();
            mList.reserve(n2 - n + 1);
            while (n2 >= n) {
                mList.add(fun.apply(new IntNum(n2--)));
            }
        } else {
            return new MapList(this, fun);
        }
        for (AIter aIter = this.rest; aIter != null; aIter = aIter.next()) {
            mList.add(fun.apply(aIter.first()));
        }
        return mList;
    }

    public long length() {
        long l2 = this.last.sub(this.first).longValue() / (long)this.inc + 1L;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (this.rest == null) {
            return l2;
        }
        return l2 + this.rest.length();
    }

    public Num index(Object object) {
        if (this.inc > 0) {
            if (this.first.compareTo(object) <= 0 && this.last.compareTo(object) >= 0) {
                return ((Num)object).sub(this.first);
            }
        } else if (this.last.compareTo(object) <= 0 && this.first.compareTo(object) >= 0) {
            return ((Num)object).sub(this.last);
        }
        if (this.rest == null) {
            return null;
        }
        Num num = this.rest.index(object);
        if (num == null) {
            return null;
        }
        long l2 = this.last.sub(this.first).longValue() / (long)this.inc;
        if (l2 <= 0L) {
            return num;
        }
        return num.add(l2 + 1L);
    }

    public AList sort() {
        return this.rest == null ? (this.inc > 0 ? this : this.reverse()) : new MList(this).asort();
    }

    public Object copy() {
        return new ListRange(this.first, this.last, this.rest, this.inc);
    }
}

