/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import yeti.lang.compiler.Apply;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.Capture;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.Function;
import yeti.lang.compiler.YType;

abstract class CaptureRef
extends BindRef {
    Function capturer;
    BindRef ref;
    private Binder[] args;
    private Capture[] argCaptures;
    private boolean hasArgCaptures;

    CaptureRef() {
    }

    Capture[] argCaptures() {
        if (this.hasArgCaptures && this.argCaptures == null) {
            this.argCaptures = new Capture[this.args.length];
            Capture capture = this.capturer.captures;
            while (capture != null) {
                int n = this.args.length;
                while (--n >= 0) {
                    if (capture.binder != this.args[n]) continue;
                    this.argCaptures[n] = capture;
                    break;
                }
                capture = capture.next;
            }
        }
        return this.argCaptures;
    }

    Code apply(Code code, YType yType, int n) {
        if (this.args != null) {
            return new SelfApply(yType, this, code, n, this.args.length);
        }
        int n2 = 0;
        Function function = this.capturer;
        while (function != null) {
            if (function.selfBind == this.ref.binder) {
                if (this.ref.flagop(4)) break;
                this.args = new Binder[n2];
                function = this.capturer.outer;
                int n3 = n2;
                while (--n3 >= 0) {
                    this.args[n3] = function;
                    function = function.outer;
                }
                return new SelfApply(yType, this, code, n, n2);
            }
            ++n2;
            function = function.outer;
        }
        return super.apply(code, yType, n);
    }

    final class SelfApply
    extends Apply {
        boolean tail;
        int depth;

        SelfApply(YType yType, Code code, Code code2, int n, int n2) {
            super(yType, code, code2, n);
            this.depth = n2;
            if (CaptureRef.this.origin != null) {
                this.arity = CaptureRef.this.origin.arity = CaptureRef.this.args.length - n2 + 1;
                this.ref = CaptureRef.this.origin;
            }
            if (n2 == 0 && CaptureRef.this.capturer.argCaptures == null) {
                if (CaptureRef.this.hasArgCaptures) {
                    throw new CompileException(n, 0, "Internal error - already has argCaptures");
                }
                CaptureRef.this.hasArgCaptures = true;
                CaptureRef.this.capturer.argCaptures = CaptureRef.this;
            }
        }

        void genArg(Ctx ctx, int n) {
            if (n > 0) {
                ((SelfApply)this.fun).genArg(ctx, n - 1);
            }
            this.arg.gen(ctx);
        }

        void gen(Ctx ctx) {
            if (!this.tail || this.depth != 0 || CaptureRef.this.capturer.argCaptures != CaptureRef.this || CaptureRef.this.capturer.restart == null) {
                super.gen(ctx);
                return;
            }
            this.genArg(ctx, CaptureRef.this.argCaptures() == null ? 0 : CaptureRef.this.argCaptures.length);
            ctx.varInsn(58, CaptureRef.this.capturer.argVar);
            if (CaptureRef.this.argCaptures != null) {
                int n = CaptureRef.this.argCaptures.length;
                if (CaptureRef.this.capturer.outer != null && CaptureRef.this.capturer.outer.merged && n > 0 && CaptureRef.this.argCaptures[n - 1] == null) {
                    --n;
                    ctx.varInsn(58, 1);
                }
                while (--n >= 0) {
                    if (CaptureRef.this.argCaptures[n] != null) {
                        ctx.varInsn(58, ((CaptureRef)CaptureRef.this).argCaptures[n].localVar);
                        continue;
                    }
                    ctx.insn(87);
                }
            }
            ctx.jumpInsn(167, CaptureRef.this.capturer.restart);
        }

        void markTail() {
            this.tail = true;
        }

        Code apply(Code code, YType yType, int n) {
            if (this.depth < 0) {
                return super.apply(code, yType, n);
            }
            return new SelfApply(yType, this, code, n, this.depth - 1);
        }
    }
}

