/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.List;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.Closure;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Compiler;
import yeti.lang.compiler.Function;
import yeti.lang.compiler.JavaClass;
import yeti.lang.compiler.JavaClassNotFoundException;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.Scope;
import yeti.lang.compiler.TypeException;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiAnalyzer;
import yeti.lang.compiler.YetiParser;
import yeti.lang.compiler.YetiType;

final class MethodDesc
extends YetiType {
    Binder[] arguments;
    String[] names;
    JavaClass.Meth method;
    YetiParser.Node[] m;
    boolean isStatic;

    MethodDesc(JavaClass.Meth meth, YetiParser.Node node, Scope scope) {
        this.method = meth;
        YetiParser.Node[] nodeArray = ((YetiParser.XNode)node).expr;
        this.arguments = new Binder[nodeArray.length / 2];
        this.names = new String[this.arguments.length];
        int n = 0;
        int n2 = 0;
        while (n < this.arguments.length) {
            String string2 = nodeArray[n2 + 1].sym();
            for (int i = 0; i < n; ++i) {
                if (string2 != this.names[i]) continue;
                throw new CompileException(nodeArray[n2 + 1], "Duplicate argument name (" + string2 + ")");
            }
            this.names[n] = string2;
            this.arguments[n] = meth.addArg(JavaType.typeOfName(nodeArray[n2].sym(), scope));
            ++n;
            n2 += 2;
        }
    }

    Scope bindScope(Scope scope, JavaClass javaClass, Scope[] scopeArray) {
        for (int i = 0; i < this.arguments.length; ++i) {
            scope = new Scope(scope, this.names[i], this.arguments[i]);
            if (javaClass == null) continue;
            Binder binder = javaClass.addField(this.arguments[i].getRef(0), false, null);
            scopeArray[0] = new Scope(scopeArray[0], this.names[i], binder);
        }
        return scope;
    }

    private void check(YType yType, YetiParser.Node node, String string2) {
        while (yType.type == 14) {
            yType = yType.param[0];
        }
        if (yType.type == 13 && yType.javaType.description.charAt(0) == 'L') {
            yType.javaType.resolve(node).checkPackage(node, string2);
        }
    }

    void check(YetiParser.Node node, String string2) {
        YetiParser.Node[] nodeArray = ((YetiParser.XNode)node).expr;
        for (int i = 0; i < this.method.arguments.length; ++i) {
            this.check(this.method.arguments[i], nodeArray[i], string2);
        }
        if (this.m != null) {
            this.check(this.method.returnType, this.m[0], string2);
        }
    }

    void init(Scope scope, int n) {
        Scope scope2 = this.bindScope(scope, null, null);
        if (scope2 == scope) {
            scope2 = new Scope(scope2, null, null);
        }
        scope2.closure = this.method;
        this.method.code = YetiAnalyzer.analyze(this.m[3], scope2, n);
        if (JavaType.isAssignable(this.m[3], this.method.returnType, this.method.code.type, true) < 0) {
            try {
                MethodDesc.unify(this.method.code.type, this.method.returnType);
            }
            catch (TypeException typeException) {
                throw new CompileException(this.m[3], "Cannot return " + this.method.code.type + " as " + this.method.returnType);
            }
        }
    }

    static JavaClass defineClass(YetiParser.XNode xNode, boolean bl, Scope[] scopeArray, int n) {
        Object object;
        int n2;
        Object object2;
        Code[] codeArray;
        Object object3;
        Object object4;
        int n3;
        Cloneable cloneable;
        Object object5;
        Scope scope = new Scope(scopeArray[0], null, null);
        String string2 = xNode.expr[0].sym();
        String string3 = scope.ctx.packageName;
        Compiler compiler = scope.ctx.compiler;
        if (!bl) {
            string2 = compiler.createClassName(null, scope.ctx.className, string2);
        } else if (string3 != null && string3.length() != 0) {
            string2 = string3 + '/' + string2;
        }
        compiler.addClass(string2, null, xNode.line);
        JavaClass javaClass = new JavaClass(string2, bl, xNode.line);
        scope.closure = javaClass;
        YetiType.ClassBinding classBinding = null;
        YetiParser.Node[] nodeArray = ((YetiParser.XNode)xNode.expr[2]).expr;
        YetiParser.Node[] nodeArray2 = null;
        YetiParser.Node node = xNode;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nodeArray.length; i += 2) {
            object5 = MethodDesc.resolveFullClass(nodeArray[i].sym(), scope, true, nodeArray[i]);
            cloneable = ((YetiType.ClassBinding)object5).type.javaType.resolve(nodeArray[i]);
            ((JavaType)cloneable).checkPackage(nodeArray[i], string3);
            YetiParser.Node[] nodeArray3 = ((YetiParser.XNode)nodeArray[i + 1]).expr;
            if (((JavaType)cloneable).isInterface()) {
                if (nodeArray3 != null) {
                    throw new CompileException(nodeArray[i + 1], "Cannot give arguments to interface");
                }
                arrayList.add(((JavaType)cloneable).className());
                continue;
            }
            if (classBinding != null) {
                throw new CompileException(nodeArray[i], "Cannot extend multiple non-interface classes (" + classBinding.type.javaType.dottedName() + " and " + ((JavaType)cloneable).dottedName() + ')');
            }
            classBinding = object5;
            nodeArray2 = nodeArray3;
            node = nodeArray[i];
        }
        if (classBinding == null) {
            classBinding = new YetiType.ClassBinding(OBJECT_TYPE);
        }
        classBinding.type.javaType.resolve(xNode);
        javaClass.init(classBinding, arrayList.toArray(new String[arrayList.size()]));
        scope = new Scope(scopeArray[0], xNode.expr[0].sym(), null);
        LocalClassBinding localClassBinding = new LocalClassBinding(javaClass.classType);
        scope.importClass = localClassBinding;
        scopeArray[0] = scope;
        object5 = new MethodDesc(javaClass.constr, xNode.expr[1], scope);
        cloneable = new ArrayList();
        for (n3 = 3; n3 < xNode.expr.length; ++n3) {
            String string4 = xNode.expr[n3].kind;
            if (string4 != "method" && string4 != "static-method" && string4 != "abstract-method") continue;
            object4 = ((YetiParser.XNode)xNode.expr[n3]).expr;
            object3 = object4[0].sym() == "void" ? UNIT_TYPE : JavaType.typeOfName(object4[0].sym(), scope);
            codeArray = javaClass.addMethod(object4[1].sym(), (YType)object3, string4, ((YetiParser.Node[])object4).length > 3 ? ((YetiParser.Node)object4[3]).line : 0);
            object2 = new MethodDesc((JavaClass.Meth)codeArray, (YetiParser.Node)object4[2], scope);
            if (string4 == "abstract-method") continue;
            ((MethodDesc)object2).m = object4;
            ((MethodDesc)object2).isStatic = string4 != "method";
            if (((MethodDesc)object2).isStatic && !bl) {
                throw new CompileException(xNode.expr[n3], "Static methods are allowed only in classes defined in the module top-level");
            }
            cloneable.add(object2);
        }
        try {
            javaClass.close();
        }
        catch (JavaClassNotFoundException javaClassNotFoundException) {
            throw new CompileException((YetiParser.Node)xNode, javaClassNotFoundException);
        }
        ((MethodDesc)object5).check(xNode.expr[1], scope.ctx.packageName);
        int n4 = cloneable.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object4 = (MethodDesc)cloneable.get(n3);
            ((MethodDesc)object4).check(((MethodDesc)object4).m[2], scope.ctx.packageName);
        }
        javaClass.classType.javaType.checkAbstract();
        Scope scope2 = new Scope(scope, null, null);
        scope2.closure = javaClass;
        Scope[] scopeArray2 = new Scope[]{scope2};
        object4 = ((MethodDesc)object5).bindScope(scope2, javaClass, scopeArray2);
        object3 = scopeArray2[0];
        if (nodeArray2 == null) {
            nodeArray2 = new YetiParser.Node[]{};
        }
        codeArray = YetiAnalyzer.mapArgs(0, nodeArray2, (Scope)object4, n);
        object2 = JavaType.resolveConstructor(node, classBinding.type, codeArray, false).check(node, string3, 4);
        javaClass.superInit((JavaType.Method)object2, codeArray, node.line);
        object3 = new Scope((Scope)object3, "super", javaClass.superRef);
        for (n2 = 3; n2 < xNode.expr.length; ++n2) {
            Code code;
            if (!(xNode.expr[n2] instanceof YetiParser.Bind)) continue;
            YetiParser.Bind bind = (YetiParser.Bind)xNode.expr[n2];
            if (bind.property) {
                throw new CompileException((YetiParser.Node)bind, "Class field cannot be a property");
            }
            if (bind.expr.kind == "lambda" && bind.name != "_") {
                Function function = new Function(new YType(n + 1));
                object = javaClass.addField(function, bind.var, null);
                function.selfBind = object;
                Scope scope3 = new Scope((Scope)object3, "this", javaClass.self);
                if (!bind.noRec) {
                    scope3 = new Scope(scope3, bind.name, (Binder)object);
                }
                YetiAnalyzer.lambdaBind(function, bind, scope3, n + 1);
                code = function;
            } else {
                code = YetiAnalyzer.analyze(bind.expr, (Scope)object3, n + 1);
                object = javaClass.addField(code, bind.var, bind.name);
                if (bind.type != null) {
                    YetiAnalyzer.isOp(bind, bind.type, code, scope, n);
                }
            }
            if (bind.name == "_") continue;
            object3 = MethodDesc.bind(bind.name, code.type, (Binder)object, bind.var ? 4 : (code.polymorph ? 8 : 0), n, (Scope)object3);
        }
        object3 = new Scope((Scope)object3, "this", javaClass.self);
        int n5 = cloneable.size();
        for (n2 = 0; n2 < n5; ++n2) {
            object = (MethodDesc)cloneable.get(n2);
            ((MethodDesc)object).init((Scope)(((MethodDesc)object).isStatic ? scope2 : object3), n);
        }
        localClassBinding.init(javaClass.getCaptures());
        return javaClass;
    }

    static final class LocalClassBinding
    extends YetiType.ClassBinding {
        private List proxies;
        private LocalClassBinding next;
        private BindRef[] captures;

        LocalClassBinding(YType yType) {
            super(yType);
        }

        BindRef[] getCaptures() {
            if (this.captures == null) {
                throw new IllegalStateException("Captures not initialized");
            }
            return this.captures;
        }

        YetiType.ClassBinding dup(List list2) {
            LocalClassBinding localClassBinding = new LocalClassBinding(this.type);
            localClassBinding.proxies = list2;
            if (this.captures != null) {
                localClassBinding.proxy(this.captures);
            } else {
                localClassBinding.next = this.next;
                this.next = localClassBinding;
            }
            return localClassBinding;
        }

        private void proxy(BindRef[] bindRefArray) {
            if (bindRefArray.length == 0 || this.proxies.size() == 0) {
                this.captures = bindRefArray;
                return;
            }
            BindRef[] bindRefArray2 = new BindRef[bindRefArray.length];
            System.arraycopy(bindRefArray, 0, bindRefArray2, 0, bindRefArray.length);
            int n = this.proxies.size();
            while (--n >= 0) {
                Closure closure = (Closure)this.proxies.get(n);
                for (int i = 0; i < bindRefArray2.length; ++i) {
                    bindRefArray2[i] = closure.refProxy(bindRefArray2[i]);
                }
            }
            this.captures = bindRefArray2;
            this.proxies = null;
        }

        void init(BindRef[] bindRefArray) {
            LocalClassBinding localClassBinding = this;
            while ((localClassBinding = localClassBinding.next) != null) {
                localClassBinding.proxy(bindRefArray);
            }
            this.captures = bindRefArray;
        }
    }
}

