/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import yeti.lang.Core;
import yeti.lang.GenericStruct;
import yeti.lang.LList;
import yeti.lang.MList;
import yeti.lang.Struct;
import yeti.lang.Struct3;
import yeti.lang.Tag;
import yeti.lang.compiler.DescrCtx;
import yeti.lang.compiler.TypeException;
import yeti.lang.compiler.TypePattern;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiType;

class TypeDescr
extends YetiType {
    private int type;
    private String name;
    private TypeDescr value;
    private TypeDescr prev;
    private String alias;
    private Map properties;

    TypeDescr(String string2) {
        this.name = string2;
    }

    static Struct pair(String string2, Object object, String string3, Object object2) {
        Struct3 struct3 = new Struct3(new String[]{string2, string3}, null);
        struct3._0 = object;
        struct3._1 = object2;
        return struct3;
    }

    Tag force() {
        if (this.type == 0) {
            return new Tag(this.name, "Simple");
        }
        LList lList = null;
        Object object = this.value;
        while (object != null) {
            if (((TypeDescr)object).properties != null) {
                ((TypeDescr)object).properties.put("type", ((TypeDescr)object).force());
                lList = new LList(new GenericStruct(((TypeDescr)object).properties), lList);
            } else {
                lList = new LList(((TypeDescr)object).force(), lList);
            }
            object = ((TypeDescr)object).prev;
        }
        object = lList;
        String string2 = null;
        switch (this.type) {
            case 9: {
                string2 = "Function";
                break;
            }
            case 10: {
                object = TypeDescr.pair("params", lList, "type", this.name);
                string2 = "Parametric";
                break;
            }
            case 11: {
                string2 = "Struct";
                break;
            }
            case 12: {
                string2 = "Variant";
            }
        }
        Tag tag = new Tag(object, string2);
        if (this.alias == null) {
            return tag;
        }
        return new Tag(TypeDescr.pair("alias", this.alias, "type", tag), "Alias");
    }

    static Tag yetiType(YType yType, TypePattern typePattern, TypeException typeException) {
        DescrCtx descrCtx = new DescrCtx();
        descrCtx.defs = typePattern;
        if (typeException != null) {
            descrCtx.trace = typeException.trace;
        }
        return TypeDescr.prepare(yType, descrCtx).force();
    }

    static Tag typeDef(YType[] yTypeArray, MList mList, TypePattern typePattern) {
        DescrCtx descrCtx = new DescrCtx();
        descrCtx.defs = typePattern;
        int n = 0;
        for (int i = 0; i < yTypeArray.length - 1; ++i) {
            String string2 = "t" + ++n;
            descrCtx.vars.put(yTypeArray[i].deref(), string2);
            mList.add(string2);
        }
        return TypeDescr.prepare(yTypeArray[yTypeArray.length - 1], descrCtx).force();
    }

    private static void hdescr(TypeDescr typeDescr, YType yType, DescrCtx descrCtx) {
        ArrayList arrayList;
        Iterator iterator;
        TreeMap treeMap = new TreeMap();
        if (yType.requiredMembers != null) {
            treeMap.putAll(yType.requiredMembers);
        }
        if (yType.allowedMembers != null) {
            iterator = yType.allowedMembers.entrySet().iterator();
            while (iterator.hasNext()) {
                arrayList = iterator.next();
                YType yType2 = (YType)arrayList.getValue();
                YType yType3 = treeMap.put(arrayList.getKey(), yType2);
                if (yType3 == null || yType2.doc != null) continue;
                yType2.doc = yType3;
            }
        }
        arrayList = null;
        if (descrCtx.trace != null) {
            int n = descrCtx.trace.size() - 3;
            for (int i = 0; i <= n; i += 3) {
                if (descrCtx.trace.get(i + 1) != yType && descrCtx.trace.get(i + 2) != yType) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                if (!treeMap.containsKey(iterator = descrCtx.trace.get(i)) || arrayList.contains(iterator)) continue;
                arrayList.add(iterator);
            }
        }
        if (arrayList != null && arrayList.size() >= treeMap.size()) {
            arrayList = null;
        }
        Iterator iterator2 = treeMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            iterator = entry.getKey();
            if (arrayList != null && !arrayList.contains(iterator)) continue;
            YType yType4 = (YType)entry.getValue();
            IdentityHashMap<String, Object> identityHashMap = new IdentityHashMap<String, Object>(5);
            String string2 = yType4.doc();
            identityHashMap.put("name", iterator);
            identityHashMap.put("description", string2 == null ? Core.UNDEF_STR : string2);
            identityHashMap.put("mutable", yType4.field == 2);
            identityHashMap.put("tag", yType.allowedMembers == null || !yType.allowedMembers.containsKey(iterator) ? (yType.type == 11 ? "." : "") : (yType.requiredMembers != null && yType.requiredMembers.containsKey(iterator) ? "`" : (yType.type == 11 ? "" : ".")));
            identityHashMap.put("strip", arrayList);
            TypeDescr typeDescr2 = TypeDescr.prepare(yType4, descrCtx);
            typeDescr2.properties = identityHashMap;
            typeDescr2.prev = typeDescr.value;
            typeDescr.value = typeDescr2;
        }
    }

    private static boolean match(TypeDescr typeDescr, YType yType, DescrCtx descrCtx) {
        Object object;
        IdentityHashMap identityHashMap = null;
        TypePattern typePattern = null;
        if (descrCtx.defs == null || (typePattern = descrCtx.defs.match(yType, identityHashMap = new IdentityHashMap())) == null || typePattern.end == null) {
            return false;
        }
        typeDescr.name = typePattern.end.typename;
        if (typePattern.end.defvars.length == 0) {
            typeDescr.type = 0;
            return true;
        }
        descrCtx.refs.put(yType, typeDescr);
        typeDescr.type = 10;
        HashMap hashMap = new HashMap();
        Iterator iterator = identityHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashMap.put(object.getValue(), object.getKey());
        }
        int n = typePattern.end.defvars.length;
        while (--n >= 0) {
            object = (YType)hashMap.get(new Integer(typePattern.end.defvars[n]));
            TypeDescr typeDescr2 = object != null ? TypeDescr.prepare((YType)object, descrCtx) : new TypeDescr("?");
            typeDescr2.prev = typeDescr.value;
            typeDescr.value = typeDescr2;
        }
        if (typeDescr.alias == null) {
            descrCtx.refs.remove(yType);
        }
        return true;
    }

    private static TypeDescr prepare(YType yType, DescrCtx descrCtx) {
        int n = yType.type;
        if (n == 0) {
            if (yType.ref != null) {
                return TypeDescr.prepare(yType.ref, descrCtx);
            }
            return new TypeDescr(descrCtx.getVarName(yType));
        }
        if (n < PRIMITIVES.length) {
            return new TypeDescr(TYPE_NAMES[n]);
        }
        if (n == 13) {
            return new TypeDescr(yType.javaType.str());
        }
        if (n == 14) {
            return new TypeDescr(TypeDescr.prepare((YType)yType.param[0], (DescrCtx)descrCtx).name.concat("[]"));
        }
        TypeDescr typeDescr = (TypeDescr)descrCtx.refs.get(yType);
        if (typeDescr != null) {
            if (typeDescr.alias == null) {
                typeDescr.alias = descrCtx.getVarName(yType);
            }
            return new TypeDescr(typeDescr.alias);
        }
        YType yType2 = yType;
        typeDescr = new TypeDescr(null);
        int n2 = descrCtx.vars.size();
        if (TypeDescr.match(typeDescr, yType2, descrCtx)) {
            return typeDescr;
        }
        descrCtx.refs.put(yType2, typeDescr);
        typeDescr.type = n;
        YType[] yTypeArray = yType.param;
        int n3 = 1;
        switch (n) {
            case 9: {
                TypeDescr typeDescr2 = new TypeDescr(null);
                do {
                    yTypeArray = yType.param;
                    TypeDescr typeDescr3 = TypeDescr.prepare(yTypeArray[0], descrCtx);
                    typeDescr3.prev = typeDescr.value;
                    typeDescr.value = typeDescr3;
                    yType = yTypeArray[1].deref();
                } while (yType.type != 9 ? (typeDescr2 = TypeDescr.prepare(yType, descrCtx)) == null : !TypeDescr.match(typeDescr2, yType, descrCtx));
                typeDescr2.prev = typeDescr.value;
                typeDescr.value = typeDescr2;
                break;
            }
            case 11: 
            case 12: {
                TypeDescr.hdescr(typeDescr, yType, descrCtx);
                yType = yType.param[0].deref();
                if ((yType.flags & 0x100) == 0) break;
                typeDescr.alias = descrCtx.getVarName(yType);
                break;
            }
            case 10: {
                YType yType3 = yTypeArray[1].deref();
                YType yType4 = yTypeArray[2].deref();
                if (yType4.type == 7) {
                    String string2 = yType3.type == 6 ? "list" : (typeDescr.name = yType3.type == 3 ? "array" : "list?");
                    if ((yType3.flags & 0x100) != 0) {
                        typeDescr.name = typeDescr.name.concat("*");
                    }
                } else {
                    String string3 = typeDescr.name = yType4.type == 8 || yType3.type != 3 && yType3.type != 0 ? "hash" : "map";
                    if ((yType4.flags & 0x100) != 0) {
                        typeDescr.name = typeDescr.name.concat("*");
                    }
                    n3 = 2;
                }
                while (--n3 >= 0) {
                    TypeDescr typeDescr4 = TypeDescr.prepare(yTypeArray[n3], descrCtx);
                    typeDescr4.prev = typeDescr.value;
                    typeDescr.value = typeDescr4;
                }
                break;
            }
            default: {
                if (n < 65536) {
                    typeDescr.name = "?" + n + '?';
                    break;
                }
                typeDescr.type = 10;
                typeDescr.name = yType.requiredMembers.keySet().toString();
                n3 = -1;
                while (++n3 < yTypeArray.length) {
                    TypeDescr typeDescr5 = TypeDescr.prepare(yTypeArray[n3], descrCtx);
                    typeDescr5.prev = typeDescr.value;
                    typeDescr.value = typeDescr5;
                }
                break block0;
            }
        }
        if (n2 == descrCtx.vars.size() && typeDescr.alias == null) {
            descrCtx.refs.remove(yType2);
        }
        return typeDescr;
    }
}

