/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.Arrays;
import java.util.Map;
import yeti.lang.compiler.TypePattern;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiType;

class TypeWalk
implements Comparable {
    int id;
    private YType type;
    private int st;
    private TypeWalk parent;
    private String[] fields;
    private Map fieldMap;
    String field;
    TypePattern pattern;
    String typename;
    YType[] def;
    int[] defvars;

    TypeWalk(YType yType, TypeWalk typeWalk, Map map3, TypePattern typePattern) {
        this.pattern = typePattern;
        this.parent = typeWalk;
        this.type = yType = yType.deref();
        TypePattern typePattern2 = (TypePattern)map3.get(yType);
        if (typePattern2 != null) {
            this.id = typePattern2.var;
            if (this.id > 0) {
                typePattern2.var = this.id = -this.id;
            }
            return;
        }
        this.id = yType.type;
        if (this.id == 0) {
            if (map3.containsKey(yType)) {
                this.id = Integer.MAX_VALUE;
                if (typePattern != null && typePattern.var >= 0) {
                    typePattern.var = -typePattern.var;
                }
            } else if (typeWalk != null && typeWalk.type.type == 10 && typeWalk.st > 1 && (typeWalk.st > 2 || typeWalk.type.param[2] == YetiType.LIST_TYPE)) {
                this.id = Integer.MAX_VALUE;
                return;
            }
            map3.put(yType, typePattern);
        } else if (this.id >= YetiType.PRIMITIVES.length) {
            map3.put(yType, typePattern);
        }
        if (this.id == 11 || this.id == 12) {
            this.fieldMap = yType.allowedMembers != null ? yType.allowedMembers : yType.requiredMembers;
            this.fields = this.fieldMap.keySet().toArray(new String[this.fieldMap.size()]);
            Arrays.sort(this.fields);
        }
    }

    TypeWalk next(Map map3, TypePattern typePattern) {
        if (this.id < 0 || this.id == Integer.MAX_VALUE) {
            if (this.parent != null) {
                return this.parent.next(map3, typePattern);
            }
            if (this.def != null) {
                typePattern.end = this;
                this.defvars = new int[this.def.length - 1];
                for (int i = 0; i < this.defvars.length; ++i) {
                    typePattern = (TypePattern)map3.get(this.def[i]);
                    if (typePattern == null) continue;
                    this.defvars[i] = typePattern.var;
                }
            }
            return null;
        }
        if (this.fields == null) {
            if (this.type.param != null && this.st < this.type.param.length) {
                return new TypeWalk(this.type.param[this.st++], this, map3, typePattern);
            }
        } else if (this.st < this.fields.length) {
            YType yType = (YType)this.fieldMap.get(this.fields[this.st]);
            TypeWalk typeWalk = new TypeWalk(yType, this, map3, typePattern);
            typeWalk.field = this.fields[this.st++];
            if (yType.field == 2) {
                typeWalk.field = ";".concat(typeWalk.field);
            }
            return typeWalk;
        }
        this.field = null;
        this.id = Integer.MIN_VALUE;
        return this;
    }

    public int compareTo(Object object) {
        TypeWalk typeWalk = (TypeWalk)object;
        if (this.field == null) {
            return typeWalk.field == null ? this.id - typeWalk.id : 1;
        }
        if (typeWalk.field == null) {
            return -1;
        }
        int n = this.field.compareTo(typeWalk.field);
        return n == 0 ? this.id - typeWalk.id : n;
    }
}

