/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.CaptureWrapper;
import yeti.lang.compiler.Closure;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.Function;
import yeti.lang.compiler.SeqExpr;
import yeti.renamed.asm3.Label;

final class BindExpr
extends SeqExpr
implements Binder,
CaptureWrapper {
    private int id;
    private int mvar = -1;
    private final boolean var;
    private String javaType;
    private String javaDescr;
    private Closure closure;
    boolean assigned;
    boolean captured;
    Ref refs;
    int evalId = -1;
    private boolean directBind;
    private String directField;
    private String myClass;
    private int bindingUsed;

    BindExpr(Code code, boolean bl) {
        super(code);
        this.var = bl;
    }

    void setMVarId(Closure closure, int n, int n2) {
        this.closure = closure;
        this.mvar = n;
        this.id = n2;
    }

    public BindRef getRef(int n) {
        Ref ref = new Ref();
        ref.binder = this;
        ref.type = this.st.type;
        ref.polymorph = !this.var && this.st.polymorph;
        ref.next = this.refs;
        if (this.st instanceof Function) {
            ref.origin = ref;
        }
        ++this.bindingUsed;
        this.refs = ref;
        return this.refs;
    }

    public Object captureIdentity() {
        return this.mvar == -1 ? this : this.closure;
    }

    public String captureType() {
        if (this.javaDescr == null) {
            throw new IllegalStateException(this.toString());
        }
        return this.mvar == -1 ? this.javaDescr : "[Ljava/lang/Object;";
    }

    public void genPreGet(Ctx ctx) {
        if (this.mvar == -1) {
            if (this.directField == null) {
                int n;
                ctx.load(this.id);
                if (this.bindingUsed == 0 && ctx.tainted == 0 && ((n = this.st.type.deref().type) == 0 || n == 10)) {
                    ctx.insn(1);
                    ctx.varInsn(58, this.id);
                }
                ctx.forceType(this.javaType);
            } else {
                ctx.fieldInsn(178, this.myClass, this.directField, this.javaDescr);
            }
        } else {
            ctx.load(this.mvar).forceType("[Ljava/lang/Object;");
        }
    }

    public void genGet(Ctx ctx) {
        if (this.mvar != -1) {
            ctx.typeInsn(192, "[Ljava/lang/Object;");
            ctx.intConst(this.id);
            ctx.insn(50);
        }
    }

    public void genSet(Ctx ctx, Code code) {
        if (this.directField == null) {
            ctx.typeInsn(192, "[Ljava/lang/Object;");
            ctx.intConst(this.id);
            code.gen(ctx);
            ctx.insn(83);
        } else {
            code.gen(ctx);
            ctx.fieldInsn(179, this.myClass, this.directField, this.javaDescr);
        }
    }

    private void genLocalSet(Ctx ctx, Code code) {
        if (this.mvar == -1) {
            code.gen(ctx);
            if (!this.javaType.equals("java/lang/Object")) {
                ctx.typeInsn(192, this.javaType);
            }
            if (this.directField == null) {
                ctx.varInsn(58, this.id);
            } else {
                ctx.fieldInsn(179, this.myClass, this.directField, this.javaDescr);
            }
        } else {
            ctx.load(this.mvar).intConst(this.id);
            code.gen(ctx);
            ctx.insn(83);
        }
    }

    void setCaptureType(String string2) {
        this.javaType = string2;
        this.javaDescr = string2.charAt(0) == '[' ? string2 : 'L' + string2 + ';';
    }

    void genBind(Ctx ctx) {
        this.setCaptureType(BindExpr.javaType(this.st.type));
        if (ctx == null) {
            return;
        }
        if (!this.var && this.st.prepareConst(ctx) && this.evalId == -1) {
            this.directBind = true;
            return;
        }
        if (this.directField == "") {
            this.myClass = ctx.className;
            this.directField = "$".concat(Integer.toString(ctx.constants.ctx.fieldCounter++));
            ctx.cw.visitField(4168, this.directField, this.javaDescr, null, null).visitEnd();
        } else if (this.mvar == -1) {
            this.id = ctx.localVarCount++;
        }
        this.genLocalSet(ctx, this.st);
        if (this.evalId != -1) {
            ctx.intConst(this.evalId);
            this.genPreGet(ctx);
            if (this.mvar != -1) {
                ctx.intConst(this.id);
            }
            ctx.methodInsn(184, "yeti/lang/compiler/YetiEval", "setBind", this.mvar == -1 ? "(ILjava/lang/Object;)V" : "(I[Ljava/lang/Object;I)V");
        }
    }

    void gen(Ctx ctx) {
        this.genBind(ctx);
        this.result.gen(ctx);
    }

    void genIf(Ctx ctx, Label label, boolean bl) {
        this.genBind(ctx);
        this.result.genIf(ctx, label, bl);
    }

    class Ref
    extends BindRef {
        int arity;
        Ref next;

        Ref() {
        }

        void gen(Ctx ctx) {
            if (BindExpr.this.directBind) {
                BindExpr.this.st.gen(ctx);
            } else {
                --BindExpr.this.bindingUsed;
                BindExpr.this.genPreGet(ctx);
                BindExpr.this.genGet(ctx);
            }
        }

        Code assign(final Code code) {
            if (!BindExpr.this.var) {
                return null;
            }
            BindExpr.this.assigned = true;
            return new Code(){

                void gen(Ctx ctx) {
                    BindExpr.this.genLocalSet(ctx, code);
                    ctx.insn(1);
                }
            };
        }

        boolean flagop(int n) {
            if ((n & 4) != 0) {
                return BindExpr.this.var ? (BindExpr.this.assigned = true) : false;
            }
            if ((n & 1) != 0) {
                return BindExpr.this.directBind;
            }
            if ((n & 0x20) != 0) {
                return BindExpr.this.directBind || BindExpr.this.directField != null;
            }
            if ((n & 0x80) != 0) {
                return BindExpr.this.directField != null;
            }
            return (n & 2) != 0 && !BindExpr.this.var;
        }

        CaptureWrapper capture() {
            BindExpr.this.captured = true;
            if (!BindExpr.this.var) {
                return null;
            }
            ++BindExpr.this.bindingUsed;
            return BindExpr.this;
        }

        Code unref(boolean bl) {
            return bl || BindExpr.this.directBind ? BindExpr.this.st : null;
        }

        void forceDirect() {
            BindExpr.this.directField = "";
        }
    }
}

