/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import yeti.lang.compiler.AListPattern;
import yeti.lang.compiler.BindPattern;
import yeti.lang.compiler.CaseExpr;
import yeti.lang.compiler.CasePattern;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.ConsPattern;
import yeti.lang.compiler.ConstPattern;
import yeti.lang.compiler.ListPattern;
import yeti.lang.compiler.Scope;
import yeti.lang.compiler.StructPattern;
import yeti.lang.compiler.TypeException;
import yeti.lang.compiler.VariantPattern;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiAnalyzer;
import yeti.lang.compiler.YetiParser;
import yeti.lang.compiler.YetiType;

final class CaseCompiler
extends YetiType {
    CaseExpr exp;
    Scope scope;
    int depth;
    List variants = new ArrayList();
    List listVars;
    int submatch;

    CaseCompiler(Code code, int n) {
        this.exp = new CaseExpr(code);
        this.exp.polymorph = true;
        this.depth = n;
    }

    CasePattern toPattern(YetiParser.Node node, YType yType, String string2) {
        YetiParser.Node[] nodeArray;
        if ((yType.flags & 0x4000) != 0) {
            throw new CompileException(node, "Useless case " + node + " (any value already matched)");
        }
        if (yType.type == 0 && yType.ref == null && this.listVars != null && !this.listVars.contains(yType)) {
            this.listVars.add(yType);
        }
        if (node instanceof YetiParser.Sym) {
            yType.flags |= 0x4000;
            String string3 = node.sym();
            if (string3 == "_" || string3 == "...") {
                return CasePattern.ANY_PATTERN;
            }
            BindPattern bindPattern = new BindPattern(this.exp, yType);
            this.scope = new Scope(this.scope, string3, bindPattern);
            yType = yType.deref();
            if (yType.type == 12) {
                yType.flags |= 0x4000;
            }
            return bindPattern;
        }
        if (node.kind == "()") {
            CaseCompiler.unify(yType, UNIT_TYPE, node, this.scope, "#0");
            return CasePattern.ANY_PATTERN;
        }
        if (node instanceof YetiParser.NumLit || node instanceof YetiParser.Str || node instanceof YetiParser.ObjectRefOp) {
            nodeArray = YetiAnalyzer.analyze(node, this.scope, this.depth);
            if (!(node instanceof YetiParser.ObjectRefOp) || nodeArray.flagop(1)) {
                yType = yType.deref();
                if (yType.type == 0) {
                    yType.type = nodeArray.type.type;
                    yType.param = NO_PARAM;
                    yType.flags = 32768;
                } else if (yType.type != nodeArray.type.type) {
                    throw new CompileException(node, this.scope, nodeArray.type, yType, "Pattern type mismatch: #~", null);
                }
                return new ConstPattern((Code)nodeArray);
            }
        }
        if (node.kind == "list") {
            nodeArray = (YetiParser.XNode)node;
            YType yType2 = new YType(this.depth);
            YType yType3 = new YType(10, new YType[]{yType2, new YType(this.depth), LIST_TYPE});
            yType3.flags |= 0x8000;
            if (nodeArray.expr == null || nodeArray.expr.length == 0) {
                CaseCompiler.unify(yType, yType3, node, this.scope, "#0");
                return AListPattern.EMPTY_PATTERN;
            }
            CasePattern[] casePatternArray = new CasePattern[nodeArray.expr.length];
            int n = 16384;
            ++this.submatch;
            List list2 = this.listVars;
            this.listVars = new ArrayList();
            for (int i = 0; i < casePatternArray.length; ++i) {
                yType2.flags &= 0xFFFFBFFF;
                int n2 = this.listVars.size();
                while (--n2 >= 0) {
                    ((YType)this.listVars.get((int)n2)).flags &= 0xFFFFBFFF;
                }
                this.listVars.clear();
                casePatternArray[i] = this.toPattern(nodeArray.expr[i], yType2, null);
                n &= yType2.flags;
            }
            this.listVars = list2;
            --this.submatch;
            yType2.flags &= n;
            CaseCompiler.unify(yType, yType3, node, this.scope, "#0");
            return new ListPattern(casePatternArray);
        }
        if (node instanceof YetiParser.BinOp) {
            nodeArray = (YetiParser.BinOp)node;
            if (nodeArray.op == "" && nodeArray.left instanceof YetiParser.Sym) {
                String string4 = nodeArray.left.sym();
                if (!Character.isUpperCase(string4.charAt(0))) {
                    throw new CompileException(nodeArray.left, string4 + ": Variant constructor must start with upper case");
                }
                yType = yType.deref();
                if (yType.type != 0 && yType.type != 12) {
                    throw new CompileException(node, "Variant " + string4 + " ... is not " + yType.toString(this.scope, null));
                }
                yType.type = 12;
                if (yType.requiredMembers == null) {
                    yType.requiredMembers = new IdentityHashMap();
                    yType.flags |= 8;
                    if (this.submatch == 0) {
                        this.variants.add(yType);
                    }
                }
                YType yType4 = new YType(this.depth);
                yType4.doc = string2;
                YType yType5 = yType.requiredMembers.put(string4, yType4);
                if (yType5 != null) {
                    yType4 = CaseCompiler.withDoc(yType5, string2);
                    yType.requiredMembers.put(string4, yType4);
                }
                CasePattern casePattern = this.toPattern(nodeArray.right, yType4, null);
                CaseCompiler.structParam(yType, yType.requiredMembers, new YType(this.depth));
                return new VariantPattern(string4, casePattern);
            }
            if (nodeArray.op == "::") {
                YType yType6 = new YType(this.depth);
                YType yType7 = new YType(10, new YType[]{yType6, NO_TYPE, LIST_TYPE});
                int n = yType.flags;
                CaseCompiler.unify(yType, yType7, node, this.scope, "#0");
                ++this.submatch;
                CasePattern casePattern = this.toPattern(nodeArray.left, yType6, null);
                CasePattern casePattern2 = this.toPattern(nodeArray.right, yType, null);
                --this.submatch;
                yType7.flags = 32768;
                yType.flags = n;
                return new ConsPattern(casePattern, casePattern2);
            }
        }
        if (node.kind == "struct") {
            YType yType8;
            Object object;
            nodeArray = ((YetiParser.XNode)node).expr;
            if (nodeArray.length == 0) {
                throw new CompileException(node, "No sense in empty struct");
            }
            String[] stringArray = new String[nodeArray.length];
            CasePattern[] casePatternArray = new CasePattern[nodeArray.length];
            HashMap hashMap = new HashMap(nodeArray.length);
            int n = 16384;
            for (int i = 0; i < nodeArray.length; ++i) {
                object = YetiAnalyzer.getField(nodeArray[i]);
                if (hashMap.containsKey(((YetiParser.Bind)object).name)) {
                    YetiAnalyzer.duplicateField((YetiParser.Bind)object);
                }
                hashMap.put(((YetiParser.Bind)object).name, null);
                yType8 = new YType(this.depth);
                YType yType9 = new YType(11, new YType[]{new YType(this.depth), yType8});
                IdentityHashMap<String, YType> identityHashMap = new IdentityHashMap<String, YType>();
                identityHashMap.put(((YetiParser.Bind)object).name, yType8);
                yType9.requiredMembers = identityHashMap;
                CaseCompiler.unify(yType, yType9, (YetiParser.Node)object, this.scope, "#0");
                stringArray[i] = ((YetiParser.Bind)object).name;
                yType8.flags &= 0xFFFFBFFF;
                casePatternArray[i] = this.toPattern(((YetiParser.Bind)object).expr, yType8, null);
                n &= yType8.flags;
            }
            Map map3 = yType.deref().requiredMembers;
            if (map3 != null) {
                object = map3.values().iterator();
                while (object.hasNext()) {
                    yType8 = ((YType)object.next()).deref();
                    if (n == 0) {
                        yType8.flags &= 0xFFFFBFFF;
                        continue;
                    }
                    yType8.flags |= 0x4000;
                }
            }
            return new StructPattern(stringArray, casePatternArray);
        }
        throw new CompileException(node, "Bad case pattern: " + node);
    }

    void finalizeVariants() {
        int n = this.variants.size();
        while (--n >= 0) {
            YType yType = (YType)this.variants.get(n);
            if (yType.type != 12 || yType.allowedMembers != null || (yType.flags & 0x4000) != 0) continue;
            yType.allowedMembers = yType.requiredMembers;
            yType.requiredMembers = null;
            yType.flags &= 0xFFFFFFF7;
        }
    }

    void mergeChoice(CasePattern casePattern, YetiParser.Node node, Scope scope) {
        Code code = YetiAnalyzer.analyze(node, scope, this.depth);
        this.exp.polymorph &= code.polymorph;
        if (this.exp.type == null) {
            this.exp.type = code.type;
        } else {
            try {
                this.exp.type = CaseCompiler.mergeOrUnify(this.exp.type, code.type);
            }
            catch (TypeException typeException) {
                throw new CompileException(node, scope, code.type, this.exp.type, "This choice has a #1 type, while another was a #2", typeException);
            }
        }
        this.exp.addChoice(casePattern, code);
    }

    static String checkPartialMatch(YType yType) {
        if (yType.seen || (yType.flags & 0x4000) != 0) {
            return null;
        }
        if ((yType.flags & 0x8000) != 0) {
            return yType.type == 10 ? "[]" : yType.toString();
        }
        if (yType.type != 0) {
            yType.seen = true;
            int n = yType.param.length;
            while (--n >= 0) {
                String string2 = CaseCompiler.checkPartialMatch(yType.param[n]);
                if (string2 == null) continue;
                yType.seen = false;
                if (yType.type == 10) {
                    return "(" + string2 + ")::_";
                }
                if (yType.type == 12 || yType.type == 11) {
                    Iterator iterator = yType.requiredMembers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() != yType.param[n]) continue;
                        return (yType.type == 11 ? "." : "") + entry.getKey() + " (" + string2 + ")";
                    }
                }
                return string2;
            }
            yType.seen = false;
        } else if (yType.ref != null) {
            return CaseCompiler.checkPartialMatch(yType.ref);
        }
        return null;
    }

    static Code caseType(YetiParser.XNode xNode, Scope scope, int n) {
        YetiParser.Node[] nodeArray = xNode.expr;
        if (nodeArray.length <= 1) {
            throw new CompileException((YetiParser.Node)xNode, "case expects some option!");
        }
        Code code = YetiAnalyzer.analyze(nodeArray[0], scope, n);
        CaseCompiler caseCompiler = new CaseCompiler(code, n);
        CasePattern[] casePatternArray = new CasePattern[nodeArray.length];
        Scope[] scopeArray = new Scope[nodeArray.length];
        YType yType = new YType(n);
        for (int i = 1; i < nodeArray.length; ++i) {
            caseCompiler.scope = scope;
            YetiParser.XNode xNode2 = (YetiParser.XNode)nodeArray[i];
            casePatternArray[i] = caseCompiler.toPattern(xNode2.expr[0], yType, xNode2.doc);
            scopeArray[i] = caseCompiler.scope;
            caseCompiler.exp.resetParams();
        }
        String string2 = CaseCompiler.checkPartialMatch(yType);
        if (string2 != null) {
            throw new CompileException((YetiParser.Node)xNode, "Partial match: " + string2);
        }
        caseCompiler.finalizeVariants();
        for (int i = 1; i < nodeArray.length; ++i) {
            if (nodeArray[i].kind == "...") continue;
            caseCompiler.mergeChoice(casePatternArray[i], ((YetiParser.XNode)nodeArray[i]).expr[1], scopeArray[i]);
        }
        CaseCompiler.unify(code.type, yType, nodeArray[0], scope, "Inferred type for case argument is #2, but a #1 is given\n    (#0)");
        return caseCompiler.exp;
    }
}

