/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import yeti.lang.Core;
import yeti.lang.Fun;
import yeti.lang.Struct3;
import yeti.lang.compiler.ClassFinder;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CodeWriter;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Constants;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.JavaSource;
import yeti.lang.compiler.ModuleType;
import yeti.lang.compiler.RootClosure;
import yeti.lang.compiler.SeqExpr;
import yeti.lang.compiler.StructConstructor;
import yeti.lang.compiler.TypeAttr;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiAnalyzer;
import yeti.lang.compiler.YetiParser;
import yeti.lang.compiler.YetiTypeVisitor;
import yeti.renamed.asm3.Label;
import yeti.renamed.asm3.Opcodes;

final class Compiler
implements Opcodes {
    static final int CF_RESOLVE_MODULE = 1;
    static final int CF_PRINT_PARSE_TREE = 2;
    static final int CF_EVAL = 4;
    static final int CF_EVAL_RESOLVE = 8;
    static final int CF_EVAL_STORE = 32;
    static final int CF_EVAL_BIND = 40;
    static final int CF_EXPECT_MODULE = 128;
    static final int CF_EXPECT_PROGRAM = 256;
    static final int CF_FORCE_COMPILE = 512;
    static final int CF_IGNORE_CLASSPATH = 1024;
    static final int GF_NO_IMPORT = 16;
    static final int GF_DOC = 64;
    static final String[] PRELOAD = new String[]{"yeti/lang/std", "yeti/lang/io"};
    static final ThreadLocal currentCompiler = new ThreadLocal();
    private static ClassLoader JAVAC;
    CodeWriter writer;
    String depDestDir;
    private Map compiled = new HashMap();
    private List warnings = new ArrayList();
    private String currentSrc;
    private Map definedClasses = new HashMap();
    final List postGen = new ArrayList();
    boolean isGCJ;
    String sourceCharset = "UTF-8";
    private String[] sourcePath = new String[0];
    Fun customReader;
    ClassFinder classPath;
    final Map types = new HashMap();
    final Map opaqueTypes = new HashMap();
    final Map javaTypeCache = new HashMap();
    String[] preload = PRELOAD;
    int classWriterFlags = 2;
    int globalFlags;

    Compiler() {
        this.isGCJ = System.getProperty("java.vm.name").indexOf("gcj") >= 0;
    }

    void warn(CompileException compileException) {
        compileException.fn = this.currentSrc;
        this.warnings.add(compileException);
    }

    String createClassName(Ctx ctx, String string2, String string3) {
        String string4;
        boolean bl = string3 == "" && ctx != null;
        string3 = string2 + '$' + string3;
        String string5 = string4 = string3.toLowerCase();
        int n = -1;
        if (bl) {
            n = ctx.constants.anonymousClassCounter;
            string5 = string4 + n;
        }
        while (this.definedClasses.containsKey(string5)) {
            string5 = string4 + ++n;
        }
        if (bl) {
            ctx.constants.anonymousClassCounter = n + 1;
        }
        return n < 0 ? string3 : string3 + n;
    }

    public void enumWarns(Fun fun) {
        int n = this.warnings.size();
        for (int i = 0; i < n; ++i) {
            fun.apply(this.warnings.get(i));
        }
    }

    private void generateModuleAccessors(Map map3, Ctx ctx, Map map4) {
        if (ctx.compilation.isGCJ) {
            ctx.typeInsn(192, "yeti/lang/Struct");
        }
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = Code.mangle(string2);
            String string4 = string2.equals("eval") ? "eval$" : string3;
            String string5 = Code.javaType((YType)entry.getValue());
            String string6 = "()L" + string5 + ';';
            Ctx ctx2 = ctx.newMethod(9, string4, string6);
            Code code = (Code)map4.get(string2);
            if (code != null) {
                code.gen(ctx2);
                ctx2.typeInsn(192, string5);
            } else if (map4.containsKey(string2)) {
                ctx2.methodInsn(184, ctx.className, "eval", "()Ljava/lang/Object;");
                if (ctx.compilation.isGCJ) {
                    ctx2.typeInsn(192, "yeti/lang/Struct");
                }
                ctx2.ldcInsn(string2);
                ctx2.methodInsn(185, "yeti/lang/Struct", "get", "(Ljava/lang/String;)Ljava/lang/Object;");
                ctx2.typeInsn(192, string5);
            } else {
                string6 = string6.substring(2);
                ctx.cw.visitField(10, string3, string6, null, null).visitEnd();
                ctx.insn(89);
                ctx.ldcInsn(string2);
                ctx.methodInsn(185, "yeti/lang/Struct", "get", "(Ljava/lang/String;)Ljava/lang/Object;");
                ctx.typeInsn(192, string5);
                ctx.fieldInsn(179, ctx.className, string3, string6);
                this.genFastInit(ctx2);
                ctx2.fieldInsn(178, ctx.className, string3, string6);
            }
            ctx2.insn(176);
            ctx2.closeMethod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String compileAll(String[] stringArray, int n, String[] stringArray2) throws Exception {
        Object object;
        int n2;
        ArrayList<String> arrayList = null;
        int n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].endsWith(".java")) {
                object = this.readSourceFile(null, stringArray[n2], new YetiAnalyzer());
                new JavaSource(stringArray[n2], (char[])object, this.classPath.parsed);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    boolean bl = true;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (stringArray2[i].startsWith("-g")) {
                            bl = false;
                        }
                        arrayList.add(stringArray2[i]);
                    }
                    if (!arrayList.contains("-encoding")) {
                        arrayList.add("-encoding");
                        arrayList.add("utf-8");
                    }
                    if (bl) {
                        arrayList.add("-g");
                    }
                    if (this.classPath.pathStr.length() != 0) {
                        arrayList.add("-classpath");
                        String string2 = this.classPath.pathStr;
                        if (this.depDestDir != null) {
                            string2 = string2.length() == 0 ? this.depDestDir : string2 + File.pathSeparator + this.depDestDir;
                        }
                        arrayList.add(string2);
                    }
                }
                arrayList.add(stringArray[n2]);
                continue;
            }
            stringArray[n3++] = stringArray[n2];
        }
        object = null;
        for (n2 = 0; n2 < n3; ++n2) {
            String string3 = this.compile((String)stringArray[n2], null, (int)n).name;
            if (this.types.containsKey(string3)) continue;
            object = string3;
        }
        if (arrayList != null) {
            Method method;
            ThreadLocal<Object> threadLocal2;
            stringArray2 = arrayList.toArray(new String[stringArray2.length]);
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.tools.javac.Main", true, this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (clazz == null) {
                    threadLocal2 = currentCompiler;
                    synchronized (threadLocal2) {
                        if (JAVAC == null) {
                            File file = new File(System.getProperty("java.home"), "../lib/tools.jar");
                            if (!file.exists()) {
                                file = new File(System.getenv("JAVA_HOME"), "lib/tools.jar");
                            }
                            JAVAC = new URLClassLoader(new URL[]{file.toURI().toURL()});
                        }
                    }
                    clazz = Class.forName("com.sun.tools.javac.Main", true, JAVAC);
                }
                method = clazz.getMethod("compile", String;.class);
            }
            catch (Exception exception) {
                throw new CompileException(null, "Couldn't find Java compiler");
            }
            threadLocal2 = clazz.newInstance();
            if ((Integer)method.invoke((Object)threadLocal2, new Object[]{stringArray2}) != 0) {
                throw new CompileException(null, "Error while compiling Java sources");
            }
        }
        return n3 != 0 ? object : "";
    }

    void setSourcePath(String[] stringArray) throws IOException {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2 = stringArray[i];
            int n2 = 32;
            int n3 = string2.length();
            for (n = 0; n < n3; ++n) {
                char c2 = string2.charAt(n);
                n2 = c2;
                if (!(c2 >= 'a' && n2 <= 122 || n2 >= 48 && n2 <= 57)) break;
            }
            stringArray2[i] = n > 1 && n2 == 58 ? string2 : new File(string2).getCanonicalPath();
        }
        this.sourcePath = stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] readSourceFile(String string2, String string3, YetiAnalyzer yetiAnalyzer) throws IOException {
        Object object;
        Serializable serializable;
        if (this.customReader != null) {
            serializable = new Struct3(new String[]{"name", "parent"}, null);
            ((Struct3)serializable)._0 = string3;
            ((Struct3)serializable)._1 = string2 == null ? Core.UNDEF_STR : string2;
            object = (String)this.customReader.apply(serializable);
            if (object != Core.UNDEF_STR) {
                yetiAnalyzer.canonicalFile = (String)((Struct3)serializable)._0;
                yetiAnalyzer.sourceFile = null;
                if (this.compiled.containsKey(yetiAnalyzer.canonicalFile)) {
                    return null;
                }
                return object.toCharArray();
            }
        }
        serializable = new File(string2, string3);
        yetiAnalyzer.sourceFile = ((File)serializable).getName();
        if (string2 == null) {
            serializable = ((File)serializable).getCanonicalFile();
            yetiAnalyzer.canonicalFile = ((File)serializable).getPath();
            if (this.compiled.containsKey(yetiAnalyzer.canonicalFile)) {
                return null;
            }
        }
        object = new char[32768];
        FileInputStream fileInputStream = new FileInputStream((File)serializable);
        Reader reader = null;
        try {
            int n;
            reader = new InputStreamReader((InputStream)fileInputStream, this.sourceCharset);
            int n2 = 0;
            while ((n = reader.read((char[])object, n2, ((char[])object).length - n2)) >= 0) {
                if (((char[])object).length - (n2 += n) >= 4096) continue;
                char[] cArray = new char[((Object)object).length << 1];
                System.arraycopy(object, 0, cArray, 0, n2);
                object = cArray;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            } else {
                ((InputStream)fileInputStream).close();
            }
        }
        if (string2 != null) {
            yetiAnalyzer.canonicalFile = ((File)serializable).getCanonicalPath();
        }
        yetiAnalyzer.sourceTime = ((File)serializable).lastModified();
        return object;
    }

    private void verifyModuleCase(YetiAnalyzer yetiAnalyzer) {
        int n = yetiAnalyzer.canonicalFile.length() - yetiAnalyzer.sourceName.length();
        if (n < 0) {
            return;
        }
        String string2 = yetiAnalyzer.canonicalFile.substring(n);
        if (!yetiAnalyzer.sourceName.equals(string2) && yetiAnalyzer.sourceName.equalsIgnoreCase(string2)) {
            throw new CompileException(0, 0, "Module file name case doesn't match the requested name");
        }
    }

    private char[] readSource(YetiAnalyzer yetiAnalyzer) {
        try {
            if ((yetiAnalyzer.flags & 1) == 0) {
                return this.readSourceFile(null, yetiAnalyzer.sourceName, yetiAnalyzer);
            }
            String string2 = yetiAnalyzer.sourceName;
            String string3 = yetiAnalyzer.sourceName = string2 + ".yeti";
            if (this.sourcePath.length == 0) {
                throw new IOException("no source path");
            }
            int n = string3.lastIndexOf(47);
            while (true) {
                for (int i = 0; i < this.sourcePath.length; ++i) {
                    try {
                        char[] cArray = this.readSourceFile(this.sourcePath[i], string3, yetiAnalyzer);
                        yetiAnalyzer.sourceDir = this.sourcePath[i];
                        this.verifyModuleCase(yetiAnalyzer);
                        return cArray;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (n != -2 && (yetiAnalyzer.flags & 0x400) == 0 && (yetiAnalyzer.resolvedType = this.moduleType(string2)) != null) {
                    return null;
                }
                if (n <= 0) {
                    throw new CompileException(0, 0, "Module " + string2.replace('/', '.') + " not found");
                }
                string3 = string3.substring(n + 1);
                n = -2;
            }
        }
        catch (IOException iOException) {
            throw new CompileException(0, 0, yetiAnalyzer.sourceName + ": " + iOException.getMessage());
        }
    }

    ModuleType moduleType(String string2) throws IOException {
        String string3 = string2.toLowerCase();
        long[] lArray = new long[]{-1L};
        InputStream inputStream = this.classPath.findClass(string3 + ".class", lArray);
        if (inputStream == null) {
            return null;
        }
        ModuleType moduleType = YetiTypeVisitor.readType(this, inputStream);
        if (moduleType != null) {
            moduleType.name = string3;
            moduleType.lastModified = lArray[0];
            this.types.put(string3, moduleType);
        }
        return moduleType;
    }

    void deriveName(YetiParser.Parser parser, YetiAnalyzer yetiAnalyzer) {
        String[] stringArray;
        if ((yetiAnalyzer.flags & 5) == 4) {
            if (parser.moduleName == null) {
                parser.moduleName = "code";
            }
            if (this.sourcePath.length == 0) {
                this.sourcePath = new String[]{new File("").getAbsolutePath()};
            }
            return;
        }
        String string2 = yetiAnalyzer.canonicalFile;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        int n3 = string2.length() - 5;
        if (n3 > 0 && string2.substring(n3).equalsIgnoreCase(".yeti")) {
            string2 = string2.substring(0, n3);
        } else if (parser.isModule) {
            throw new CompileException(0, 0, "Yeti module source file must have a .yeti suffix");
        }
        boolean bl = parser.moduleName == null;
        String string4 = parser.moduleName;
        if (string4 != null) {
            n2 = string4.lastIndexOf(47);
            String string5 = string4 = n2 > 0 ? string4.substring(n2 + 1) : null;
        }
        if (yetiAnalyzer.sourceDir == null) {
            stringArray = this.sourcePath;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = yetiAnalyzer.sourceDir;
        }
        String[] stringArray3 = stringArray;
        for (n3 = 0; n3 < stringArray3.length; ++n3) {
            n2 = stringArray3[n3].length();
            if (n2 <= n || string2.length() <= n2 || string2.charAt(n2) != File.separatorChar || !stringArray3[n3].equals(string2.substring(0, n2))) continue;
            string3 = string2.substring(n2 + 1).replace(File.separatorChar, '/');
            if (!bl && (string3.equalsIgnoreCase(parser.moduleName) || string3.equalsIgnoreCase(string4))) {
                bl = true;
                break;
            }
            n = n2;
        }
        if (string3 == null) {
            string3 = new File(string2).getName();
        }
        if (!(bl || n == -1 && (string3.equalsIgnoreCase(string4) || string3.equalsIgnoreCase(parser.moduleName)))) {
            throw new CompileException(parser.moduleNameLine, 0, (parser.isModule ? "module " : "program ") + parser.moduleName.replace('/', '.') + " is not allowed to be in file named '" + yetiAnalyzer.canonicalFile + "'");
        }
        if (parser.moduleName != null) {
            string3 = parser.moduleName;
        }
        String string6 = parser.moduleName = parser.isModule ? string3.toLowerCase() : string3;
        if (this.sourcePath.length == 0) {
            n2 = string2.length() - (string3.length() + 1);
            if (n2 >= 0) {
                string3 = string2.substring(n2).replace(File.separatorChar, '/');
                if (n2 == 0) {
                    n2 = 1;
                }
                if (string3.charAt(0) != '/' || !string3.substring(1).equalsIgnoreCase(parser.moduleName)) {
                    n2 = -1;
                }
            }
            String string7 = string3 = n2 < 0 ? new File(string2).getParent() : string2.substring(0, n2);
            if (string3 == null) {
                string3 = new File("").getAbsolutePath();
            }
            this.sourcePath = new String[]{string3};
        }
        if (this.definedClasses.containsKey(string3 = parser.moduleName.toLowerCase())) {
            throw new CompileException(0, 0, (this.definedClasses.get(string3) == null ? "Circular module dependency: " : "Duplicate module name: ") + string3.replace('/', '.'));
        }
        if (this.depDestDir != null && (yetiAnalyzer.flags & 0x200) == 0) {
            yetiAnalyzer.targetFile = new File(this.depDestDir, parser.moduleName.concat(".class"));
            yetiAnalyzer.targetTime = yetiAnalyzer.targetFile.lastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ModuleType compile(String string2, char[] cArray, int n) throws Exception {
        YetiAnalyzer yetiAnalyzer = new YetiAnalyzer();
        yetiAnalyzer.flags = n;
        yetiAnalyzer.compiler = this;
        yetiAnalyzer.sourceName = string2;
        if (cArray == null && (cArray = this.readSource(yetiAnalyzer)) == null) {
            ModuleType moduleType;
            if (yetiAnalyzer.resolvedType != null) {
                moduleType = yetiAnalyzer.resolvedType;
                return moduleType;
            }
            moduleType = (ModuleType)this.compiled.get(yetiAnalyzer.canonicalFile);
            return moduleType;
        }
        Object t = currentCompiler.get();
        currentCompiler.set(this);
        String string3 = this.currentSrc;
        this.currentSrc = yetiAnalyzer.sourceName;
        try {
            RootClosure rootClosure;
            try {
                yetiAnalyzer.preload = this.preload;
                rootClosure = yetiAnalyzer.toCode(cArray);
                if (rootClosure == null) {
                    ModuleType moduleType = yetiAnalyzer.resolvedType;
                    if (moduleType == null) {
                        moduleType = YetiTypeVisitor.readType(this, new FileInputStream(yetiAnalyzer.targetFile));
                        this.types.put(moduleType.name, moduleType);
                        moduleType.topDoc = yetiAnalyzer.topDoc;
                    }
                    moduleType.lastModified = yetiAnalyzer.targetTime;
                    moduleType.hasSource = true;
                    this.compiled.put(yetiAnalyzer.canonicalFile, moduleType);
                    ModuleType moduleType2 = moduleType;
                    return moduleType2;
                }
            }
            finally {
                currentCompiler.set(t);
            }
            String string4 = rootClosure.moduleType.name;
            if (string4 == null) {
                throw new CompileException(0, 0, "internal error: module/program name undefined");
            }
            ModuleType moduleType = (ModuleType)this.types.get(string4);
            if (moduleType != null && (n & 0x200) == 0) {
                return moduleType;
            }
            if (rootClosure.isModule) {
                this.types.put(string4, rootClosure.moduleType);
            }
            if (this.writer != null) {
                this.generateCode(yetiAnalyzer, rootClosure);
            }
            this.compiled.put(yetiAnalyzer.canonicalFile, rootClosure.moduleType);
            this.classPath.existsCache.clear();
            this.currentSrc = string3;
            return rootClosure.moduleType;
        }
        catch (CompileException compileException) {
            if (compileException.fn != null) throw compileException;
            compileException.fn = yetiAnalyzer.sourceName;
            throw compileException;
        }
    }

    private void generateCode(YetiAnalyzer yetiAnalyzer, RootClosure rootClosure) throws Exception {
        Ctx ctx;
        String string2 = rootClosure.moduleType.name;
        Constants constants = new Constants(yetiAnalyzer.sourceName, yetiAnalyzer.sourceFile);
        constants.ctx = ctx = new Ctx(this, constants, null, null).newClass(0x21 | (rootClosure.isModule && rootClosure.moduleType.deprecated ? 131072 : 0), string2, (yetiAnalyzer.flags & 4) != 0 ? "yeti/lang/Fun" : null, null, rootClosure.line);
        if (rootClosure.isModule) {
            this.moduleEval(rootClosure, ctx, string2);
        } else if ((yetiAnalyzer.flags & 4) != 0) {
            ctx.createInit(1, "yeti/lang/Fun");
            ctx = ctx.newMethod(1, "apply", "(Ljava/lang/Object;)Ljava/lang/Object;");
            rootClosure.gen(ctx);
            ctx.insn(176);
            ctx.closeMethod();
        } else {
            ctx = ctx.newMethod(9, "main", "([Ljava/lang/String;)V");
            ++ctx.localVarCount;
            ctx.load(0).methodInsn(184, "yeti/lang/Core", "setArgv", "([Ljava/lang/String;)V");
            Label label = new Label();
            ctx.visitLabel(label);
            rootClosure.gen(ctx);
            ctx.insn(87);
            ctx.insn(177);
            Label label2 = new Label();
            ctx.tryCatchBlock(label, label2, label2, "yeti/lang/ExitError");
            ctx.visitLabel(label2);
            ctx.methodInsn(182, "yeti/lang/ExitError", "getExitCode", "()I");
            ctx.methodInsn(184, "java/lang/System", "exit", "(I)V");
            ctx.insn(177);
            ctx.closeMethod();
        }
        constants.close();
        this.write(constants.unstoredClasses);
    }

    private void moduleEval(RootClosure rootClosure, Ctx ctx, String string2) {
        ctx.cw.visitField(10, "$", "Ljava/lang/Object;", null, null).visitEnd();
        ctx.cw.visitField(74, "_$", "I", null, null);
        Ctx ctx2 = ctx.newMethod(41, "eval", "()Ljava/lang/Object;");
        ctx2.fieldInsn(178, string2, "_$", "I");
        Label label = new Label();
        ctx2.jumpInsn(158, label);
        ctx2.fieldInsn(178, string2, "$", "Ljava/lang/Object;");
        ctx2.insn(176);
        ctx2.visitLabel(label);
        ctx2.intConst(-1);
        ctx2.fieldInsn(179, string2, "_$", "I");
        Code code = rootClosure.body;
        while (code instanceof SeqExpr) {
            code = ((SeqExpr)code).result;
        }
        Map map3 = Collections.EMPTY_MAP;
        if (code instanceof StructConstructor) {
            ((StructConstructor)code).publish();
            rootClosure.gen(ctx2);
            map3 = ((StructConstructor)code).getDirect();
        } else {
            rootClosure.gen(ctx2);
        }
        ctx2.cw.visitAttribute(new TypeAttr(rootClosure.moduleType, this));
        if (rootClosure.type.type == 11) {
            this.generateModuleAccessors(rootClosure.type.allowedMembers, ctx2, map3);
        }
        ctx2.insn(89);
        ctx2.fieldInsn(179, string2, "$", "Ljava/lang/Object;");
        ctx2.intConst(1);
        ctx2.fieldInsn(179, string2, "_$", "I");
        ctx2.insn(176);
        ctx2.closeMethod();
        ctx2 = ctx.newMethod(9, "init", "()V");
        this.genFastInit(ctx2);
        ctx2.insn(177);
        ctx2.closeMethod();
    }

    private void genFastInit(Ctx ctx) {
        ctx.fieldInsn(178, ctx.className, "_$", "I");
        Label label = new Label();
        ctx.jumpInsn(154, label);
        ctx.methodInsn(184, ctx.className, "eval", "()Ljava/lang/Object;");
        ctx.insn(87);
        ctx.visitLabel(label);
    }

    void addClass(String string2, Ctx ctx, int n) {
        if (this.definedClasses.put(string2.toLowerCase(), ctx) != null) {
            throw new CompileException(n, 0, "Duplicate class: " + string2.replace('/', '.'));
        }
        if (ctx != null) {
            ctx.constants.unstoredClasses.add(ctx);
        }
    }

    private void write(List list2) throws Exception {
        int n;
        if (this.writer == null) {
            return;
        }
        int n2 = this.postGen.size();
        for (n = 0; n < n2; ++n) {
            ((Runnable)this.postGen.get(n)).run();
        }
        this.postGen.clear();
        n2 = list2.size();
        for (n = 0; n < n2; ++n) {
            Ctx ctx = (Ctx)list2.get(n);
            this.definedClasses.put(ctx.className.toLowerCase(), "");
            String string2 = ctx.className + ".class";
            byte[] byArray = ctx.cw.toByteArray();
            this.writer.writeClass(string2, byArray);
            this.classPath.define(string2, byArray);
        }
    }
}

