/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import yeti.lang.compiler.Code;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.YType;

final class NewArrayExpr
extends Code {
    private Code count;
    private int line;

    NewArrayExpr(YType yType, Code code, int n) {
        this.type = yType;
        this.count = code;
        this.line = n;
    }

    void gen(Ctx ctx) {
        int n;
        if (this.count != null) {
            this.count.genInt(ctx, this.line, false);
        }
        ctx.visitLine(this.line);
        if (this.type.param[0].type != 13) {
            ctx.typeInsn(189, JavaType.descriptionOf(this.type.param[0]));
            return;
        }
        JavaType javaType = this.type.param[0].javaType;
        switch (javaType.description.charAt(0)) {
            case 'B': {
                n = 8;
                break;
            }
            case 'C': {
                n = 5;
                break;
            }
            case 'D': {
                n = 7;
                break;
            }
            case 'F': {
                n = 6;
                break;
            }
            case 'I': {
                n = 10;
                break;
            }
            case 'J': {
                n = 11;
                break;
            }
            case 'S': {
                n = 9;
                break;
            }
            case 'Z': {
                n = 4;
                break;
            }
            case 'L': {
                ctx.typeInsn(189, javaType.className());
                return;
            }
            default: {
                throw new IllegalStateException("ARRAY<" + javaType.description + '>');
            }
        }
        ctx.visitIntInsn(188, n);
    }
}

