/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CodeGen;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.SimpleCode;
import yeti.lang.compiler.StaticRef;
import yeti.lang.compiler.StringConstant;
import yeti.lang.compiler.YType;

final class RegexFun
extends StaticRef
implements CodeGen {
    private String impl;
    private String funName;

    RegexFun(String string2, String string3, YType yType, Binder binder, int n) {
        super(string2, yType, false, n);
        this.funName = string2;
        this.binder = binder;
        this.impl = string3;
    }

    public void gen2(Ctx ctx, Code code, int n) {
        ctx.typeInsn(187, this.impl);
        ctx.insn(89);
        code.gen(ctx);
        ctx.visitLine(n);
        ctx.visitInit(this.impl, "(Ljava/lang/Object;)V");
    }

    Code apply(final Code code, final YType yType, int n) {
        final SimpleCode simpleCode = new SimpleCode(this, code, yType, n);
        if (!(code instanceof StringConstant)) {
            return simpleCode;
        }
        try {
            Pattern.compile(((StringConstant)code).str, 32);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new CompileException(n, 0, "Bad pattern syntax: " + patternSyntaxException.getMessage());
        }
        return new Code(){
            {
                this.type = yType;
            }

            void gen(Ctx ctx) {
                ctx.constant(RegexFun.this.funName + ":regex:" + ((StringConstant)code).str, simpleCode);
            }
        };
    }
}

