/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import yeti.lang.Core;
import yeti.lang.Num;
import yeti.lang.compiler.CompileException;

interface YetiParser {
    public static final ThreadLocal currentSrc = new ThreadLocal();
    public static final String FIELD_OP = new String(".");

    public static final class Parser {
        private static final char[] CHS = "                                 .'.x..x  .. ../xxxxxxxxxx. ...x.xxxxxxxxxxxxxxxxxxxxxxxxxx[ ].x`xxxxxxxxxxxxxxxxxxxxxxxxxx . . ".toCharArray();
        private static final String[][] OPS = new String[][]{{"*", "/", "%"}, {"+", "-"}, {null}, {"."}, {"<", ">", "<=", ">=", "==", "!=", "=~", "!~"}, {null}, {null}, {"^"}, {"::", ":.", "++"}, {"|>"}, {"is"}, {":="}, {null}};
        private static final int FIRST_OP_LEVEL = 3;
        private static final int COMP_OP_LEVEL = Parser.opLevel("<");
        static final int NOT_OP_LEVEL = COMP_OP_LEVEL + 1;
        static final int LIST_OP_LEVEL = NOT_OP_LEVEL + 3;
        static final int IS_OP_LEVEL = Parser.opLevel("is");
        private static final Eof EOF = new Eof("EOF");
        private char[] src;
        private int p;
        private Node eofWas;
        private int flags;
        private int line = 1;
        private int lineStart;
        private String yetiDocStr;
        private boolean yetiDocReset;
        XNode loads;
        String sourceName;
        String moduleName;
        int moduleNameLine;
        String topDoc;
        boolean isModule;
        boolean deprecated;
        private static final String EXPECT_DEF = "Expected field or method definition, found";
        private static final int TYPE_NORMAL = 0;
        private static final int TYPE_FUNRET = 1;
        private static final int TYPE_VARIANT = 2;
        private static final int TYPE_VARIANT_ARG = 3;

        private static int opLevel(String string2) {
            int n = 0;
            while (OPS[n][0] != string2) {
                ++n;
            }
            return n + 3;
        }

        Parser(String string2, char[] cArray, int n) {
            this.sourceName = string2;
            this.src = cArray;
            this.flags = n;
        }

        int currentLine() {
            return this.line;
        }

        private int directive(int n, int n2) {
            boolean bl;
            boolean bl2 = bl = this.src[n] != '%';
            if (bl && (this.flags & 0x40) == 0) {
                return n2;
            }
            String string2 = new String(this.src, ++n, n2 - n);
            if (bl) {
                this.yetiDocStr = this.yetiDocStr == null || this.yetiDocReset ? string2 : this.yetiDocStr + '\n' + string2;
                this.yetiDocReset = false;
            } else if (string2.length() >= 2) {
                if (string2.charAt(0) == ':') {
                    try {
                        this.line = Integer.parseInt(string2.substring(1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new CompileException(this.line, n - this.lineStart, "Bad line directive");
                    }
                } else if (string2.startsWith("FILE='")) {
                    this.p = n + 6;
                    this.sourceName = this.readAStr().str;
                    return this.p > n2 ? this.p : n2;
                }
            }
            return n2;
        }

        private int skipSpace() {
            char[] cArray = this.src;
            int n = this.p;
            this.yetiDocReset = true;
            while (true) {
                int n2;
                char c2;
                if (n < cArray.length && ((c2 = cArray[n]) >= '\u0000' && c2 <= ' ' || c2 == '\u00a0')) {
                    ++n;
                    if (c2 != '\n') continue;
                    ++this.line;
                    this.lineStart = n;
                    continue;
                }
                if (n + 1 >= cArray.length || cArray[n] != '/') break;
                if (cArray[n + 1] == '/') {
                    n2 = n += 2;
                    while (n < cArray.length && cArray[n] != '\n' && cArray[n] != '\r') {
                        ++n;
                    }
                    if (n <= n2 || cArray[n2] != '/' && cArray[n2] != '%') continue;
                    n = this.directive(n2, n);
                    continue;
                }
                if (cArray[n + 1] != '*') break;
                int n3 = this.line;
                int n4 = n - this.lineStart + 1;
                n2 = n += 2;
                int n5 = 1;
                while (n5 > 0) {
                    if (++n >= cArray.length) {
                        throw new CompileException(n3, n4, "Unclosed /* comment");
                    }
                    c2 = cArray[n - 1];
                    if (c2 == '\n') {
                        ++this.line;
                        this.lineStart = n - 1;
                        continue;
                    }
                    if (c2 == '*' && cArray[n] == '/') {
                        ++n;
                        --n5;
                        continue;
                    }
                    if (c2 != '/' || cArray[n] != '*') continue;
                    ++n;
                    ++n5;
                }
                if (n - 3 <= n2 || cArray[n2] != '*') continue;
                this.directive(n2, n - 2);
            }
            return n;
        }

        private Node fetch() {
            Node node;
            char c2;
            int n = this.skipSpace();
            if (n >= this.src.length) {
                return EOF;
            }
            char[] cArray = this.src;
            this.p = n + 1;
            int n2 = this.line;
            int n3 = this.p - this.lineStart;
            switch (cArray[n]) {
                case '.': {
                    if (n > 0 && ((c2 = cArray[n - 1]) >= '~' || CHS[c2] != ' ' || n + 1 < cArray.length && ((c2 = cArray[n + 1]) >= '~' || CHS[c2] != ' '))) break;
                    return new BinOp(".", COMP_OP_LEVEL - 1, true).pos(n2, n3);
                }
                case ';': {
                    return new XNode(";").pos(n2, n3);
                }
                case ',': {
                    return new XNode(",").pos(n2, n3);
                }
                case '(': {
                    return this.readSeq(')', null);
                }
                case '[': {
                    return this.readList().pos(n2, n3);
                }
                case '{': {
                    return XNode.struct(this.readMany(",", '}')).pos(n2, n3);
                }
                case ')': {
                    this.p = n;
                    return new Eof(")").pos(n2, n3);
                }
                case ']': {
                    this.p = n;
                    return new Eof("]").pos(n2, n3);
                }
                case '}': {
                    this.p = n;
                    return new Eof("}").pos(n2, n3);
                }
                case '\"': {
                    return this.readStr().pos(n2, n3);
                }
                case '\'': {
                    return this.readAStr().pos(n2, n3);
                }
                case '\\': {
                    return new BinOp("\\", 1, false).pos(n2, n3);
                }
            }
            this.p = n;
            while (n < cArray.length && (c2 = cArray[n]) <= '~' && (CHS[c2] == '.' || c2 == '$' || c2 == '/' && (n + 1 >= cArray.length || (c2 = cArray[n + 1]) != '/' && c2 != '*'))) {
                ++n;
            }
            if (n != this.p) {
                String string2 = new String(cArray, this.p, n - this.p).intern();
                this.p = n;
                if (string2 == "=" || string2 == ":") {
                    return new XNode(string2).pos(n2, n3);
                }
                if (string2 == ".") {
                    return new BinOp(FIELD_OP, 0, true).pos(n2, n3);
                }
                if (string2 == "#") {
                    return this.readObjectRef().pos(n2, n3);
                }
                n = OPS.length;
                while (--n >= 0) {
                    int n4 = OPS[n].length;
                    while (--n4 >= 0) {
                        if (OPS[n][n4] != string2) continue;
                        return new BinOp(string2, n + 3, n != LIST_OP_LEVEL - 3).pos(n2, n3);
                    }
                }
                if (string2 == "->") {
                    return new BinOp("->", 0, true).pos(n2, n3);
                }
                return new BinOp(string2, 5, true).pos(n2, n3);
            }
            c2 = cArray[n];
            if (c2 >= '0' && c2 <= '9') {
                while (!(++n >= cArray.length || (c2 = cArray[n]) > 'z' || CHS[c2] != 'x' && (c2 != '.' || n + 1 < cArray.length && cArray[n + 1] == '.') && (c2 != '+' && c2 != '-' || cArray[n - 1] != 'e' && cArray[n - 1] != 'E'))) {
                }
                String string3 = new String(cArray, this.p, n - this.p);
                this.p = n;
                try {
                    return new NumLit(Core.parseNum(string3)).pos(n2, n3);
                }
                catch (Exception exception) {
                    throw new CompileException(n2, n3, "Bad number literal '" + string3 + "'");
                }
            }
            while (++n < cArray.length && ((c2 = cArray[n]) > '~' || CHS[c2] == 'x')) {
            }
            String string4 = new String(cArray, this.p, n - this.p);
            this.p = n;
            if ((string4 = string4.intern()) == "if") {
                node = this.readIf();
            } else if (string4 == "do") {
                node = this.readDo();
            } else if (string4 == "and" || string4 == "or") {
                node = new BinOp(string4, NOT_OP_LEVEL + 1, true);
            } else if (string4 == "not") {
                node = new BinOp(string4, NOT_OP_LEVEL, true);
            } else if (string4 == "then" || string4 == "elif" || string4 == "else" || string4 == "fi" || string4 == "of" || string4 == "esac" || string4 == "done" || string4 == "catch" || string4 == "finally" || string4 == "yrt") {
                node = new Eof(string4);
            } else if (string4 == "case") {
                node = this.readCase();
            } else if (string4 == "in") {
                node = new BinOp(string4, COMP_OP_LEVEL, true);
            } else if (string4 == "div" || string4 == "shr" || string4 == "shl" || string4 == "b_and" || string4 == "with") {
                node = new BinOp(string4, 3, true);
            } else if (string4 == "b_or" || string4 == "xor") {
                node = new BinOp(string4, 4, true);
            } else {
                if (string4 == "is" || string4 == "unsafely_as" || string4 == "as") {
                    TypeNode typeNode = this.readType(0);
                    if (typeNode == null) {
                        throw new CompileException(n2, n3, "Expecting type expression");
                    }
                    return (string4 == "is" ? new IsOp(typeNode) : new TypeOp(string4, typeNode)).pos(n2, n3);
                }
                if (string4 == "new") {
                    node = this.readNew();
                } else if (string4 == "var" || string4 == "norec" || string4 == "fall") {
                    node = new XNode(string4);
                } else if (string4 == "loop") {
                    node = new BinOp(string4, IS_OP_LEVEL + 2, false);
                } else if (string4 == "import") {
                    node = this.readImport();
                } else if (string4 == "load") {
                    this.loads = new XNode(string4, new Node[]{this.readDotted("Expected module name after 'load', not a "), this.loads});
                    node = this.loads;
                } else if (string4 == "classOf") {
                    node = new XNode(string4, this.readDottedType("Expected class name, not a "));
                } else if (string4 == "typedef") {
                    node = this.readTypeDef();
                } else if (string4 == "try") {
                    node = this.readTry();
                } else if (string4 == "instanceof") {
                    node = new InstanceOf(this.readDotted((String)"Expected class name, not a ").sym);
                } else if (string4 == "class") {
                    node = this.readClassDef();
                } else if (string4.charAt(0) != '`') {
                    node = new Sym(string4);
                } else {
                    if (this.p >= cArray.length || cArray[this.p] != '`') {
                        throw new CompileException(n2, n3, "Syntax error");
                    }
                    if (string4.length() == 1) {
                        do {
                            if (++this.p < cArray.length && cArray[this.p] != '\n') continue;
                            throw new CompileException(n2, n3, "Unterminated ``identifier");
                        } while (cArray[this.p - 1] != '`' || cArray[this.p] != '`');
                        string4 = new String(cArray, n + 1, this.p - n - 2).intern();
                        node = new XNode("``", new Sym(string4));
                        ++this.p;
                    } else {
                        ++this.p;
                        node = new BinOp(string4.substring(1).intern(), 5, true);
                    }
                }
            }
            return node.pos(n2, n3);
        }

        private Node readList() {
            char c2;
            int n = this.p;
            if (n + 1 < this.src.length && this.src[n] == ':' && this.src[n + 1] == ']') {
                this.p = n + 2;
                return new XNode("list");
            }
            Node[] nodeArray = this.readMany(",", ']');
            if (nodeArray.length != 1 || n <= 1 || (c2 = this.src[n - 2]) < '~' && CHS[c2] == ' ' && c2 != ')' || nodeArray[0] instanceof BinOp && ((BinOp)nodeArray[0]).op == "..") {
                return new XNode("list", nodeArray);
            }
            ObjectRefOp objectRefOp = new ObjectRefOp(null, nodeArray);
            objectRefOp.kind = "listop";
            return objectRefOp;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private Node def(List var1_1, List var2_2, boolean var3_3, String var4_4) {
            block18: {
                var5_5 = null;
                var6_6 = null;
                var7_7 = 0;
                var8_8 = var2_2.size();
                if (var8_8 <= 0) break block18;
                var9_9 /* !! */  = var2_2.get(0);
                if (!(var9_9 /* !! */  instanceof BinOp)) ** GOTO lbl-1000
                var5_5 = (BinOp)var9_9 /* !! */ ;
                if (var5_5.parent == null && var5_5.op != "\\" && var5_5.op != "-" && var5_5.op != "not" && var5_5.op != "#") {
                    var6_6 = var5_5.op;
                    var7_7 = 1;
                } else if ((var9_9 /* !! */  = var2_2.get(var8_8 - 1)) instanceof BinOp) {
                    var5_5 = (BinOp)var9_9 /* !! */ ;
                    if (var5_5.parent == null && !var5_5.postfix) {
                        if (var5_5.op == "loop") {
                            var5_5.postfix = true;
                        } else {
                            var6_6 = var5_5.op;
                            --var8_8;
                        }
                        if (var6_6 == YetiParser.FIELD_OP) {
                            throw new CompileException((Node)var5_5, "Unexpected '.' here. Add space before it, if you want a compose section.");
                        }
                    }
                }
            }
            if (var6_6 != null && var7_7 >= var8_8) {
                if (var6_6 == "loop" || var6_6 == "with" || var5_5 instanceof IsOp) {
                    throw new CompileException((Node)var5_5, "Special operator `" + var6_6 + "` cannot be used as a function");
                }
                if (var5_5 instanceof TypeOp) {
                    var5_5.right = new Sym(var5_5.hashCode() + var5_5.op);
                    var5_5.right.pos(var5_5.line, var5_5.col);
                    return XNode.lambda(var5_5.right, var5_5, null);
                }
                return new Sym(var6_6).pos(var5_5.line, var5_5.col);
            }
            var9_9 /* !! */  = new ParseExpr();
            while (var7_7 < var8_8) {
                var9_9 /* !! */ .add((Node)var2_2.get(var7_7++));
            }
            var10_10 = var9_9 /* !! */ .result();
            if (var6_6 != null) {
                if (var8_8 < var2_2.size()) {
                    var11_11 /* !! */ .parent = var11_11 /* !! */  = new BinOp("", 2, true);
                    var11_11 /* !! */ .right = var10_10;
                    var11_11 /* !! */ .left = var10_10 = new Sym(var6_6);
                    var10_10.line = var5_5.line;
                    var10_10.col = var5_5.col;
                    var10_10 = var11_11 /* !! */ ;
                } else {
                    var10_10 = new XNode("rsection", new Node[]{new Sym(var6_6), var9_9 /* !! */ .result()});
                }
                var10_10.line = var5_5.line;
                var10_10.col = var5_5.col;
            }
            if (var1_1 == null) {
                v0 = var10_10;
            } else if (var1_1.size() == 1 && ((Node)var1_1.get((int)0)).kind == "struct") {
                v0 = new XNode("struct-bind", new Node[]{(XNode)var1_1.get(0), var10_10});
            } else {
                var11_11 /* !! */  = new Bind(var1_1, var10_10, var3_3, var4_4);
                v0 = var11_11 /* !! */ .name != "_" ? var11_11 /* !! */  : (var11_11 /* !! */ .expr.kind == "lambda" ? var11_11 /* !! */ .expr : new XNode("_", var11_11 /* !! */ .expr));
            }
            return v0;
        }

        private Node[] readArgs() {
            this.p = this.skipSpace();
            if (this.p >= this.src.length || this.src[this.p] != '(') {
                return null;
            }
            ++this.p;
            return this.readMany(",", ')');
        }

        private Node readNew() {
            int n;
            Node[] nodeArray = null;
            String string2 = "";
            int n2 = 0;
            while (nodeArray == null) {
                char c2;
                int n3 = this.line;
                n = this.p - this.lineStart + 1;
                Node node = this.fetch();
                if (!(node instanceof Sym)) {
                    throw new CompileException(n3, n, "Expecting class name after new");
                }
                string2 = string2 + ((Sym)node).sym;
                nodeArray = this.readArgs();
                if (nodeArray != null) continue;
                char c3 = c2 = this.p >= this.src.length ? (char)'\u0000' : this.src[this.p];
                if (c2 == '[') {
                    ++this.p;
                    nodeArray = new Node[]{this.readSeq(']', null)};
                    while (this.p + 1 < this.src.length && this.src[this.p] == '[' && this.src[this.p + 1] == ']') {
                        this.p += 2;
                        ++n2;
                    }
                    ++n2;
                    break;
                }
                if (c2 != '.' && c2 != '$') {
                    throw new CompileException(this.line, this.p - this.lineStart + 1, "Expecting constructor argument list");
                }
                ++this.p;
                string2 = string2 + (c2 == '.' ? (char)'/' : c2);
            }
            Node[] nodeArray2 = new Node[nodeArray.length + 1];
            for (n = 0; n < n2; ++n) {
                string2 = string2 + "[]";
            }
            nodeArray2[0] = new Sym(string2.intern());
            System.arraycopy(nodeArray, 0, nodeArray2, 1, nodeArray.length);
            return new XNode(n2 == 0 ? "new" : "new-array", nodeArray2);
        }

        private Node readObjectRef() {
            int n;
            int n2;
            int n3 = this.line;
            int n4 = this.p - this.lineStart + 1;
            for (n2 = n = this.skipSpace(); n2 < this.src.length && Character.isJavaIdentifierPart(this.src[n2]); ++n2) {
            }
            if (n2 == n) {
                throw new CompileException(n3, n4, "Expecting java identifier after #");
            }
            this.p = n2;
            return new ObjectRefOp(new String(this.src, n, n2 - n).intern(), n2 < this.src.length && this.src[n2] == '(' ? this.readArgs() : null);
        }

        private Node readIf() {
            Node node;
            Node node2 = this.readSeqTo("then");
            Node node3 = this.readSeq(' ', null);
            if (this.eofWas.kind == "elif") {
                node = this.readIf();
            } else {
                if (this.eofWas.kind == "else") {
                    if (this.src.length > this.p && this.src[this.p] == ':') {
                        ++this.p;
                        ArrayList<Node> arrayList = new ArrayList<Node>();
                        while (!((node = this.fetch()) instanceof Eof) && node.kind != ";") {
                            arrayList.add(node);
                        }
                        if (arrayList.size() == 0) {
                            throw new CompileException(node, "Unexpected " + node);
                        }
                        if (node.kind == ";" || node.kind != "EOF" && node.kind.length() > 1) {
                            this.p -= node.kind.length();
                        }
                        node = this.def(null, arrayList, false, null);
                        this.eofWas = null;
                    } else {
                        node = this.readSeq(' ', null);
                    }
                } else {
                    node = this.eofWas;
                }
                if (this.eofWas != null && this.eofWas.kind != "fi") {
                    throw new CompileException(this.eofWas, "Expected fi, found " + this.eofWas);
                }
            }
            return new XNode("if", new Node[]{node2, node3, node});
        }

        private void addCase(List list2, XNode xNode, List list3) {
            if (list3.size() == 0) {
                throw new CompileException((Node)xNode, "Missing expression");
            }
            Node node = list3.size() == 1 ? (Node)list3.get(0) : new Seq(list3.toArray(new Node[list3.size()]), null).pos(xNode.line, xNode.col);
            xNode.expr = new Node[]{xNode.expr[0], node};
            list2.add(xNode);
        }

        private Node readCase() {
            Node node = this.readSeqTo("of");
            Node[] nodeArray = this.readMany(";", ' ');
            if (this.eofWas.kind != "esac") {
                throw new CompileException(this.eofWas, "Expected esac, found " + this.eofWas);
            }
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length + 1);
            arrayList.add(node);
            XNode xNode = null;
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i].kind == ":") {
                    if (xNode != null) {
                        this.addCase(arrayList, xNode, arrayList2);
                        arrayList2.clear();
                    }
                    xNode = (XNode)nodeArray[i];
                    continue;
                }
                if (nodeArray[i] instanceof Sym && nodeArray[i].sym() == "...") {
                    if (i == 0 || i != nodeArray.length - 1) {
                        throw new CompileException(nodeArray[i], "Unexpected ...");
                    }
                    this.addCase(arrayList, xNode, arrayList2);
                    xNode = null;
                    arrayList.add(new XNode("...", nodeArray[i]));
                    continue;
                }
                if (xNode != null) {
                    arrayList2.add(nodeArray[i]);
                    continue;
                }
                throw new CompileException(nodeArray[i], "Expecting option, not a " + nodeArray[i]);
            }
            if (xNode != null) {
                this.addCase(arrayList, xNode, arrayList2);
            }
            return new XNode("case-of", arrayList.toArray(new Node[arrayList.size()]));
        }

        private Node readTry() {
            Node[] nodeArray;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.readSeq(' ', null));
            while (this.eofWas.kind != "finally" && this.eofWas.kind != "yrt") {
                if (this.eofWas.kind != "catch") {
                    throw new CompileException(this.eofWas, "Expected finally or yrt, found " + this.eofWas);
                }
                nodeArray = (XNode)this.eofWas;
                arrayList.add(nodeArray);
                nodeArray.expr = new Node[3];
                nodeArray.expr[0] = this.readDotted("Expected exception name, not ");
                Node node = this.fetch();
                if (node instanceof Sym) {
                    nodeArray.expr[1] = node;
                    node = this.fetch();
                }
                if (node.kind != ":") {
                    throw new CompileException(node, "Expected ':'" + (nodeArray.expr[1] == null ? " or identifier" : "") + ", but found " + node);
                }
                if (nodeArray.expr[1] == null) {
                    nodeArray.expr[1] = new Sym("_").pos(node.line, node.col);
                }
                nodeArray.expr[2] = this.readSeq(' ', null);
            }
            if (this.eofWas.kind != "yrt") {
                arrayList.add(this.readSeqTo("yrt"));
            }
            if ((nodeArray = arrayList.toArray(new Node[arrayList.size()])).length <= 1) {
                throw new CompileException(this.eofWas, "try block must contain at least one catch or finally");
            }
            return new XNode("try", nodeArray);
        }

        private Sym readDottedType(String string2) {
            Sym sym = this.readDotted(string2);
            int n = this.p;
            while (this.src.length > this.p + 1 && this.src[this.p] == '[' && this.src[this.p + 1] == ']') {
                this.p += 2;
            }
            if (n != this.p) {
                sym.sym = sym.sym.concat(new String(this.src, n, this.p - n)).intern();
            }
            return sym;
        }

        private Node readArgDefs() {
            int n = this.line;
            int n2 = this.p++ - this.lineStart + 1;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            while ((this.p = this.skipSpace()) < this.src.length && this.src[this.p] != ')') {
                if (arrayList.size() != 0 && this.src[this.p++] != ',') {
                    throw new CompileException(this.line, this.p - this.lineStart, "Expecting , or )");
                }
                arrayList.add(this.readDottedType("Expected argument type, found "));
                Node node = this.fetch();
                if (!(node instanceof Sym)) {
                    throw new CompileException(node, "Expected an argument name, found " + node);
                }
                arrayList.add(node);
            }
            ++this.p;
            return new XNode("argument-list", arrayList.toArray(new Node[arrayList.size()])).pos(n, n2);
        }

        private Node readClassDef() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node = this.fetch();
            if (!(node instanceof Sym)) {
                throw new CompileException(node, "Expected a class name, found " + node);
            }
            this.p = this.skipSpace();
            arrayList.add(node);
            arrayList.add(this.p < this.src.length && this.src[this.p] == '(' ? this.readArgDefs() : new XNode("argument-list", new Node[0]));
            this.yetiDocStr = null;
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            Node node2 = node = this.readDottedType("Expected extends, field or method definition, found ");
            if (node.sym() == "extends") {
                do {
                    arrayList2.add(this.readDotted("Expected a class name, found "));
                    int n = this.line;
                    int n2 = this.p - this.lineStart + 1;
                    arrayList2.add(new XNode("arguments", this.readArgs()).pos(n, n2));
                } while ((this.p = this.skipSpace()) < this.src.length && this.src[this.p++] == ',');
                --this.p;
                node = this.readDottedType(EXPECT_DEF);
            }
            arrayList.add(new XNode("extends", arrayList2.toArray(new Node[arrayList2.size()])).pos(node2.line, node2.col));
            arrayList2.clear();
            this.eofWas = node;
            block1: while (!(this.eofWas instanceof Sym) || ((Sym)this.eofWas).sym != "end") {
                Object object;
                String string2;
                if (node == null) {
                    node = this.readDottedType(EXPECT_DEF);
                }
                if ((string2 = node.sym()) == "var" || string2 == "norec") {
                    arrayList2.add(new XNode(string2).pos(node.line, node.col));
                    node = this.fetch();
                }
                String string3 = this.yetiDocStr;
                String string4 = "method";
                Node node3 = null;
                while (node instanceof Sym) {
                    this.p = this.skipSpace();
                    if (this.p < this.src.length && this.src[this.p] == '(') {
                        if (string4 == "error") {
                            throw new CompileException(this.line, this.p - this.lineStart + 1, "Static method cannot be abstract");
                        }
                        if (string4 != "method") {
                            arrayList2.remove(0);
                        }
                        if (arrayList2.size() == 0) {
                            throw new CompileException(this.line, this.p - this.lineStart + 1, "Expected method name, found (");
                        }
                        if (arrayList2.size() != 1) break;
                        node3 = this.readArgDefs();
                        break;
                    }
                    if (((Sym)node).sym == "end" && arrayList2.size() == 0) break block1;
                    arrayList2.add(node);
                    object = node.sym();
                    if (object == "static" || object == "abstract") {
                        string4 = string4 != "method" ? "error" : (object == "static" ? "static-method" : "abstract-method");
                        node = this.readDottedType(EXPECT_DEF);
                        continue;
                    }
                    node = this.fetch();
                }
                if (node3 == null) {
                    if (node instanceof IsOp) {
                        arrayList2.add(node);
                        node = this.fetch();
                    }
                    if (node.kind != "=") {
                        throw new CompileException(node, "Expected '=' or argument list, found " + node);
                    }
                }
                if (string4 == "abstract-method") {
                    object = null;
                    this.eofWas = this.fetch();
                } else {
                    object = this.readSeq('e', null);
                }
                if (!(this.eofWas.kind == "," || this.eofWas instanceof Sym && ((Sym)this.eofWas).sym == "end")) {
                    throw new CompileException(this.eofWas, "Unexpected " + this.eofWas);
                }
                if (node3 == null) {
                    arrayList.add(new Bind(arrayList2, (Node)object, false, string3));
                } else {
                    Node[] nodeArray;
                    if (object != null) {
                        Node[] nodeArray2 = new Node[4];
                        nodeArray2[0] = (Node)arrayList2.get(0);
                        nodeArray2[1] = node;
                        nodeArray2[2] = node3;
                        nodeArray = nodeArray2;
                        nodeArray2[3] = object;
                    } else {
                        Node[] nodeArray3 = new Node[3];
                        nodeArray3[0] = (Node)arrayList2.get(0);
                        nodeArray3[1] = node;
                        nodeArray = nodeArray3;
                        nodeArray3[2] = node3;
                    }
                    Node[] nodeArray4 = nodeArray;
                    arrayList.add(new XNode(string4, nodeArray4).pos(node.line, node.col));
                }
                arrayList2.clear();
                node = null;
                this.yetiDocStr = null;
            }
            return new XNode("class", arrayList.toArray(new Node[arrayList.size()]));
        }

        private Node readDo() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            while (true) {
                Node node;
                if ((node = this.fetch()) instanceof Eof) {
                    throw new CompileException(node, "Unexpected " + node);
                }
                if (node.kind == ":") {
                    Node node2 = this.readSeqTo("done");
                    if (arrayList.isEmpty()) {
                        return XNode.lambda(new Sym("_").pos(node.line, node.col), node2, null);
                    }
                    int n = arrayList.size();
                    while (--n >= 0) {
                        node2 = XNode.lambda((Node)arrayList.get(n), node2, null);
                    }
                    return node2;
                }
                arrayList.add(node);
            }
        }

        private Sym readDotted(String string2) {
            Node node = this.fetch();
            String string3 = "";
            Node node2 = node;
            while (true) {
                if (!(node2 instanceof Sym)) {
                    if (node2.kind != "var") {
                        throw new CompileException(node2, string2 + node2);
                    }
                    string3 = string3 + node2.kind;
                } else {
                    string3 = string3 + ((Sym)node2).sym;
                }
                this.p = this.skipSpace();
                if (this.p >= this.src.length || this.src[this.p] != '.') break;
                ++this.p;
                string3 = string3 + "/";
                node2 = this.fetch();
            }
            node2 = new Sym(string3.intern());
            node2.pos(node.line, node.col);
            return node2;
        }

        private XNode readImport() {
            Sym sym = this.readDotted("Expected class path after 'import', not a ");
            ArrayList<Sym> arrayList = null;
            int n = 58;
            while ((this.p = this.skipSpace()) < this.src.length && this.src[this.p] == n) {
                ++this.p;
                if (arrayList == null) {
                    arrayList = new ArrayList<Sym>();
                }
                arrayList.add(new Sym(sym.sym + '/' + this.fetch().sym()));
                n = 44;
            }
            return arrayList == null ? new XNode("import", sym) : new XNode("import", arrayList.toArray(new Node[arrayList.size()]));
        }

        private Node[] readMany(String string2, char c2) {
            Node node;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            ArrayList<Node> arrayList2 = null;
            List<Object> list2 = new ArrayList<Node>();
            String string3 = null;
            this.yetiDocStr = null;
            while (!((node = this.fetch()) instanceof Eof)) {
                if (string3 == null) {
                    string3 = this.yetiDocStr;
                }
                if (c2 == 'e' && node instanceof Sym && node.sym() == "end") break;
                if (node.kind == ":" && arrayList2 == null) {
                    if (list2.size() == 0) {
                        throw new CompileException(node, "Unexpected `:'");
                    }
                    XNode xNode = (XNode)node;
                    xNode.expr = new Node[]{this.def(null, list2, false, null)};
                    xNode.doc = string3;
                    string3 = null;
                    this.yetiDocStr = null;
                    list2 = new ArrayList();
                    arrayList.add(node);
                    continue;
                }
                if (node.kind == "=") {
                    arrayList2 = list2;
                    if (c2 == '}') {
                        list2 = Collections.singletonList(this.readSeq(' ', "{}"));
                        node = this.eofWas;
                        if (node instanceof Eof) {
                            break;
                        }
                    } else {
                        list2 = new ArrayList();
                        continue;
                    }
                }
                if (node.kind == ";" || node.kind == ",") {
                    if (node.kind != string2) break;
                    if (arrayList2 == null && string2 == ";" && list2.size() == 0) {
                        continue;
                    }
                } else {
                    list2.add(node);
                    if (string2 != ";" || !(node instanceof TypeDef)) continue;
                }
                if (list2.size() == 0) {
                    throw new CompileException(node, "Unexpected " + node);
                }
                arrayList.add(this.def(arrayList2, list2, c2 == '}', string3));
                if (arrayList2 != null) {
                    string3 = null;
                }
                arrayList2 = null;
                list2 = new ArrayList();
                this.yetiDocStr = null;
            }
            this.eofWas = node;
            if (c2 != ' ' && c2 != 'e' && (this.p >= this.src.length || this.src[this.p++] != c2)) {
                throw new CompileException(this.line, this.p - this.lineStart + 1, "Expecting " + c2);
            }
            if (list2.size() != 0) {
                arrayList.add(this.def(arrayList2, list2, c2 == '}', string3));
            } else if (arrayList2 != null) {
                throw new CompileException(this.line, this.p - this.lineStart, "Expression missing after `='");
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }

        private Node readSeq(char c2, Object object) {
            String string2 = this.yetiDocStr;
            Node[] nodeArray = this.readMany(";", c2);
            if (nodeArray.length == 1 && object != Seq.EVAL) {
                if (string2 != null && nodeArray[0] instanceof Sym) {
                    this.yetiDocStr = string2;
                }
                return nodeArray[0];
            }
            if (nodeArray.length == 0) {
                return new XNode("()", c2 == ')' ? null : new Node[]{}).pos(this.line, this.p - this.lineStart);
            }
            Node node = nodeArray[nodeArray.length - 1];
            while (node instanceof BinOp) {
                BinOp binOp = (BinOp)node;
                if (binOp.left == null) break;
                node = binOp.left;
            }
            return new Seq(nodeArray, object).pos(node.line, node.col);
        }

        private Node readSeqTo(String string2) {
            Node node = this.readSeq(' ', null);
            if (this.eofWas.kind != string2) {
                throw new CompileException(this.eofWas, "Expected " + string2 + ", found " + this.eofWas);
            }
            return node;
        }

        private Node readStr() {
            boolean bl;
            int n = this.p;
            ArrayList<Str> arrayList = null;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.line;
            int n3 = this.p - this.lineStart;
            if (this.p + 1 < this.src.length && this.src[this.p] == '\"' && this.src[this.p + 1] == '\"') {
                n = this.p += 2;
                bl = true;
            } else {
                bl = false;
            }
            while (this.p < this.src.length && (this.src[this.p] != '\"' || bl && this.p + 2 < this.src.length && this.src[this.p + 1] != '\"' && this.src[this.p + 2] != '\"')) {
                block30: {
                    if (this.src[this.p] == '\n') {
                        this.lineStart = this.p + 1;
                        ++this.line;
                    }
                    if (this.src[this.p] == '\\') {
                        stringBuffer.append(this.src, n, this.p - n);
                        n = ++this.p;
                        if (this.p >= this.src.length) break;
                        switch (this.src[this.p]) {
                            case '\"': 
                            case '\\': {
                                break block30;
                            }
                            case 'a': {
                                stringBuffer.append('\u0007');
                                break;
                            }
                            case 'b': {
                                stringBuffer.append('\b');
                                break;
                            }
                            case 'f': {
                                stringBuffer.append('\f');
                                break;
                            }
                            case 'n': {
                                stringBuffer.append('\n');
                                break;
                            }
                            case 'r': {
                                stringBuffer.append('\r');
                                break;
                            }
                            case 't': {
                                stringBuffer.append('\t');
                                break;
                            }
                            case 'e': {
                                stringBuffer.append('\u001b');
                                break;
                            }
                            case '0': {
                                stringBuffer.append('\u0000');
                                break;
                            }
                            case '(': {
                                ++this.p;
                                if (arrayList == null) {
                                    arrayList = new ArrayList<Str>();
                                }
                                if (stringBuffer.length() != 0) {
                                    arrayList.add(new Str(stringBuffer.toString()));
                                }
                                arrayList.add((Str)this.readSeq(')', null));
                                stringBuffer.setLength(0);
                                n = --this.p;
                                break;
                            }
                            case 'u': {
                                if ((n += 4) > this.src.length) {
                                    n = this.src.length;
                                }
                                int n4 = n - this.p;
                                String string2 = new String(this.src, this.p + 1, n4);
                                if (n4 == 4) {
                                    try {
                                        stringBuffer.append((char)Integer.parseInt(string2, 16));
                                        break;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                throw new CompileException(this.line, this.p - this.lineStart, "Invalid unicode escape code \\u" + string2);
                            }
                            default: {
                                if (this.src[this.p] > ' ') {
                                    throw new CompileException(this.line, this.p - this.lineStart, "Unexpected escape: \\" + this.src[this.p]);
                                }
                                this.p = this.skipSpace();
                                if (this.p >= this.src.length || this.src[this.p] != '\"') {
                                    throw new CompileException(this.line, this.p - this.lineStart, "Expecting continuation of string");
                                }
                                n = this.p;
                            }
                        }
                        ++n;
                    }
                }
                ++this.p;
            }
            if (this.p >= this.src.length) {
                throw new CompileException(n2, n3, bl ? "Unclosed \"\"\"" : "Unclosed \"");
            }
            stringBuffer.append(this.src, n, this.p++ - n);
            if (bl) {
                this.p += 2;
            }
            if (arrayList == null) {
                return new Str(stringBuffer.toString());
            }
            if (stringBuffer.length() != 0) {
                arrayList.add(new Str(stringBuffer.toString()));
            }
            return new XNode("concat", arrayList.toArray(new Node[arrayList.size()]));
        }

        private Str readAStr() {
            int n = this.p;
            int n2 = this.line;
            int n3 = n - this.lineStart;
            String string2 = "";
            while (true) {
                if (n < this.src.length && this.src[n] != '\'') {
                    if (this.src[n] == '\n') {
                        this.lineStart = n + 1;
                        ++this.line;
                    }
                    ++n;
                    continue;
                }
                if (n >= this.src.length) {
                    throw new CompileException(n2, n3, "Unclosed '");
                }
                string2 = string2.concat(new String(this.src, this.p, n - this.p));
                this.p = ++n;
                if (n >= this.src.length || this.src[n++] != '\'') break;
            }
            return new Str(string2);
        }

        String getTypename(Node node) {
            if (!(node instanceof Sym)) {
                throw new CompileException(node, "Expected typename, not a " + node);
            }
            String string2 = ((Sym)node).sym;
            if (!Character.isLowerCase(string2.charAt(0)) && string2.charAt(0) != '_') {
                throw new CompileException(node, "Typename must start with lowercase character");
            }
            return string2;
        }

        TypeDef readTypeDef() {
            TypeDef typeDef = new TypeDef();
            typeDef.doc = this.yetiDocStr;
            this.yetiDocStr = null;
            typeDef.name = this.getTypename(this.fetch());
            ArrayList<String> arrayList = new ArrayList<String>();
            Node node = this.fetch();
            if (typeDef.name == "opaque") {
                typeDef.kind = 2;
            } else if (node instanceof Sym) {
                if (typeDef.name == "shared") {
                    typeDef.kind = 1;
                } else if (typeDef.name == "unshare") {
                    typeDef.kind = 3;
                }
            }
            if (typeDef.kind != 0) {
                typeDef.name = this.getTypename(node);
                if (typeDef.kind == 3) {
                    typeDef.param = new String[0];
                    typeDef.type = new TypeNode(typeDef.name, new TypeNode[0]);
                    typeDef.type.pos(node.line, node.col);
                    return typeDef;
                }
                node = this.fetch();
            }
            if (node instanceof BinOp && ((BinOp)node).op == "<" && typeDef.kind != 1) {
                do {
                    arrayList.add(this.getTypename(this.fetch()));
                    node = this.fetch();
                } while (node.kind == ",");
                if (!(node instanceof BinOp) || ((BinOp)node).op != ">") {
                    throw new CompileException(node, "Expected '>', not a " + node);
                }
                node = this.fetch();
            }
            if (node.kind != "=") {
                throw new CompileException(node, "Expected '=', not a " + node);
            }
            typeDef.param = arrayList.toArray(new String[arrayList.size()]);
            typeDef.type = this.readType(0);
            if (typeDef.type == null) {
                throw new CompileException(node, "Missing type in typedef declaration");
            }
            return typeDef;
        }

        TypeNode readType(int n) {
            Node node;
            TypeNode typeNode;
            this.yetiDocStr = null;
            int n2 = this.skipSpace();
            if (this.p >= this.src.length || this.src[n2] == ')' || this.src[n2] == '>') {
                this.p = n2;
                return null;
            }
            int n3 = this.line;
            int n4 = n2 - this.lineStart;
            if (this.src[n2] == '(') {
                this.p = n2 + 1;
                typeNode = this.readType(0);
                if (this.p >= this.src.length || this.src[this.p] != ')') {
                    if (typeNode == null) {
                        throw new CompileException(n3, n4, "Unclosed (");
                    }
                    throw new CompileException(this.line, this.p - this.lineStart, "Expecting ) here");
                }
                ++this.p;
                if (typeNode == null) {
                    typeNode = new TypeNode("()", null);
                    typeNode.pos(n3, n4);
                }
            } else if (this.src[n2] == '{') {
                String string2;
                ArrayList<TypeNode> arrayList;
                Node node2;
                block39: {
                    this.p = n2 + 1;
                    node2 = null;
                    arrayList = new ArrayList<TypeNode>();
                    string2 = "Expecting field name or '}' here, not ";
                    do {
                        String string3;
                        boolean bl;
                        this.yetiDocStr = null;
                        node2 = this.fetch();
                        boolean bl2 = bl = node2.kind == "var";
                        if (bl) {
                            node2 = this.fetch();
                        }
                        if (node2 instanceof BinOp && ((BinOp)node2).op == FIELD_OP && (node2 = this.fetch()) instanceof Sym) {
                            string3 = ".".concat(node2.sym()).intern();
                        } else {
                            if (!(node2 instanceof Sym)) {
                                if (bl) {
                                    throw new CompileException(node2, "Exepcting field name after var");
                                }
                                break block39;
                            }
                            string3 = node2.sym();
                        }
                        TypeNode typeNode2 = new TypeNode(string3, new TypeNode[1]);
                        typeNode2.var = bl;
                        typeNode2.doc = this.yetiDocStr;
                        node = this.fetch();
                        if (!(node instanceof IsOp) || ((BinOp)node).right != null) {
                            throw new CompileException(node, "Expecting 'is' after field name");
                        }
                        typeNode2.param[0] = ((IsOp)node).type;
                        arrayList.add(typeNode2);
                        node2 = this.fetch();
                    } while (node2.kind == ",");
                    string2 = "Expecting ',' or '}' here, not ";
                }
                if (node2.kind != "}") {
                    throw new CompileException(node2, string2 + node2);
                }
                ++this.p;
                typeNode = new TypeNode("", arrayList.toArray(new TypeNode[arrayList.size()]));
                typeNode.pos(n3, n4);
            } else {
                boolean bl;
                int n5 = n2;
                int n6 = 32;
                int n7 = 46;
                if (n2 < this.src.length && ((n6 = this.src[n2]) == 126 || n6 == 94)) {
                    ++n2;
                }
                boolean bl3 = bl = n6 == 126 || n6 == 39;
                if (n6 != 46) {
                    if (Character.isUpperCase((char)n6)) {
                        n7 = 95;
                    }
                    while (n2 < this.src.length && ((n6 = this.src[n2]) > 126 || CHS[n6] == 'x' || n6 == n7 || n6 == 36)) {
                        ++n2;
                    }
                    while (this.src[n2 - 1] == '.') {
                        --n2;
                    }
                }
                if (bl) {
                    n6 = 32;
                    while (n2 + 1 < this.src.length && this.src[n2] == '[' && this.src[n2 + 1] == ']') {
                        n2 += 2;
                    }
                }
                if (n2 == n5) {
                    throw new CompileException(n3, n4, "Expected type identifier, not '" + this.src[n2] + "' in the type expression");
                }
                this.p = n2;
                String string4 = new String(this.src, n5, n2 - n5).intern();
                ArrayList<TypeNode> arrayList = new ArrayList<TypeNode>();
                if (n7 == 95) {
                    String string5 = this.yetiDocStr;
                    if (n2 < this.src.length && this.src[n2] == '.') {
                        ++this.p;
                    } else {
                        string4 = ".".concat(string4);
                    }
                    TypeNode typeNode3 = this.readType(3);
                    if (typeNode3 == null) {
                        throw new CompileException(this.line, this.p - this.lineStart, "Expecting variant argument");
                    }
                    typeNode3 = new TypeNode(string4, new TypeNode[]{typeNode3});
                    typeNode3.doc = string5;
                    typeNode3.pos(n3, n4);
                    if (n == 2) {
                        return typeNode3;
                    }
                    arrayList.add(typeNode3);
                    if (n != 3) {
                        while ((this.p = this.skipSpace() + 1) < this.src.length && this.src[this.p - 1] == '|' && (typeNode3 = this.readType(2)) != null) {
                            arrayList.add(typeNode3);
                        }
                        --this.p;
                    }
                    typeNode = (TypeNode)new TypeNode("|", arrayList.toArray(new TypeNode[arrayList.size()])).pos(n3, n4);
                } else {
                    if (n6 == 33) {
                        ++this.p;
                    }
                    if ((this.p = this.skipSpace()) < this.src.length && this.src[this.p] == '<') {
                        TypeNode typeNode4;
                        ++this.p;
                        while ((typeNode4 = this.readType(0)) != null) {
                            arrayList.add(typeNode4);
                            this.p = this.skipSpace();
                            if (this.p >= this.src.length || this.src[this.p] != ',') break;
                            ++this.p;
                        }
                        if (this.p >= this.src.length || this.src[this.p] != '>') {
                            throw new CompileException(this.line, this.p - this.lineStart, "Expecting > here");
                        }
                        ++this.p;
                    }
                    typeNode = new TypeNode(string4, arrayList.toArray(new TypeNode[arrayList.size()]));
                    typeNode.exact = n6 == 33;
                    typeNode.pos(n3, n4);
                }
            }
            if (n == 2) {
                throw new CompileException((Node)typeNode, "Invalid `| " + typeNode.str() + "' in variant type (expecting Tag after `|')");
            }
            this.p = n2 = this.skipSpace();
            if (n == 3 || n2 + 1 >= this.src.length || this.src[n2] != '\u2192' && (this.src[n2] != '-' || this.src[++n2] != '>')) {
                return typeNode;
            }
            n3 = this.line;
            n4 = this.p - this.lineStart;
            this.p = n2 + 1;
            node = this.readType(1);
            if (node == null) {
                throw new CompileException(n3, n4, "Expecting return type after ->");
            }
            return (TypeNode)new TypeNode("->", new TypeNode[]{typeNode, node}).pos(n3, n4);
        }

        Node parse(Object object) {
            int n;
            Node node;
            int n2;
            if (this.src.length > 2 && this.src[0] == '#' && this.src[1] == '!') {
                this.p = 2;
                while (this.p < this.src.length && this.src[this.p] != '\n') {
                    ++this.p;
                }
            }
            this.topDoc = this.yetiDocStr;
            for (n2 = this.p = this.skipSpace(); n2 < this.src.length && this.src[n2] < '~' && CHS[this.src[n2]] == 'x'; ++n2) {
            }
            String string2 = new String(this.src, this.p, n2 - this.p);
            if (string2.equals("module") || string2.equals("program")) {
                this.p = n2;
                Sym sym = this.readDotted("Expected " + string2 + " name, not a ");
                this.moduleName = sym.sym;
                this.moduleNameLine = sym.line;
                this.isModule = string2.equals("module");
                if (this.isModule && this.p < this.src.length && this.src[this.p] == ':') {
                    ++this.p;
                    node = this.fetch();
                    if (node.sym() != "deprecated") {
                        throw new CompileException(node, "Unknown module attribute: " + node);
                    }
                    this.deprecated = true;
                    this.p = this.skipSpace();
                }
                if (this.p >= this.src.length || this.src[this.p++] != ';') {
                    throw new CompileException(this.line, this.p - this.lineStart, "Expected ';' here");
                }
            }
            int n3 = n = this.p < this.src.length ? this.src[this.p] : 32;
            if ((this.flags & 0x20) != 0) {
                node = this.readSeq(' ', Seq.EVAL);
                if (node instanceof Seq) {
                    Seq seq = (Seq)node;
                    Node node2 = seq.st[seq.st.length - 1];
                    if (node2 instanceof Bind || node2.kind == "struct-bind" || node2.kind == "import" || node2 instanceof TypeDef) {
                        Node[] nodeArray = new Node[seq.st.length + 1];
                        System.arraycopy(seq.st, 0, nodeArray, 0, seq.st.length);
                        nodeArray[nodeArray.length - 1] = new XNode("()").pos(seq.line, seq.col);
                        seq.st = nodeArray;
                    } else if (seq.st.length == 1) {
                        node = seq.st[0];
                    }
                }
            } else {
                node = this.readSeq(' ', object);
                if (node.kind == "class") {
                    node = new Seq(new Node[]{node}, object).pos(node.line, node.col);
                }
            }
            if (this.eofWas != EOF) {
                throw new CompileException(this.eofWas, "Unexpected " + this.eofWas);
            }
            return node;
        }
    }

    public static final class ParseExpr {
        private boolean lastOp = true;
        private BinOp root;
        private BinOp cur = this.root = new BinOp(null, -1, false);

        private void apply(Node node) {
            BinOp binOp = new BinOp("", 2, true);
            binOp.line = node.line;
            binOp.col = node.col;
            this.addOp(binOp);
        }

        private void addOp(BinOp binOp) {
            BinOp binOp2 = this.cur;
            if (binOp.op == "-" && this.lastOp || binOp.op == "\\" || binOp.op == "not") {
                if (!this.lastOp) {
                    this.apply(binOp);
                    binOp2 = this.cur;
                }
                if (binOp.op == "-") {
                    binOp.prio = 1;
                }
                binOp2.left = binOp2.right;
            } else {
                if (this.lastOp) {
                    throw new CompileException((Node)binOp, "Do not stack operators");
                }
                while (binOp2.parent != null && (binOp2.postfix || binOp2.prio < binOp.prio || binOp2.prio == binOp.prio && binOp.toRight)) {
                    binOp2 = binOp2.parent;
                }
                binOp.right = binOp2.right;
            }
            binOp.parent = binOp2;
            binOp2.right = binOp;
            this.cur = binOp;
            this.lastOp = !binOp.postfix;
        }

        void add(Node node) {
            if (node instanceof BinOp && ((BinOp)node).parent == null && (!this.lastOp || node.kind != "listop")) {
                this.addOp((BinOp)node);
            } else {
                if (!this.lastOp) {
                    this.apply(node);
                }
                this.lastOp = false;
                this.cur.left = this.cur.right;
                this.cur.right = node;
            }
        }

        Node result() {
            if (this.cur.left == null && this.cur.prio != -1 && this.cur.prio != 1 && this.cur.prio != Parser.NOT_OP_LEVEL && !this.cur.postfix || this.cur.right == null) {
                throw new CompileException((Node)this.cur, "Expecting some value" + this.cur);
            }
            return this.root.right;
        }
    }

    public static class TypeNode
    extends Node {
        String name;
        TypeNode[] param;
        boolean var;
        boolean exact;
        String doc;

        TypeNode(String string2, TypeNode[] typeNodeArray) {
            this.name = string2;
            this.param = typeNodeArray;
        }

        String str() {
            if (this.name == "->") {
                return "(" + this.param[0].str() + " -> " + this.param[1].str() + ")";
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.name == "|") {
                for (int i = 0; i < this.param.length; ++i) {
                    stringBuffer.append(" | ").append(this.param[i].str());
                }
                return stringBuffer.toString();
            }
            if (this.name == "") {
                stringBuffer.append('{');
                for (int i = 0; i < this.param.length; ++i) {
                    if (i != 0) {
                        stringBuffer.append("; ");
                    }
                    stringBuffer.append(this.param[i].name);
                    stringBuffer.append(" is ");
                    stringBuffer.append(this.param[i].param[0].str());
                }
                stringBuffer.append('}');
                return stringBuffer.toString();
            }
            if (this.param == null || this.param.length == 0) {
                return this.name;
            }
            if (Character.isUpperCase(this.name.charAt(0))) {
                return "(" + this.name + " " + this.param[0].str() + ")";
            }
            stringBuffer.append(this.name);
            stringBuffer.append('<');
            for (int i = 0; i < this.param.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.param[i].str());
            }
            stringBuffer.append('>');
            return stringBuffer.toString();
        }
    }

    public static final class InstanceOf
    extends BinOp {
        String className;

        InstanceOf(String string2) {
            super("instanceof", Parser.COMP_OP_LEVEL, true);
            this.postfix = true;
            this.className = string2;
        }
    }

    public static final class ObjectRefOp
    extends BinOp {
        String name;
        Node[] arguments;

        ObjectRefOp(String string2, Node[] nodeArray) {
            super("#", 0, true);
            this.postfix = true;
            this.name = string2;
            this.arguments = nodeArray;
        }

        String str() {
            StringBuffer stringBuffer = new StringBuffer(this.right == null ? "<>" : this.right.str());
            stringBuffer.append('#').append(this.name);
            if (this.arguments != null) {
                stringBuffer.append('(');
                for (int i = 0; i < this.arguments.length; ++i) {
                    if (i != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.arguments[i].str());
                }
                stringBuffer.append(')');
            }
            return stringBuffer.toString();
        }
    }

    public static final class IsOp
    extends TypeOp {
        IsOp(TypeNode typeNode) {
            super("is", typeNode);
        }
    }

    public static class TypeOp
    extends BinOp {
        TypeNode type;

        TypeOp(String string2, TypeNode typeNode) {
            super(string2, Parser.IS_OP_LEVEL, true);
            this.postfix = true;
            this.type = typeNode;
        }

        String str() {
            return "(`" + this.op + ' ' + (this.right == null ? "()" : this.right.str()) + ' ' + this.type.str() + ')';
        }
    }

    public static final class TypeDef
    extends Node {
        static final int SHARED = 1;
        static final int OPAQUE = 2;
        static final int UNSHARE = 3;
        String name;
        String[] param;
        String doc;
        TypeNode type;
        int kind;

        String str() {
            StringBuffer stringBuffer = new StringBuffer("(`typedef ").append(this.name).append(" (");
            for (int i = 0; i < this.param.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.param[i]);
            }
            return stringBuffer.append(") ").append(this.type.str()).append(')').toString();
        }
    }

    public static class BinOp
    extends Node {
        int prio;
        String op;
        boolean toRight;
        boolean postfix;
        Node left;
        Node right;
        BinOp parent;

        BinOp(String string2, int n, boolean bl) {
            this.op = string2;
            this.prio = n;
            this.toRight = bl;
        }

        String str() {
            StringBuffer stringBuffer = new StringBuffer().append('(');
            if (this.left == null) {
                stringBuffer.append("`flip ");
            }
            if (this.op != "") {
                stringBuffer.append(this.op == FIELD_OP ? "`." : this.op).append(' ');
            }
            if (this.left != null) {
                stringBuffer.append(this.left.str()).append(' ');
            }
            if (this.right != null) {
                stringBuffer.append(this.right.str());
            }
            return stringBuffer.append(')').toString();
        }
    }

    public static final class Eof
    extends XNode {
        Eof(String string2) {
            super(string2);
        }

        public String toString() {
            return this.kind;
        }
    }

    public static final class NumLit
    extends Node {
        Num num;

        NumLit(Num num) {
            this.num = num;
        }

        String str() {
            return String.valueOf(this.num);
        }
    }

    public static final class Str
    extends Node {
        String str;

        Str(String string2) {
            this.str = string2;
        }

        String str() {
            return Core.show(this.str);
        }
    }

    public static final class Sym
    extends Node {
        String sym;

        Sym(String string2) {
            this.sym = string2;
        }

        String sym() {
            return this.sym;
        }

        String str() {
            return this.sym;
        }

        public String toString() {
            return this.sym;
        }
    }

    public static final class Seq
    extends Node {
        static final Object EVAL = new Object();
        Node[] st;
        Object seqKind;

        Seq(Node[] nodeArray, Object object) {
            this.st = nodeArray;
            this.seqKind = object;
        }

        String str() {
            StringBuffer stringBuffer = new StringBuffer("(`begin");
            if (this.seqKind != null) {
                stringBuffer.append(':').append(this.seqKind);
            }
            for (int i = 0; this.st != null && i < this.st.length; ++i) {
                stringBuffer.append(' ').append(this.st[i].str());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class Bind
    extends Node {
        String name;
        Node expr;
        TypeNode type;
        boolean var;
        boolean property;
        boolean noRec;
        String doc;

        Bind() {
        }

        Bind(List list2, Node node, boolean bl, String string2) {
            String string3;
            int n;
            this.doc = string2;
            Node node2 = null;
            for (n = 0; n < list2.size(); ++n) {
                node2 = (Node)list2.get(n);
                if (node2.kind == "var") {
                    this.var = true;
                    continue;
                }
                if (node2.kind != "norec") break;
                this.noRec = true;
            }
            if (!this.var && node2 instanceof Sym) {
                string3 = ((Sym)node2).sym;
                if (bl && list2.size() > n) {
                    if (string3 == "get") {
                        this.property = true;
                        node2 = (Node)list2.get(n++);
                    } else if (string3 == "set") {
                        this.property = true;
                        this.var = true;
                        node2 = (Node)list2.get(n++);
                    }
                }
            }
            if (n == 0 || n > list2.size()) {
                throw new CompileException(node2, "Variable name is missing");
            }
            if (bl && node2.kind == "``") {
                node2 = ((XNode)node2).expr[0];
            }
            if (!(node2 instanceof Sym)) {
                throw new CompileException(node2, node2.kind == "class" ? "Missing ; after class definition" : "Illegal binding name: " + node2 + " (missing ; after expression?)");
            }
            this.line = node2.line;
            this.col = node2.col;
            this.name = ((Sym)node2).sym;
            if (n < list2.size() && list2.get(n) instanceof BinOp && ((string3 = ((BinOp)list2.get((int)n)).op) == FIELD_OP || string3 == "#")) {
                throw new CompileException((Node)((BinOp)list2.get(n)), "Bad argument on binding (use := for assignment, not =)");
            }
            int n2 = list2.size() - 1;
            if (n2 >= n && list2.get(n2) instanceof IsOp) {
                this.type = ((IsOp)list2.get((int)n2)).type;
                --n2;
            }
            while (n2 >= n) {
                node = XNode.lambda((Node)list2.get(n2), node, n2 == n ? node2 : null);
                --n2;
            }
            this.expr = node;
        }

        String str() {
            StringBuffer stringBuffer = new StringBuffer("(`let ");
            if (this.doc != null) {
                stringBuffer.append("/**");
                stringBuffer.append(this.doc);
                stringBuffer.append(" */ ");
            }
            if (this.noRec) {
                stringBuffer.append("`norec ");
            }
            if (this.property) {
                stringBuffer.append(this.var ? "`set " : "`get ");
            } else if (this.var) {
                stringBuffer.append("`var ");
            }
            stringBuffer.append(this.name);
            stringBuffer.append(' ');
            stringBuffer.append(this.expr.str());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static class XNode
    extends Node {
        Node[] expr;
        String doc;

        XNode(String string2) {
            this.kind = string2;
        }

        XNode(String string2, Node[] nodeArray) {
            this.kind = string2;
            this.expr = nodeArray;
        }

        XNode(String string2, Node node) {
            this.kind = string2;
            this.expr = new Node[]{node};
            this.line = node.line;
            this.col = node.col;
        }

        String str() {
            if (this.expr == null) {
                return "`".concat(this.kind);
            }
            StringBuffer stringBuffer = new StringBuffer("(`");
            stringBuffer.append(this.kind);
            for (int i = 0; i < this.expr.length; ++i) {
                stringBuffer.append(' ');
                if (this.expr[i] == null) continue;
                stringBuffer.append(this.expr[i].str());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        static XNode struct(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                IsOp isOp = null;
                Sym sym = null;
                if (nodeArray[i] instanceof Sym) {
                    sym = (Sym)nodeArray[i];
                } else if (nodeArray[i] instanceof IsOp) {
                    isOp = (IsOp)nodeArray[i];
                    isOp.right.sym();
                    sym = (Sym)isOp.right;
                }
                if (sym == null) continue;
                Bind bind = new Bind();
                bind.name = sym.sym;
                bind.expr = sym;
                bind.col = sym.col;
                bind.line = sym.line;
                bind.noRec = true;
                if (isOp != null) {
                    bind.type = isOp.type;
                }
                nodeArray[i] = bind;
            }
            return new XNode("struct", nodeArray);
        }

        static XNode lambda(Node node, Node node2, Node node3) {
            Node[] nodeArray;
            if (node3 == null) {
                Node[] nodeArray2 = new Node[2];
                nodeArray2[0] = node;
                nodeArray = nodeArray2;
                nodeArray2[1] = node2;
            } else {
                Node[] nodeArray3 = new Node[3];
                nodeArray3[0] = node;
                nodeArray3[1] = node2;
                nodeArray = nodeArray3;
                nodeArray3[2] = node3;
            }
            XNode xNode = new XNode("lambda", nodeArray);
            xNode.line = node.line;
            xNode.col = node.col;
            return xNode;
        }
    }

    public static class Node {
        int line;
        int col;
        String kind;

        String str() {
            return this.toString();
        }

        Node pos(int n, int n2) {
            this.line = n;
            this.col = n2;
            return this;
        }

        public String toString() {
            char c2;
            char[] cArray = (char[])currentSrc.get();
            if (cArray == null) {
                return this.getClass().getName();
            }
            int n = 0;
            int n2 = this.line;
            if (--n2 > 0) {
                while (n < cArray.length && (cArray[n++] != '\n' || --n2 > 0)) {
                }
            }
            if ((n += this.col - 1) < 0) {
                n = 0;
            }
            int n3 = n;
            while (++n3 < cArray.length && (c2 = cArray[n3]) > ' ' && c2 != ':' && c2 != ';' && c2 != '.' && c2 != ',' && c2 != '(' && c2 != ')' && c2 != '[' && c2 != ']' && c2 != '{' && c2 != '}') {
            }
            return '`' + new String(cArray, n, Math.min(n3, cArray.length) - n) + '\'';
        }

        String sym() {
            throw new CompileException(this, "Expected symbol here, not " + this);
        }
    }
}

