/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.AbstractSession;
import com.bloomberglp.blpapi.AuthOptions;
import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Identity;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.SubscriptionList;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ExampleState;
import com.bloomberglp.blpapiexamples.demoapps.util.SubscriptionOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import com.bloomberglp.blpapiexamples.demoapps.util.events.SessionRouter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class EntitlementsVerificationSubscriptionExample {
    private static final Name EID = Name.getName("EID");
    private static final Name ENTITLEMENT_CHANGED = Name.getName("EntitlementChanged");
    private final SessionRouter<Session> router = new SessionRouter();
    private final Map<CorrelationID, Identity> identitiesByCorrelationId = new HashMap<CorrelationID, Identity>();
    private final AtomicReference<ExampleState> exampleState = new AtomicReference<ExampleState>(ExampleState.STARTING);
    private Session session;
    private SubscriptionOptions subscriptionOptions;
    private ConnectionAndAuthOptions connectionAndAuthOptions;

    public EntitlementsVerificationSubscriptionExample() {
        this.router.addExceptionHandler(this::handleException);
        this.router.addMessageHandler(Names.SESSION_STARTED, this::handleSessionStarted);
        this.router.addMessageHandler(Names.SESSION_STARTUP_FAILURE, this::handleSessionStartupFailure);
        this.router.addMessageHandler(Names.SESSION_TERMINATED, this::handleSessionTerminated);
        this.router.addMessageHandler(Names.SERVICE_OPENED, this::handleServiceOpened);
        this.router.addMessageHandler(Names.SERVICE_OPEN_FAILURE, this::handleServiceOpenFailure);
        this.router.addMessageHandler(ENTITLEMENT_CHANGED, this::handleEntitlementChanged);
    }

    public static void main(String[] args) throws Exception {
        EntitlementsVerificationSubscriptionExample example = new EntitlementsVerificationSubscriptionExample();
        if (!example.parseCommandLine(args)) {
            return;
        }
        example.run();
        while (example.exampleState.get() != ExampleState.TERMINATED) {
            Thread.sleep(100L);
        }
    }

    private void run() throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        this.createAndStartSession();
    }

    private void stop() {
        this.session.cancel(new ArrayList<CorrelationID>(this.identitiesByCorrelationId.keySet()));
        try {
            this.session.stop(AbstractSession.StopOption.ASYNC);
        }
        catch (InterruptedException ex2) {
            ex2.printStackTrace();
        }
    }

    private void handleException(Session sess, Event event, Exception exception) {
        exception.printStackTrace();
        this.stop();
    }

    private void createAndStartSession() throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption();
        this.subscriptionOptions.setSessionOptions(sessionOptions);
        this.session = new Session(sessionOptions, this.router::processEvent);
        this.session.startAsync();
    }

    private void handleSessionStarted(Session sess, Event event, Message message) throws IOException {
        this.exampleState.set(ExampleState.STARTED);
        this.router.addMessageHandler(Names.AUTHORIZATION_SUCCESS, this::handleAuthorizationSuccess);
        this.router.addMessageHandler(Names.AUTHORIZATION_FAILURE, this::handleAuthorizationFailure);
        this.router.addMessageHandler(Names.AUTHORIZATION_REVOKED, this::handleAuthorizationRevoked);
        this.authorizeUsers();
        this.openServices();
    }

    private void handleSessionStartupFailure(Session sess, Event event, Message message) {
        System.out.println("Failed to start session. Exiting...");
        this.exampleState.set(ExampleState.TERMINATED);
    }

    private void handleSessionTerminated(Session sess, Event event, Message message) {
        this.exampleState.set(ExampleState.TERMINATED);
    }

    private void openServices() throws IOException {
        this.session.openServiceAsync(this.subscriptionOptions.service);
    }

    private void handleServiceOpened(Session sess, Event event, Message message) throws IOException {
        String serviceName = message.getElementAsString("serviceName");
        if (serviceName.equals(this.subscriptionOptions.service)) {
            this.subscribe();
        } else {
            System.out.println("A service was opened: " + serviceName);
        }
    }

    private void handleServiceOpenFailure(Session sess, Event event, Message message) {
        String serviceName = message.getElementAsString("serviceName");
        if (!serviceName.equals(this.subscriptionOptions.service)) {
            throw new RuntimeException("A service which is unknown failed to open: " + serviceName);
        }
        System.out.println("Failed to open service '" + serviceName + "', stopping application...");
        this.stop();
    }

    private void authorizeUsers() {
        Map<String, AuthOptions> authOptionsByIdentifier = this.connectionAndAuthOptions.createClientServerSetupAuthOptions();
        for (Map.Entry<String, AuthOptions> entry : authOptionsByIdentifier.entrySet()) {
            String userIdentifier = entry.getKey();
            AuthOptions authOptions = entry.getValue();
            CorrelationID correlationId = new CorrelationID(userIdentifier);
            this.session.generateAuthorizedIdentity(authOptions, correlationId);
        }
    }

    private void subscribe() throws IOException {
        this.router.addMessageHandler(Names.SUBSCRIPTION_FAILURE, this::handleSubscriptionFailure);
        this.router.addMessageHandler(Names.SUBSCRIPTION_TERMINATED, this::handleSubscriptionTerminated);
        this.router.addMessageHandler(Event.EventType.SUBSCRIPTION_DATA, this::handleSubscriptionData);
        SubscriptionList subscriptions = this.subscriptionOptions.createSubscriptionList((index, topic) -> new CorrelationID(topic));
        System.out.println("Subscribing...");
        this.session.subscribe(subscriptions);
    }

    private void handleSubscriptionFailure(Session sess, Event event, Message message) {
        String topic = (String)message.correlationID().object();
        System.out.println("Subscription failed: " + topic);
    }

    private void handleSubscriptionTerminated(Session sess, Event event, Message message) {
        String topic = (String)message.correlationID().object();
        System.out.println("Subscription terminated: " + topic);
    }

    private void handleSubscriptionData(Session sess, Event event, Message message) {
        String topic = (String)message.correlationID().object();
        ArrayList<Integer> failedEntitlements = new ArrayList<Integer>();
        Service service = message.service();
        if (message.hasElement(EID, true)) {
            Element entitlements = message.getElement(EID);
            for (Map.Entry<CorrelationID, Identity> entry : this.identitiesByCorrelationId.entrySet()) {
                String userIdentifier = (String)entry.getKey().object();
                Identity identity = entry.getValue();
                if (identity.hasEntitlements(entitlements, service, failedEntitlements)) {
                    System.out.println(userIdentifier + " is entitled to get data for: " + topic);
                } else {
                    System.out.println(userIdentifier + " is NOT entitled to get data for: " + topic + " - Failed eids: " + failedEntitlements);
                }
                failedEntitlements.clear();
            }
        } else {
            System.out.println("No entitlements are required for: " + topic);
        }
        System.out.println();
    }

    private void handleAuthorizationSuccess(Session sess, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        String userIdentifier = (String)correlationId.object();
        System.out.println("Successfully authorized " + userIdentifier);
        Identity identity = this.session.getAuthorizedIdentity(correlationId);
        this.identitiesByCorrelationId.put(correlationId, identity);
    }

    private void handleAuthorizationFailure(Session sess, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        this.router.removeMessageHandler(correlationId);
        String userIdentifier = (String)correlationId.object();
        System.out.println("Failed to authorize " + userIdentifier);
    }

    private void handleAuthorizationRevoked(Session sess, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        this.router.removeMessageHandler(correlationId);
        String userIdentifier = (String)correlationId.object();
        System.out.println("Authorization revoked for " + userIdentifier);
        this.identitiesByCorrelationId.remove(correlationId);
    }

    private void handleEntitlementChanged(Session sess, Event event, Message message) {
        String userIdentifier = (String)message.correlationID().object();
        System.out.println("Entitlements updated for " + userIdentifier);
    }

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Entitlements Verification Subscription Example", EntitlementsVerificationSubscriptionExample.class);
        try {
            this.connectionAndAuthOptions = ConnectionAndAuthOptions.forClientServerSetup(argParser);
            this.subscriptionOptions = new SubscriptionOptions(argParser);
            argParser.parse(args);
            if (this.connectionAndAuthOptions.numClientServerSetupAuthOptions() == 0) {
                throw new IllegalArgumentException("No userId:IP or token specified.");
            }
            if (!this.subscriptionOptions.fields.contains(EID.toString())) {
                this.subscriptionOptions.fields.add(EID.toString());
            }
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        return true;
    }
}

