/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.DuplicateCorrelationIDException;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventHandler;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.RequestTemplate;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.SubscriptionOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;

public class SnapshotRequestTemplateExample {
    private static final int BATCH_SIZE = 50;
    private ConnectionAndAuthOptions connectionAndAuthOptions;
    private SubscriptionOptions subscriptionOptions;
    private final Semaphore templateSemaphore = new Semaphore(50);
    private final Map<CorrelationID, RequestTemplate> snapshots = new HashMap<CorrelationID, RequestTemplate>();
    private CountDownLatch requestCountDown;
    private final Object lock = new Object();
    private boolean isRunning = true;

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Snapshot Request Example", SnapshotRequestTemplateExample.class);
        try {
            this.connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
            this.subscriptionOptions = SubscriptionOptions.forSnapshot(argParser);
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void run(String[] args) throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        Session session;
        block14: {
            block13: {
                block12: {
                    if (!this.parseCommandLine(args)) {
                        return;
                    }
                    SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption();
                    this.subscriptionOptions.setSessionOptions(sessionOptions);
                    session = new Session(sessionOptions, new MyEventHandler());
                    if (session.start()) break block12;
                    System.err.println("Failed to start session.");
                    session.stop();
                    return;
                }
                if (session.openService(this.subscriptionOptions.service)) break block13;
                System.err.println("Failed to open service '" + this.subscriptionOptions.service + "'.");
                session.stop();
                return;
            }
            this.createTemplates(session);
            Object object = this.lock;
            // MONITORENTER : object
            if (this.isRunning) break block14;
            // MONITOREXIT : object
            session.stop();
            return;
        }
        if (this.snapshots.isEmpty()) {
            System.out.println("All request templates failed to create.");
            // MONITOREXIT : object
            session.stop();
            return;
        }
        try {
            System.out.println("All the request templates are finished");
            // MONITOREXIT : object
            this.sendRequests(session);
            return;
        }
        finally {
            session.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemplates(Session session) throws DuplicateCorrelationIDException, IllegalStateException, IllegalArgumentException, IOException, InterruptedException {
        Map<String, String> subscriptionStrings = this.subscriptionOptions.createSubscriptionStrings();
        this.requestCountDown = new CountDownLatch(subscriptionStrings.size());
        for (Map.Entry<String, String> entry : subscriptionStrings.entrySet()) {
            this.templateSemaphore.acquire();
            Object object = this.lock;
            synchronized (object) {
                if (!this.isRunning) {
                    return;
                }
                String userTopic = entry.getKey();
                String subscriptionString = entry.getValue();
                System.out.println("Creating snapshot request template for " + userTopic);
                CorrelationID statusCid = new CorrelationID(new MyCorrelation(userTopic));
                RequestTemplate requestTemplate = session.createSnapshotRequestTemplate(subscriptionString, statusCid);
                this.snapshots.put(statusCid, requestTemplate);
            }
        }
        this.requestCountDown.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequests(Session session) throws IOException, InterruptedException {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isRunning) {
                    break;
                }
                System.out.println("Sending snapshot requests using the request templates");
                this.requestCountDown = new CountDownLatch(this.snapshots.size());
                for (Map.Entry<CorrelationID, RequestTemplate> entry : this.snapshots.entrySet()) {
                    MyCorrelation myCorrelation = (MyCorrelation)entry.getKey().object();
                    session.sendRequest(entry.getValue(), new CorrelationID(new MyCorrelation(myCorrelation.topic)));
                }
            }
            this.requestCountDown.await();
            System.out.println("Received all the responses..., Press [Ctrl-C] to exit");
            Thread.sleep(5000L);
        }
    }

    public static void main(String[] args) {
        SnapshotRequestTemplateExample example = new SnapshotRequestTemplateExample();
        try {
            example.run(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private class MyEventHandler
    implements EventHandler {
        private MyEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processEvent(Event event, Session session) {
            for (Message msg : event) {
                MyCorrelation myCorrelation;
                Name messageType = msg.messageType();
                CorrelationID correlationId = msg.correlationID();
                if (messageType.equals(Names.REQUEST_TEMPLATE_AVAILABLE)) {
                    myCorrelation = (MyCorrelation)correlationId.object();
                    System.out.println("Request template is successfully created for " + myCorrelation);
                    System.out.println(msg);
                    SnapshotRequestTemplateExample.this.templateSemaphore.release();
                    SnapshotRequestTemplateExample.this.requestCountDown.countDown();
                    continue;
                }
                if (event.eventType() == Event.EventType.PARTIAL_RESPONSE) {
                    myCorrelation = (MyCorrelation)correlationId.object();
                    System.out.println("Received partial response for " + myCorrelation);
                    System.out.println(msg);
                    continue;
                }
                if (event.eventType() == Event.EventType.RESPONSE) {
                    myCorrelation = (MyCorrelation)correlationId.object();
                    System.out.println("Received response for " + myCorrelation);
                    System.out.println(msg);
                    SnapshotRequestTemplateExample.this.requestCountDown.countDown();
                    continue;
                }
                if (messageType.equals(Names.REQUEST_TEMPLATE_TERMINATED)) {
                    myCorrelation = (MyCorrelation)correlationId.object();
                    System.out.println("Request template terminated for " + myCorrelation);
                    System.out.println(msg);
                    Object object = SnapshotRequestTemplateExample.this.lock;
                    synchronized (object) {
                        SnapshotRequestTemplateExample.this.snapshots.remove(correlationId);
                    }
                    SnapshotRequestTemplateExample.this.templateSemaphore.release();
                    SnapshotRequestTemplateExample.this.requestCountDown.countDown();
                    continue;
                }
                if (!messageType.equals(Names.SESSION_TERMINATED)) continue;
                Object object = SnapshotRequestTemplateExample.this.lock;
                synchronized (object) {
                    SnapshotRequestTemplateExample.this.isRunning = false;
                }
                SnapshotRequestTemplateExample.this.templateSemaphore.release();
                while (SnapshotRequestTemplateExample.this.requestCountDown.getCount() > 0L) {
                    SnapshotRequestTemplateExample.this.requestCountDown.countDown();
                }
                break block6;
            }
        }
    }

    private static class MyCorrelation {
        public String topic;

        public MyCorrelation(String topic) {
            this.topic = topic;
        }

        public String toString() {
            return this.topic;
        }
    }
}

