/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.AbstractSession;
import com.bloomberglp.blpapi.AuthOptions;
import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Identity;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ExampleState;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import com.bloomberglp.blpapiexamples.demoapps.util.events.SessionRouter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class UserModeExample {
    private static final String REF_DATA_SVC_NAME = "//blp/refdata";
    private final List<String> securities = new ArrayList<String>();
    private final SessionRouter<Session> router = new SessionRouter();
    private final AtomicReference<ExampleState> exampleState = new AtomicReference<ExampleState>(ExampleState.STARTING);
    private final Map<CorrelationID, Identity> identitiesByCorrelationId = new HashMap<CorrelationID, Identity>();
    private Service blpRefDataSvc;
    private Session session;
    private ConnectionAndAuthOptions connectionAndAuthOptions;

    public UserModeExample() {
        this.router.addExceptionHandler(this::handleException);
        this.router.addMessageHandler(Names.SESSION_STARTED, this::handleSessionStarted);
        this.router.addMessageHandler(Names.SESSION_STARTUP_FAILURE, this::handleSessionStartupFailure);
        this.router.addMessageHandler(Names.SESSION_TERMINATED, this::handleSessionTerminated);
        this.router.addMessageHandler(Names.SERVICE_OPENED, this::handleServiceOpened);
        this.router.addMessageHandler(Names.SERVICE_OPEN_FAILURE, this::handleServiceOpenFailure);
    }

    public static void main(String[] args) throws Exception {
        UserModeExample example = new UserModeExample();
        if (!example.parseCommandLine(args)) {
            return;
        }
        example.run();
        while (example.exampleState.get() != ExampleState.TERMINATED) {
            Thread.sleep(100L);
        }
    }

    private void run() throws InterruptedException, TlsOptions.TlsInitializationException, IOException {
        this.createAndStartSession();
    }

    private void createAndStartSession() throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption();
        this.session = new Session(sessionOptions, this.router::processEvent);
        this.session.startAsync();
    }

    private void stop() {
        this.session.cancel(new ArrayList<CorrelationID>(this.identitiesByCorrelationId.keySet()));
        try {
            this.session.stop(AbstractSession.StopOption.ASYNC);
        }
        catch (InterruptedException ex2) {
            ex2.printStackTrace();
        }
    }

    private void handleSessionStarted(Session session, Event event, Message message) throws IOException {
        this.router.addMessageHandler(Names.AUTHORIZATION_SUCCESS, this::handleAuthorizationSuccess);
        this.router.addMessageHandler(Names.AUTHORIZATION_FAILURE, this::handleAuthorizationFailure);
        this.router.addMessageHandler(Names.AUTHORIZATION_REVOKED, this::handleAuthorizationRevoked);
        this.authorizeUsers();
        this.openServices();
    }

    private void handleSessionStartupFailure(Session session, Event event, Message message) {
        System.out.println("Failed to start session. Exiting...");
        this.exampleState.set(ExampleState.TERMINATED);
    }

    private void handleSessionTerminated(Session session, Event event, Message message) {
        this.exampleState.set(ExampleState.TERMINATED);
    }

    private void handleServiceOpened(Session session, Event event, Message message) {
        String serviceName = message.getElementAsString("serviceName");
        Service service = session.getService(serviceName);
        if (serviceName.equals(REF_DATA_SVC_NAME)) {
            this.blpRefDataSvc = service;
            this.identitiesByCorrelationId.forEach((corId, identity) -> {
                try {
                    this.sendRefDataRequest((Identity)identity, (String)corId.object());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            });
        } else {
            System.out.println("A service was opened: " + serviceName);
        }
    }

    private void handleServiceOpenFailure(Session sess, Event event, Message message) {
        String serviceName = message.getElementAsString("serviceName");
        if (serviceName.equals(REF_DATA_SVC_NAME)) {
            this.stop();
        } else {
            System.out.println("A service which is unknown failed to open: " + serviceName);
        }
    }

    private void handleAuthorizationSuccess(Session session, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        String userIdentifier = (String)correlationId.object();
        System.out.println("Successfully authorized " + userIdentifier);
        Identity identity = session.getAuthorizedIdentity(correlationId);
        this.identitiesByCorrelationId.put(correlationId, identity);
        if (this.blpRefDataSvc != null) {
            try {
                this.sendRefDataRequest(identity, userIdentifier);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    private void handleAuthorizationFailure(Session session, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        this.router.removeMessageHandler(correlationId);
        String userIdentifier = (String)correlationId.object();
        System.out.println("Failed to authorize " + userIdentifier);
    }

    private void handleAuthorizationRevoked(Session session, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        this.router.removeMessageHandler(correlationId);
        String userIdentifier = (String)correlationId.object();
        System.out.println("Authorization revoked for " + userIdentifier);
        this.identitiesByCorrelationId.remove(correlationId);
    }

    private void handleException(Session session, Event event, Exception exception) {
        exception.printStackTrace();
        this.stop();
    }

    private void authorizeUsers() {
        Map<String, AuthOptions> authOptionsByIdentifier = this.connectionAndAuthOptions.createClientServerSetupAuthOptions();
        for (Map.Entry<String, AuthOptions> entry : authOptionsByIdentifier.entrySet()) {
            String userIdentifier = entry.getKey();
            AuthOptions authOptions = entry.getValue();
            CorrelationID correlationId = new CorrelationID(userIdentifier);
            this.session.generateAuthorizedIdentity(authOptions, correlationId);
        }
    }

    private void openServices() throws IOException {
        this.session.openServiceAsync(REF_DATA_SVC_NAME);
    }

    private void sendRefDataRequest(Identity identity, String userIdentifier) throws IOException {
        Request request = this.blpRefDataSvc.createRequest("ReferenceDataRequest");
        Element securitiesElement = request.getElement("securities");
        for (String security : this.securities) {
            securitiesElement.appendValue(security);
        }
        Element fields = request.getElement("fields");
        fields.appendValue("PX_LAST");
        fields.appendValue("DS002");
        request.set("returnEids", true);
        System.out.println("Sending RefDataRequest on behalf of " + userIdentifier + " ...");
        CorrelationID correlationId = new CorrelationID();
        this.router.addMessageHandler(correlationId, (session, event, msg) -> {
            if (msg.messageType().equals(Names.REQUEST_FAILURE)) {
                System.out.println("Request for " + userIdentifier + " failed.");
                return;
            }
            System.out.println("Received response for " + userIdentifier + ".");
        });
        this.session.sendRequest(request, identity, correlationId);
    }

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("User Mode Example", UserModeExample.class);
        try {
            this.connectionAndAuthOptions = ConnectionAndAuthOptions.forClientServerSetup(argParser);
            argParser.addArg("-S", "--security").setMetaVar("security").setDefaultValue("IBM US Equity").setDescription("security used in ReferenceDataRequest").setMode(ArgMode.MULTIPLE_VALUES).setAction(this.securities::add);
            argParser.parse(args);
            if (this.connectionAndAuthOptions.numClientServerSetupAuthOptions() == 0) {
                throw new IllegalArgumentException("No userId:IP or token specified.");
            }
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        return true;
    }
}

