/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapiexamples.demoapps.util.RequestOptions;

public class HistoricalDataRequests {
    public static Request createRequest(Service service, RequestOptions options) {
        Request request = service.createRequest("HistoricalDataRequest");
        Element securitiesElement = request.getElement("securities");
        for (String security : options.securities) {
            securitiesElement.appendValue(security);
        }
        Element fieldsElement = request.getElement("fields");
        for (String field : options.fields) {
            fieldsElement.appendValue(field);
        }
        request.set("periodicityAdjustment", "ACTUAL");
        request.set("periodicitySelection", "MONTHLY");
        request.set("startDate", "20200101");
        request.set("endDate", "20201231");
        request.set("maxDataPoints", 100);
        request.set("returnEids", true);
        return request;
    }

    public static void processResponseEvent(Event event) {
        for (Message msg : event) {
            System.out.println("Received response to request " + msg.getRequestId());
            System.out.println(msg);
        }
    }
}

