/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapiexamples.demoapps.util.RequestOptions;

public class ReferenceDataRequests {
    private static final Name SECURITY_DATA = new Name("securityData");
    private static final Name SECURITY = new Name("security");
    private static final Name FIELD_DATA = new Name("fieldData");
    private static final Name RESPONSE_ERROR = new Name("responseError");
    private static final Name SECURITY_ERROR = new Name("securityError");
    private static final Name FIELD_EXCEPTIONS = new Name("fieldExceptions");
    private static final Name FIELD_ID = new Name("fieldId");
    private static final Name ERROR_INFO = new Name("errorInfo");

    public static Request createRequest(Service service, RequestOptions options) {
        Request request = service.createRequest("ReferenceDataRequest");
        Element securitiesElement = request.getElement("securities");
        for (String string : options.securities) {
            securitiesElement.appendValue(string);
        }
        Element fieldsElement = request.getElement("fields");
        for (String field : options.fields) {
            fieldsElement.appendValue(field);
        }
        if (!options.overrides.isEmpty()) {
            Element element = request.getElement("overrides");
            for (RequestOptions.Override override : options.overrides) {
                Element overrideElement = element.appendElement();
                overrideElement.setElement("fieldId", override.fieldId);
                overrideElement.setElement("value", override.value);
            }
        }
        return request;
    }

    public static Request createTableOverrideRequest(Service service, RequestOptions options) {
        RateVector[] vectors;
        Request request = service.createRequest("ReferenceDataRequest");
        Element securitiesElement = request.getElement("securities");
        for (String string : options.securities) {
            securitiesElement.appendValue(string);
        }
        Element fieldsElement = request.getElement("fields");
        for (String field : options.fields) {
            fieldsElement.appendValue(field);
        }
        Element element = request.getElement("overrides");
        Element override1 = element.appendElement();
        override1.setElement("fieldId", "ALLOW_DYNAMIC_CASHFLOW_CALCS");
        override1.setElement("value", "Y");
        Element override2 = element.appendElement();
        override2.setElement("fieldId", "LOSS_SEVERITY");
        override2.setElement("value", 31);
        Element tableOverrides = request.getElement("tableOverrides");
        Element tableOverride = tableOverrides.appendElement();
        tableOverride.setElement("fieldId", "DEFAULT_VECTOR");
        Element rows = tableOverride.getElement("row");
        Element row = rows.appendElement();
        Element cols = row.getElement("value");
        cols.appendValue("Anchor");
        cols.appendValue("PROJ");
        row = rows.appendElement();
        cols = row.getElement("value");
        cols.appendValue("Type");
        cols.appendValue("CDR");
        for (RateVector rateVector : vectors = new RateVector[]{new RateVector(1.0f, 12, 'S'), new RateVector(2.0f, 12, 'R')}) {
            row = rows.appendElement();
            cols = row.getElement("value");
            cols.appendValue(rateVector.rate);
            cols.appendValue(rateVector.duration);
            cols.appendValue(rateVector.transition);
        }
        return request;
    }

    public static void processResponseEvent(Event event) {
        for (Message msg : event) {
            System.out.println("Received response to request " + msg.getRequestId());
            if (msg.hasElement(RESPONSE_ERROR)) {
                System.out.println("REQUEST FAILED: " + msg.getElement(RESPONSE_ERROR));
                continue;
            }
            Element securities = msg.getElement(SECURITY_DATA);
            int numSecurities = securities.numValues();
            System.out.println("Processing " + numSecurities + " securities:");
            for (int i2 = 0; i2 < numSecurities; ++i2) {
                Element fields;
                Element security = securities.getValueAsElement(i2);
                String ticker = security.getElementAsString(SECURITY);
                System.out.println();
                System.out.println("Ticker: " + ticker);
                if (security.hasElement(SECURITY_ERROR)) {
                    System.out.println("SECURITY FAILED: " + security.getElement(SECURITY_ERROR));
                    continue;
                }
                if (security.hasElement(FIELD_DATA) && (fields = security.getElement(FIELD_DATA)).numElements() > 0) {
                    System.out.println("FIELD\t\tVALUE");
                    System.out.println("-----\t\t-----");
                    int numElements = fields.numElements();
                    for (int j2 = 0; j2 < numElements; ++j2) {
                        Element field = fields.getElement(j2);
                        System.out.println(field.name() + "\t\t" + field);
                    }
                }
                System.out.println();
                Element fieldExceptions = security.getElement(FIELD_EXCEPTIONS);
                if (fieldExceptions.numValues() <= 0) continue;
                System.out.println("FIELD\t\tEXCEPTION");
                System.out.println("-----\t\t---------");
                for (int k2 = 0; k2 < fieldExceptions.numValues(); ++k2) {
                    Element fieldException = fieldExceptions.getValueAsElement(k2);
                    System.out.println(fieldException.getElementAsString(FIELD_ID) + "\t\t" + fieldException.getElement(ERROR_INFO));
                }
            }
        }
    }

    private static class RateVector {
        public final float rate;
        public final int duration;
        public final char transition;

        public RateVector(float rate, int duration, char transition) {
            this.rate = rate;
            this.duration = duration;
            this.transition = transition;
        }
    }
}

