/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.impl.bk;
import com.bloomberglp.blpapi.impl.iU;
import com.bloomberglp.blpapi.impl.infr.util.b;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class TlsOptions {
    private static final Logger M = b.bf("TlsOptions");
    private final SSLContext al;
    private int am;
    private int an;

    private static void a(Object object, String string) {
        if (object == null) {
            M.warning(String.format("Parameter %s has null value", string));
            throw new NullPointerException(string + " must have a non-null value");
        }
    }

    private TlsOptions(SSLContext sSLContext) {
        this.al = sSLContext;
        this.am = 10000;
        this.an = 20000;
    }

    private static KeyStore a(InputStream inputStream, char[] cArray) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, TlsInitializationException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(inputStream, cArray);
        Enumeration<String> enumeration = keyStore.aliases();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new TlsInitializationException("provided client credentials don't have a secret key");
        }
        return keyStore;
    }

    private static KeyStore a(InputStream inputStream) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, TlsInitializationException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
        if (collection.isEmpty()) {
            throw new TlsInitializationException("no trusted certificates");
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        int n2 = 0;
        for (X509Certificate x509Certificate : collection) {
            x509Certificate.checkValidity();
            String string = x509Certificate.getSubjectX500Principal().getName();
            String string2 = String.format("%s%d", string, n2++);
            keyStore.setCertificateEntry(string2, x509Certificate);
        }
        return keyStore;
    }

    private static SSLContext a(InputStream inputStream, char[] cArray, InputStream inputStream2) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException, KeyManagementException, TlsInitializationException {
        Object object;
        Object object2;
        char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
        KeyStore keyStore = TlsOptions.a(inputStream, cArray2);
        for (String object32 : Collections.list(keyStore.aliases())) {
            object2 = keyStore.getCertificate(object32);
            object = (X509Certificate)object2;
            M.info(() -> TlsOptions.a((X509Certificate)object));
        }
        String string = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string);
        M.fine(() -> "Using algorithm " + keyManagerFactory.getAlgorithm() + " for KeyManagerFactory");
        keyManagerFactory.init(keyStore, cArray2);
        object2 = TlsOptions.a(inputStream2);
        object = TrustManagerFactory.getInstance("PKIX");
        ((TrustManagerFactory)object).init((KeyStore)object2);
        SSLContext sSLContext = SSLContext.getInstance(iU.rT());
        sSLContext.init(keyManagerFactory.getKeyManagers(), ((TrustManagerFactory)object).getTrustManagers(), null);
        return sSLContext;
    }

    private static TlsOptions b(InputStream inputStream, char[] cArray, InputStream inputStream2) throws TlsInitializationException {
        try {
            return new TlsOptions(TlsOptions.a(inputStream, cArray, inputStream2));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            M.log(Level.WARNING, "Got UnrecoverableKeyException: " + unrecoverableKeyException.getMessage(), unrecoverableKeyException);
            throw new TlsInitializationException(unrecoverableKeyException.getMessage(), unrecoverableKeyException);
        }
        catch (KeyManagementException keyManagementException) {
            M.log(Level.WARNING, "Got KeyManagementException: " + keyManagementException.getMessage(), keyManagementException);
            throw new TlsInitializationException(keyManagementException.getMessage(), keyManagementException);
        }
        catch (CertificateException certificateException) {
            M.log(Level.WARNING, "Got CertificateException: " + certificateException.getMessage(), certificateException);
            throw new TlsInitializationException(certificateException.getMessage(), certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            M.log(Level.WARNING, "Got KeyStoreException: " + keyStoreException.getMessage(), keyStoreException);
            throw new TlsInitializationException(keyStoreException.getMessage(), keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            M.log(Level.WARNING, "Got NuSuchAlgorithmException: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            throw new TlsInitializationException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            M.log(Level.WARNING, "Got IOException: " + iOException.getMessage(), iOException);
            throw new TlsInitializationException(iOException.getMessage(), iOException);
        }
    }

    public static TlsOptions createFromFiles(String string, char[] cArray, String string2) throws TlsInitializationException {
        M.info("Creating TlsOptions from files");
        TlsOptions.a(string, "clientCredentialsFileName");
        TlsOptions.a(cArray, "clientCredentialsPassword");
        TlsOptions.a(string2, "trustedCertificatesFileName");
        File file = new File(string);
        if (file.length() > 0x6400000L) {
            throw new IllegalArgumentException("Client credentials file mustn't be larger than 100 MB");
        }
        File file2 = new File(string2);
        if (file2.length() > 0x6400000L) {
            throw new IllegalArgumentException("Trusted certificates file musn't be larger than 100 MB");
        }
        FileInputStream fileInputStream = null;
        InputStream inputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStream = new FileInputStream(file2);
            TlsOptions tlsOptions = TlsOptions.b(fileInputStream, cArray, inputStream);
            return tlsOptions;
        }
        catch (FileNotFoundException fileNotFoundException) {
            M.log(Level.WARNING, "Got FileNotFoundException: " + fileNotFoundException.getMessage(), fileNotFoundException);
            throw new TlsInitializationException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    M.log(Level.WARNING, "Failed to close client credentials file: " + iOException.getMessage(), iOException);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    M.log(Level.WARNING, "Failed to close trusted certificates file: " + iOException.getMessage(), iOException);
                }
            }
        }
    }

    public static TlsOptions createFromBlobs(byte[] byArray, char[] cArray, byte[] byArray2) throws TlsInitializationException {
        M.info("Creating TlsOptions from Blobs");
        TlsOptions.a(byArray, "clientCredentialsRawData");
        TlsOptions.a(cArray, "clientCredentialsPassword");
        TlsOptions.a(byArray2, "trustedCertificatesRawData");
        return TlsOptions.b(new ByteArrayInputStream(byArray), cArray, new ByteArrayInputStream(byArray2));
    }

    public static TlsOptions create(SSLContext sSLContext) {
        M.info("Creating TlsOptions from SSLContext");
        TlsOptions.a(sSLContext, "sslContext");
        return new TlsOptions(sSLContext);
    }

    public SSLContext getSslContext() {
        return this.al;
    }

    public int getTlsHandshakeTimeout() {
        return this.am;
    }

    public void setTlsHandshakeTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("TLSTimeout must be positive value");
        }
        this.am = n2;
    }

    public int getCrlTimeout() {
        return this.an;
    }

    public void setCrlTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("CrlTimeout must be positive value");
        }
        this.an = n2;
    }

    private static /* synthetic */ String a(X509Certificate x509Certificate) {
        return "[ Version= " + x509Certificate.getVersion() + " Serial Number= " + x509Certificate.getSerialNumber().toString(16).toUpperCase() + " Issuer= " + x509Certificate.getIssuerX500Principal().getName() + " Valid From= " + x509Certificate.getNotBefore() + " Valid Through= " + x509Certificate.getNotAfter() + " Subject= " + x509Certificate.getSubjectX500Principal().getName() + " CertificateHash= " + bk.b(x509Certificate) + " ]";
    }

    public static class TlsInitializationException
    extends Exception {
        TlsInitializationException(String string, Throwable throwable) {
            super("Failed to initialize TLS: " + string, throwable);
        }

        TlsInitializationException(String string) {
            super(string);
        }
    }
}

