/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.impl.L;
import com.bloomberglp.blpapi.impl.br;

public class TopicList {
    private static final Name S = Name.getName("topic");
    private static final Name ao = Name.getName("resolvedTopic");
    private br ap = new br(Status.NOT_CREATED.ordinal());

    public void add(String string) {
        this.add(string, new CorrelationID());
    }

    public void add(String string, CorrelationID correlationID) {
        if (string == null || correlationID == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        if (!this.d(string)) {
            throw new IllegalArgumentException("Invalid topic string");
        }
        this.ap.add(string, correlationID);
    }

    private boolean d(String string) {
        return string.matches("//[^/]+/[^/]+/[^?]+(\\?[^&]+(&[^&]+)*)?");
    }

    public void add(Message message) {
        this.add(message, new CorrelationID());
    }

    public void add(Message message, CorrelationID correlationID) {
        Name name = message.asElement().name();
        if (name.equals(Names.TOPIC_SUBSCRIBED)) {
            this.ap.a(message.getElementAsString(S), correlationID, ((L)message).aQ());
        } else if (name.equals(Names.RESOLUTION_SUCCESS)) {
            this.ap.a(message.getElementAsString(ao), correlationID, ((L)message).aQ());
        } else {
            throw new IllegalArgumentException("Invalid message to add into topic list");
        }
    }

    public CorrelationID correlationIdAt(int n2) {
        return this.ap.aF(n2);
    }

    public String topicString(CorrelationID correlationID) {
        return this.ap.o(correlationID);
    }

    public String topicStringAt(int n2) {
        return this.ap.aG(n2);
    }

    public Status status(CorrelationID correlationID) {
        return Status.d(this.ap.p(correlationID));
    }

    public Status statusAt(int n2) {
        return Status.d(this.ap.aH(n2));
    }

    public Message message(CorrelationID correlationID) {
        return this.ap.q(correlationID);
    }

    public Message messageAt(int n2) {
        return this.ap.aI(n2);
    }

    public int size() {
        return this.ap.size();
    }

    br p() {
        return this.ap;
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NOT_CREATED = new Status();
        public static final /* enum */ Status CREATED = new Status();
        public static final /* enum */ Status FAILURE = new Status();
        private static final /* synthetic */ Status[] aq;

        public static Status[] values() {
            return (Status[])aq.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }

        static Status d(int n2) {
            if (n2 == NOT_CREATED.ordinal()) {
                return NOT_CREATED;
            }
            if (n2 == CREATED.ordinal()) {
                return CREATED;
            }
            assert (FAILURE.ordinal() == n2);
            return FAILURE;
        }

        static {
            aq = new Status[]{NOT_CREATED, CREATED, FAILURE};
        }
    }
}

