/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventFormatter;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.ProviderEventHandler;
import com.bloomberglp.blpapi.ProviderSession;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.ServiceRegistrationOptions;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapi.Topic;
import com.bloomberglp.blpapi.TopicList;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class InteractivePublisherExample {
    private static final Name TOPIC = Name.getName("topic");
    private static final Name RESOLVED_TOPIC = Name.getName("resolvedTopic");
    private String serviceName;
    private final List<Integer> eids = new ArrayList<Integer>();
    private final Set<Topic> activeTopics = new HashSet<Topic>();
    private String groupId = null;
    private int priority = Integer.MAX_VALUE;
    private int clearInterval = 0;
    private boolean useSsc = false;
    private int sscBegin;
    private int sscEnd;
    private int sscPriority;
    private Integer resolveSubServiceCode = null;
    private boolean running = true;
    private boolean pageEnabled = false;
    private final Object lock = new Object();
    private ConnectionAndAuthOptions connectionAndAuthOptions;

    private void activate(ProviderSession session) {
        if (this.useSsc) {
            System.out.format("Activating sub service code range [%1$d, %2$d] @ priority: %3$d", this.sscBegin, this.sscEnd, this.sscPriority);
            session.activateSubServiceCodeRange(this.serviceName, this.sscBegin, this.sscEnd, this.sscPriority);
        }
    }

    private void deactivate(ProviderSession session) {
        if (this.useSsc) {
            System.out.format("Deactivating sub service code range [%1$d, %2$d] @ priority: %3$d", this.sscBegin, this.sscEnd, this.sscPriority);
            session.deactivateSubServiceCodeRange(this.serviceName, this.sscBegin, this.sscEnd);
        }
    }

    private void parseSubServiceCodeRangeAndPriority(String value) {
        String[] splitRange = value.split(",");
        if (splitRange.length != 3) {
            throw new IllegalArgumentException("Invalid sub-service code range: " + value);
        }
        this.useSsc = true;
        this.sscBegin = Integer.parseInt(splitRange[0]);
        this.sscEnd = Integer.parseInt(splitRange[1]);
        this.sscPriority = Integer.parseInt(splitRange[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String[] args) throws InterruptedException, TlsOptions.TlsInitializationException, IOException {
        if (!this.parseCommandLine(args)) {
            return;
        }
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption();
        ProviderSession session = new ProviderSession(sessionOptions, new MyEventHandler());
        if (!session.start()) {
            System.err.println("Failed to start session");
            return;
        }
        try {
            boolean serviceRegistered;
            ServiceRegistrationOptions serviceRegistrationOptions = new ServiceRegistrationOptions();
            serviceRegistrationOptions.setGroupId(this.groupId);
            serviceRegistrationOptions.setServicePriority(this.priority);
            if (this.useSsc) {
                System.out.format("Activating sub service code range [%1$d, %2$d] @ priority: %3$d", this.sscBegin, this.sscEnd, this.sscPriority);
                try {
                    serviceRegistrationOptions.addActiveSubServiceCodeRange(this.sscBegin, this.sscEnd, this.sscPriority);
                }
                catch (Exception e2) {
                    System.err.println("FAILED to add active sub service codes.");
                    e2.printStackTrace();
                }
            }
            if (!(serviceRegistered = session.registerService(this.serviceName, session.getSessionIdentity(), serviceRegistrationOptions))) {
                System.err.println("Service registration failed: " + this.serviceName);
                return;
            }
            Service service = session.getService(this.serviceName);
            if (service == null) {
                System.err.println("Failed to get service: " + this.serviceName);
                return;
            }
            System.out.println("Service registered: " + this.serviceName);
            int eventCount = 0;
            while (true) {
                Event event;
                Object object = this.lock;
                synchronized (object) {
                    while (this.activeTopics.isEmpty()) {
                        if (!this.running) {
                            return;
                        }
                        try {
                            this.lock.wait(1000L);
                        }
                        catch (InterruptedException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    event = service.createPublishEvent();
                    EventFormatter eventFormatter = new EventFormatter(event);
                    boolean publishNull = false;
                    if (this.clearInterval > 0 && eventCount == this.clearInterval) {
                        eventCount = 0;
                        publishNull = true;
                    }
                    for (Topic topic : this.activeTopics) {
                        if (this.pageEnabled) {
                            InteractivePublisherExample.formatPageEvent(eventFormatter, topic, publishNull);
                            continue;
                        }
                        InteractivePublisherExample.formatMarketDataEvent(eventFormatter, topic, publishNull);
                    }
                }
                System.out.println("Publishing event: " + event);
                session.publish(event);
                Thread.sleep(2000L);
                if (++eventCount % 3 != 0) continue;
                this.deactivate(session);
                Thread.sleep(10000L);
                this.activate(session);
            }
        }
        finally {
            session.stop();
        }
    }

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Interactive publisher example", InteractivePublisherExample.class);
        try {
            this.connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
            ArgGroup argGroupPublisher = new ArgGroup("Publisher Options", new Arg[0]);
            argGroupPublisher.add("-s", "--service").setDescription("the service name").setRequired(true).setMetaVar("service").setAction(value -> {
                this.serviceName = value;
            });
            argGroupPublisher.add("-g", "--group-id").setDescription("the group ID of the service, default to an automatically generated unique value").setMetaVar("groupId").setAction(value -> {
                this.groupId = value;
            });
            argGroupPublisher.add("-p", "--priority").setDescription("the service priority").setMetaVar("priority").setDefaultValue(String.valueOf(this.priority)).setAction(value -> {
                this.priority = Integer.parseInt(value);
            });
            argGroupPublisher.add("--register-ssc").setMetaVar("begin,end,priority").setDescription("specify active sub-service code range and priority separated by ','").setAction(this::parseSubServiceCodeRangeAndPriority);
            argGroupPublisher.add("--clear-cache").setMetaVar("eventCount").setDescription("number of events after which cache will be cleared (default: 0, i.e cache never cleared)").setAction(value -> {
                this.clearInterval = Integer.parseInt(value);
            });
            argGroupPublisher.add("--resolve-ssc").setMetaVar("subServiceCode").setDescription("sub-service code to be used in permission response").setAction(value -> {
                this.resolveSubServiceCode = Integer.valueOf(value);
            });
            argGroupPublisher.add("-E", "--eid").setMetaVar("eid").setDescription("EIDs that are used in permission response").setMode(ArgMode.MULTIPLE_VALUES).setAction(value -> this.eids.add(Integer.valueOf(value)));
            argGroupPublisher.add("-P", "--page").setDescription("enable publish as page").setMode(ArgMode.NO_VALUE).setAction(value -> {
                this.pageEnabled = true;
            });
            argParser.addGroup(argGroupPublisher);
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        return true;
    }

    private static void formatMarketDataRecapEvent(EventFormatter eventFormatter) {
        eventFormatter.setElement("OPEN", 100.0);
    }

    private static void formatPageRecapEvent(EventFormatter eventFormatter) {
        int numRows = 5;
        eventFormatter.setElement("numRows", numRows);
        eventFormatter.setElement("numCols", 80);
        eventFormatter.pushElement("rowUpdate");
        for (int i2 = 1; i2 <= numRows; ++i2) {
            eventFormatter.appendElement();
            eventFormatter.setElement("rowNum", i2);
            eventFormatter.pushElement("spanUpdate");
            eventFormatter.appendElement();
            eventFormatter.setElement("startCol", 1);
            eventFormatter.setElement("length", 10);
            eventFormatter.setElement("text", "INTIAL");
            eventFormatter.setElement("fgColor", "RED");
            eventFormatter.pushElement("attr");
            eventFormatter.appendValue("UNDERLINE");
            eventFormatter.appendValue("BLINK");
            eventFormatter.popElement();
            eventFormatter.popElement();
            eventFormatter.popElement();
            eventFormatter.popElement();
        }
        eventFormatter.popElement();
    }

    private static void formatMarketDataEvent(EventFormatter eventFormatter, Topic topic, boolean publishNull) {
        eventFormatter.appendMessage("MarketDataEvents", topic);
        if (publishNull) {
            eventFormatter.setElementNull("HIGH");
            eventFormatter.setElementNull("LOW");
        } else {
            eventFormatter.setElement("HIGH", 100);
            eventFormatter.setElement("LOW", 99);
        }
    }

    private static void formatPageEvent(EventFormatter eventFormatter, Topic topic, boolean publishNull) {
        int numRows = 5;
        for (int i2 = 1; i2 <= numRows; ++i2) {
            eventFormatter.appendMessage("RowUpdate", topic);
            eventFormatter.setElement("rowNum", i2);
            if (publishNull) {
                eventFormatter.setElementNull("spanUpdate");
                continue;
            }
            eventFormatter.pushElement("spanUpdate");
            eventFormatter.appendElement();
            eventFormatter.setElement("startCol", 1);
            eventFormatter.setElement("length", 100);
            eventFormatter.setElement("text", "row " + i2);
            eventFormatter.popElement();
            eventFormatter.popElement();
        }
    }

    public static void main(String[] args) throws Exception {
        InteractivePublisherExample example = new InteractivePublisherExample();
        example.run(args);
        System.out.println("Press ENTER to quit");
        System.in.read();
    }

    private class MyEventHandler
    implements ProviderEventHandler {
        private MyEventHandler() {
        }

        @Override
        public void processEvent(Event event, ProviderSession session) {
            try {
                this.doProcessEvent(event, session);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doProcessEvent(Event event, ProviderSession session) {
            block8: {
                Event.EventType eventType;
                block11: {
                    block10: {
                        block9: {
                            System.out.println("Received event: " + event);
                            eventType = event.eventType();
                            if (eventType != Event.EventType.SESSION_STATUS) break block9;
                            for (Message msg : event) {
                                if (msg.messageType() != Names.SESSION_TERMINATED) continue;
                                System.out.println("Session terminated, stopping application...");
                                Object object = InteractivePublisherExample.this.lock;
                                synchronized (object) {
                                    InteractivePublisherExample.this.running = false;
                                    break block8;
                                }
                            }
                            break block8;
                        }
                        if (eventType != Event.EventType.TOPIC_STATUS) break block10;
                        this.processTopicStatusEvent(event, session);
                        break block8;
                    }
                    if (eventType != Event.EventType.RESOLUTION_STATUS) break block11;
                    for (Message msg : event) {
                        if (msg.messageType() == Names.RESOLUTION_SUCCESS) {
                            String resolvedTopic = msg.getElementAsString(RESOLVED_TOPIC);
                            System.out.println("ResolvedTopic: " + resolvedTopic);
                            continue;
                        }
                        if (msg.messageType() != Names.RESOLUTION_FAILURE) continue;
                        System.out.println("Topic resolution failed (cid = " + msg.correlationID() + ")");
                    }
                    break block8;
                }
                if (eventType != Event.EventType.REQUEST) break block8;
                for (Message msg : event) {
                    if (msg.messageType() == Names.PERMISSION_REQUEST) {
                        this.processPermissionRequest(session, msg);
                        continue;
                    }
                    System.out.println("Received unknown request: " + msg);
                }
            }
        }

        private void processPermissionRequest(ProviderSession session, Message msg) {
            Service service = session.getService(InteractivePublisherExample.this.serviceName);
            Event response = service.createResponseEvent(msg.correlationID());
            EventFormatter ef2 = new EventFormatter(response);
            int permission = 1;
            if (msg.hasElement("uuid")) {
                int uuid = msg.getElementAsInt32("uuid");
                System.out.println("UUID = " + uuid);
                permission = 0;
            }
            if (msg.hasElement("applicationId")) {
                int applicationId = msg.getElementAsInt32("applicationId");
                System.out.println("APPID = " + applicationId);
                permission = 0;
            }
            ef2.appendResponse("PermissionResponse");
            ef2.pushElement("topicPermissions");
            Element topicsElement = msg.getElement(Name.getName("topics"));
            for (int i2 = 0; i2 < topicsElement.numValues(); ++i2) {
                ef2.appendElement();
                ef2.setElement("topic", topicsElement.getValueAsString(i2));
                ef2.setElement("result", permission);
                if (permission == 1) {
                    ef2.pushElement("reason");
                    ef2.setElement("source", "My Publisher Name");
                    ef2.setElement("category", "NOT_AUTHORIZED");
                    ef2.setElement("subcategory", "Publisher Controlled");
                    ef2.setElement("description", "Permission denied by My Publisher Name");
                    ef2.popElement();
                } else {
                    if (InteractivePublisherExample.this.resolveSubServiceCode != null) {
                        ef2.setElement("subServiceCode", (int)InteractivePublisherExample.this.resolveSubServiceCode);
                        System.err.format("Mapping topic %1$s to subserviceCode %2$d", topicsElement.getValueAsString(i2), InteractivePublisherExample.this.resolveSubServiceCode);
                    }
                    if (!InteractivePublisherExample.this.eids.isEmpty()) {
                        ef2.pushElement("permissions");
                        ef2.appendElement();
                        ef2.setElement("permissionService", "//blp/blpperm");
                        ef2.pushElement("eids");
                        Iterator iterator = InteractivePublisherExample.this.eids.iterator();
                        while (iterator.hasNext()) {
                            int eid = (Integer)iterator.next();
                            ef2.appendValue(eid);
                        }
                        ef2.popElement();
                        ef2.popElement();
                        ef2.popElement();
                    }
                }
                ef2.popElement();
            }
            ef2.popElement();
            session.sendResponse(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTopicStatusEvent(Event event, ProviderSession session) {
            TopicList topicsToCreate = new TopicList();
            ArrayList<Topic> unsubscribedTopics = new ArrayList<Topic>();
            for (Message msg : event) {
                Object topicString;
                Name messageType = msg.messageType();
                Topic topic = session.getTopic(msg);
                if (messageType == Names.TOPIC_SUBSCRIBED) {
                    if (topic != null) continue;
                    topicString = msg.getElementAsString(TOPIC);
                    CorrelationID cid = new CorrelationID(topicString);
                    topicsToCreate.add(msg, cid);
                    continue;
                }
                if (messageType == Names.TOPIC_UNSUBSCRIBED) {
                    unsubscribedTopics.add(topic);
                    topicString = InteractivePublisherExample.this.lock;
                    synchronized (topicString) {
                        InteractivePublisherExample.this.activeTopics.remove(topic);
                        InteractivePublisherExample.this.lock.notifyAll();
                        continue;
                    }
                }
                if (messageType == Names.TOPIC_ACTIVATED) {
                    topicString = InteractivePublisherExample.this.lock;
                    synchronized (topicString) {
                        InteractivePublisherExample.this.activeTopics.add(topic);
                        InteractivePublisherExample.this.lock.notifyAll();
                        continue;
                    }
                }
                if (messageType != Names.TOPIC_RECAP) continue;
                Service service = topic.service();
                Event recapEvent = service.createPublishEvent();
                EventFormatter eventFormatter = new EventFormatter(recapEvent);
                CorrelationID correlationId = msg.correlationID();
                eventFormatter.appendRecapMessage(topic, correlationId);
                if (InteractivePublisherExample.this.pageEnabled) {
                    InteractivePublisherExample.formatPageRecapEvent(eventFormatter);
                } else {
                    InteractivePublisherExample.formatMarketDataRecapEvent(eventFormatter);
                }
                session.publish(recapEvent);
                System.out.println("Publishing Recap: " + recapEvent);
            }
            if (topicsToCreate.size() > 0) {
                session.createTopicsAsync(topicsToCreate);
            }
            if (!unsubscribedTopics.isEmpty()) {
                session.deleteTopics(unsubscribedTopics);
            }
        }
    }
}

