/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.util;

import com.bloomberglp.blpapi.AuthApplication;
import com.bloomberglp.blpapi.AuthOptions;
import com.bloomberglp.blpapi.AuthToken;
import com.bloomberglp.blpapi.AuthUser;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapi.ZfpUtil;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectionAndAuthOptions {
    private static final String AUTH_OPTION_NONE = "none";
    private static final String AUTH_OPTION_USER = "user";
    private static final String AUTH_OPTION_APP = "app";
    private static final String AUTH_OPTION_USER_APP = "userapp";
    private static final String AUTH_OPTION_DIR = "dir";
    private static final String AUTH_OPTION_MANUAL = "manual";
    List<SessionOptions.ServerAddress> servers = new ArrayList<SessionOptions.ServerAddress>();
    AuthOptions sessionIdentityAuthOptions;
    String clientCredentials;
    String clientCredentialsPassword;
    String trustMaterial;
    ZfpUtil.Remote remote;
    private boolean clientServerSetup = false;
    private AuthApplication authApplication;
    private final List<String> tokens = new ArrayList<String>();
    private final List<String[]> userIdAndIps = new ArrayList<String[]>();

    private ConnectionAndAuthOptions(ArgParser argParser, boolean clientServerSetup) {
        Objects.requireNonNull(argParser, "argParser must not be null");
        this.clientServerSetup = clientServerSetup;
        this.addArgGroupServer(argParser);
        if (clientServerSetup) {
            this.addArgGroupAuthClientServerSetup(argParser);
        } else {
            this.addArgGroupAuth(argParser);
        }
        this.addArgGroupTls(argParser);
        this.addArgGroupZfpLeasedLine(argParser);
    }

    public ConnectionAndAuthOptions(ArgParser argParser) {
        this(argParser, false);
    }

    public static ConnectionAndAuthOptions forClientServerSetup(ArgParser argParser) {
        return new ConnectionAndAuthOptions(argParser, true);
    }

    public SessionOptions createSessionOption() throws InterruptedException, TlsOptions.TlsInitializationException {
        SessionOptions sessionOptions = new SessionOptions();
        TlsOptions tlsOptions = null;
        if (this.clientCredentials != null && this.clientCredentialsPassword != null && this.trustMaterial != null) {
            tlsOptions = TlsOptions.createFromFiles(this.clientCredentials, this.clientCredentialsPassword.toCharArray(), this.trustMaterial);
        }
        if (this.remote == null) {
            sessionOptions.setServerAddresses(this.servers.toArray(new SessionOptions.ServerAddress[0]));
            sessionOptions.setTlsOptions(tlsOptions);
        } else {
            if (tlsOptions == null) {
                throw new IllegalArgumentException("ZFP connections require TLS parameters");
            }
            sessionOptions = ZfpUtil.getZfpOptionsForLeasedLines(this.remote, tlsOptions);
        }
        sessionOptions.setSessionIdentityOptions(this.sessionIdentityAuthOptions);
        System.out.println("Connecting to " + Arrays.toString(sessionOptions.getServerAddresses()));
        return sessionOptions;
    }

    public Map<String, AuthOptions> createClientServerSetupAuthOptions() {
        HashMap<String, AuthOptions> authOptionsByIdentifier = new HashMap<String, AuthOptions>();
        for (String[] userIdIp : this.userIdAndIps) {
            String userId = userIdIp[0];
            String ip2 = userIdIp[1];
            AuthUser authUser = AuthUser.createWithManualOptions(userId, ip2);
            AuthOptions authOptions = new AuthOptions(authUser, this.authApplication);
            authOptionsByIdentifier.put(userId + ":" + ip2, authOptions);
        }
        for (int i2 = 0; i2 < this.tokens.size(); ++i2) {
            AuthOptions authOptions = new AuthOptions(new AuthToken(this.tokens.get(i2)));
            authOptionsByIdentifier.put("token #" + (i2 + 1), authOptions);
        }
        return authOptionsByIdentifier;
    }

    public int numClientServerSetupAuthOptions() {
        return this.userIdAndIps.size() + this.tokens.size();
    }

    private void addArgGroupServer(ArgParser argParser) {
        Arg argServer = new Arg("-H", "--host").setMetaVar("host:port").setDescription("Server name or IP and port separated by ':'").setDefaultValue("localhost:8194").setAction(this::parseServerAddress).setMode(ArgMode.MULTIPLE_VALUES);
        ArgGroup groupServer = new ArgGroup("Connections", argServer);
        argParser.addGroup(groupServer);
    }

    private void addArgGroupAuth(ArgParser argParser) {
        String eol = System.lineSeparator();
        Arg argAuth = new Arg("-a", "--auth").setMetaVar("option").setDescription("authorization option" + eol + "none                  applicable to Desktop API product that requires" + eol + "                          Bloomberg Professional service to be installed locally" + eol + "user                  as a user using OS logon information" + eol + "dir=<property>        as a user using directory services" + eol + "app=<app>             as the specified application" + eol + "userapp=<app>         as user and application using logon information for the user" + eol + "manual=<app,ip,user>  as user and application, with manually provided" + eol + "                          IP address and EMRS user").setDefaultValue(AUTH_OPTION_NONE).setAction(this::parseAuthOptions);
        ArgGroup groupAuth = new ArgGroup("Authorization", argAuth);
        argParser.addGroup(groupAuth);
    }

    private void addArgGroupAuthClientServerSetup(ArgParser argParser) {
        Arg argAuth = new Arg("-a", "--auth").setMetaVar("app=<app>").setDescription("authorize this application using the specified application").setRequired(true).setAction(this::parseAuthOptions);
        ArgGroup groupAuth = new ArgGroup("Authorization", argAuth);
        argParser.addGroup(groupAuth);
        Arg argUserIdIp = new Arg("-u", "--userid-ip").setMetaVar("userId:IP").setDescription("authorize a user using userId and IP separated by ':'").setAction(this::parseUserIdIp).setMode(ArgMode.MULTIPLE_VALUES);
        Arg argToken = new Arg("-T", "--token").setMetaVar("token").setDescription("authorize a user using the specified token").setMode(ArgMode.MULTIPLE_VALUES).setAction(this.tokens::add);
        ArgGroup groupEntitlements = new ArgGroup("User Authorization/Entitlements", argUserIdIp, argToken);
        argParser.addGroup(groupEntitlements);
    }

    private void addArgGroupTls(ArgParser argParser) {
        Arg argTlsClientCedentials = new Arg("--tls-client-credentials").setMetaVar("file").setDescription("name a PKCS#12 file to use as a source of client credentials").setAction(value -> {
            this.clientCredentials = value;
        });
        Arg argTlsClientCredentialsPassword = new Arg("--tls-client-credentials-password").setMetaVar("password").setDescription("specify password for accessing client credentials").setAction(value -> {
            this.clientCredentialsPassword = value;
        });
        Arg argTlsTrustMaterial = new Arg("--tls-trust-material").setMetaVar("file").setDescription("name a PKCS#7 file to use as a source of trusted certificates").setAction(value -> {
            this.trustMaterial = value;
        });
        ArgGroup groupTls = new ArgGroup("TLS (specify all or none)", argTlsClientCedentials, argTlsClientCredentialsPassword, argTlsTrustMaterial);
        argParser.addGroup(groupTls);
    }

    private void addArgGroupZfpLeasedLine(ArgParser argParser) {
        Arg argZfpOverLeasedLine = new Arg("-z", "--zfp-over-leased-line").setMetaVar("port").setDescription("enable ZFP connections over leased lines on the specified port (8194 or 8196)" + System.lineSeparator() + "(When this option is enabled, option -H/--host is ignored.)").setAction(this::parseRemote);
        ArgGroup groupZfpLl = new ArgGroup("ZFP connections over leased lines (requires TLS)", argZfpOverLeasedLine);
        argParser.addGroup(groupZfpLl);
    }

    private void parseServerAddress(String value) {
        int port;
        String[] splitTokens = value.split(":");
        if (splitTokens.length != 2) {
            throw new IllegalArgumentException("Invalid server option: " + value);
        }
        try {
            port = Integer.parseInt(splitTokens[1]);
        }
        catch (NumberFormatException ex2) {
            throw new IllegalArgumentException("Invalid port: " + ex2.getMessage());
        }
        this.servers.add(new SessionOptions.ServerAddress(splitTokens[0], port));
    }

    private void parseRemote(String port) {
        if ("8194".equals(port)) {
            this.remote = ZfpUtil.Remote.REMOTE_8194;
            return;
        }
        if ("8196".equals(port)) {
            this.remote = ZfpUtil.Remote.REMOTE_8196;
            return;
        }
        throw new IllegalArgumentException("Invalid port " + port);
    }

    private void parseAuthOptions(String value) {
        String authType;
        String[] splitTokens = value.split("=");
        switch (authType = splitTokens[0]) {
            case "none": {
                this.sessionIdentityAuthOptions = new AuthOptions();
                break;
            }
            case "user": {
                this.sessionIdentityAuthOptions = new AuthOptions(AuthUser.createWithLogonName());
                break;
            }
            case "app": {
                if (splitTokens.length == 1) {
                    throw new IllegalArgumentException("auth " + authType + "= is missing application name");
                }
                this.authApplication = new AuthApplication(splitTokens[1]);
                this.sessionIdentityAuthOptions = new AuthOptions(this.authApplication);
                break;
            }
            case "userapp": {
                if (splitTokens.length == 1) {
                    throw new IllegalArgumentException("auth " + authType + "= is missing application name");
                }
                this.sessionIdentityAuthOptions = new AuthOptions(AuthUser.createWithLogonName(), new AuthApplication(splitTokens[1]));
                break;
            }
            case "dir": {
                if (splitTokens.length == 1) {
                    throw new IllegalArgumentException("auth " + authType + "= is missing directory property");
                }
                this.sessionIdentityAuthOptions = new AuthOptions(AuthUser.createWithActiveDirectoryProperty(splitTokens[1]));
                break;
            }
            case "manual": {
                String[] params = splitTokens[1].split(",");
                if (params == null || params.length != 3) {
                    throw new IllegalArgumentException("auth " + authType + "= is missing values");
                }
                String appName = params[0];
                String ip2 = params[1];
                String userId = params[2];
                this.sessionIdentityAuthOptions = new AuthOptions(AuthUser.createWithManualOptions(userId, ip2), new AuthApplication(appName));
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong auth option " + authType);
            }
        }
        if (this.clientServerSetup && this.authApplication == null) {
            throw new IllegalArgumentException("Invalid auth option " + value);
        }
    }

    private void parseUserIdIp(String value) {
        String[] splitTokens = value.split(":");
        if (splitTokens.length != 2) {
            throw new IllegalArgumentException("Invalid userId:IP option: " + value);
        }
        this.userIdAndIps.add(new String[]{splitTokens[0], splitTokens[1]});
    }
}

