/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.util;

import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;

public class RequestOptions {
    public static final String REFDATA_SERVICE = "//blp/refdata";
    public static final String INTRADAY_BAR_REQUEST = "IntradayBarRequest";
    public static final String INTRADAY_TICK_REQUEST = "IntradayTickRequest";
    public static final String REFERENCE_DATA_REQUEST = "ReferenceDataRequest";
    public static final String REFERENCE_DATA_REQUEST_OVERRIDE = "ReferenceDataRequestOverride";
    public static final String REFERENCE_DATA_REQUEST_TABLE_OVERRIDE = "ReferenceDataRequestTableOverride";
    public static final String HISTORICAL_DATA_REQUEST = "HistoricalDataRequest";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public String service = "//blp/refdata";
    public final List<String> securities = new ArrayList<String>();
    public final List<String> fields = new ArrayList<String>();
    public final List<String> eventTypes = new ArrayList<String>();
    public final List<Override> overrides = new ArrayList<Override>();
    public int barInterval = 60;
    public boolean gapFillInitialBar = false;
    public String startDateTime;
    public String endDateTime;
    public boolean includeConditionCodes = false;
    public String requestType = "ReferenceDataRequest";
    private String defaultIntradayBarEndDateTime;
    private String defaultIntradayTickEndDateTime;

    public RequestOptions() {
        this.setDefaultStartAndEndTime();
    }

    public RequestOptions(ArgParser argParser) {
        Objects.requireNonNull(argParser, "argParser must not be null");
        this.setDefaultStartAndEndTime();
        ArgGroup argGroupRequest = new ArgGroup("Request Options", new Arg[0]);
        int defaultBarInterval = 5;
        argGroupRequest.add("-s", "--service").setDescription("The service name").setMetaVar("service").setDefaultValue(REFDATA_SERVICE).setAction(value -> {
            this.service = value;
        });
        argGroupRequest.add("-S", "--security").setDescription("Security to request").setMetaVar("security").setMode(ArgMode.MULTIPLE_VALUES).setAction(this.securities::add);
        argGroupRequest.add("-f", "--field").setDescription("Field to request").setMetaVar("field").setMode(ArgMode.MULTIPLE_VALUES).setAction(this.fields::add);
        argGroupRequest.add("-e", "--event").setDescription("Event type").setMetaVar("eventType").setMode(ArgMode.MULTIPLE_VALUES).setDefaultValue("TRADE").setAction(this.eventTypes::add);
        argGroupRequest.add("-i", "--interval").setDescription("Bar interval in minutes").setMetaVar("barInterval").setDefaultValue(String.valueOf(defaultBarInterval)).setAction(value -> {
            this.barInterval = Integer.parseInt(value);
        });
        argGroupRequest.add("-I", "--include-condition-codes").setDescription("Include condition codes").setMode(ArgMode.NO_VALUE).setAction(value -> {
            this.includeConditionCodes = true;
        });
        argGroupRequest.add("-G", "--gap-fill-initial-bar").setDescription("Gap fill initial bar").setMode(ArgMode.NO_VALUE).setAction(value -> {
            this.gapFillInitialBar = true;
        });
        argGroupRequest.add("--start-date").setDescription("Start datetime in the format of yyyy-MM-dd'T'HH:mm:ss").setMetaVar("startDateTime").setAction(value -> {
            this.startDateTime = value;
        });
        argGroupRequest.add("--end-date").setDescription("End datetime in the format of yyyy-MM-dd'T'HH:mm:ss").setMetaVar("endDateTime").setAction(value -> {
            this.endDateTime = value;
        });
        argGroupRequest.add("-O", "--override").setDescription("Field to override").setMetaVar("<fieldId>=<value>").setMode(ArgMode.MULTIPLE_VALUES).setAction(this::appendOverride);
        String eol = System.lineSeparator();
        argGroupRequest.add("-r", "--request").setDescription("Request type." + eol + "To retrieve reference data: " + eol + "\t-r, --request " + REFERENCE_DATA_REQUEST + eol + "\t[-S, --security <security = {IBM US Equity, MSFT US Equity}>]" + eol + "\t[-f, --field <field = PX_LAST>]" + eol + "To retrieve reference data with overrides: " + eol + "\t-r, --request " + REFERENCE_DATA_REQUEST_OVERRIDE + eol + "\t[-S, --security <security = {IBM US Equity, MSFT US Equity}>]" + eol + "\t[-f, --field <field = {PX_LAST, DS002, EQY_WEIGHTED_AVG_PX}>]" + eol + "\t[-O, --override <<fieldId>=<value> = {VWAP_START_TIME=9:30, VWAP_END_TIME=11:30}]" + eol + "To retrieve reference data with table overrides: " + eol + "\t-r, --request " + REFERENCE_DATA_REQUEST_TABLE_OVERRIDE + eol + "\t[-S, --security <security = FHR 3709 FA Mtge>]" + eol + "\t[-f, --field <field = {MTG_CASH_FLOW, SETTLE_DT}>]" + eol + "To retrieve intraday bars: " + eol + "\t-r, --request " + INTRADAY_BAR_REQUEST + eol + "\t[-S, --security <security = IBM US Equity>]" + eol + "\t[-e, --event <event = TRADE>]" + eol + "\t[-i, --interval <barInterval = " + defaultBarInterval + ">]" + eol + "\t[--start-date <startDateTime = " + this.startDateTime + ">]" + eol + "\t[--end-date <endDateTime = " + this.defaultIntradayBarEndDateTime + ">]" + eol + "\t[-G, --gap-fill-initial-bar]" + eol + "\t\t1) All times are in GMT." + eol + "\t\t2) Only one security can be specified." + eol + "\t\t3) Only one event can be specified." + eol + "To retrieve intraday raw ticks: " + eol + "\t-r, --request " + INTRADAY_TICK_REQUEST + eol + "\t[-S, --security <security = IBM US Equity>]" + eol + "\t[-e, --event <event = TRADE>]" + eol + "\t[--start-date <startDateTime = " + this.startDateTime + ">]" + eol + "\t[--end-date <endDateTime = " + this.defaultIntradayTickEndDateTime + ">]" + eol + "\t[-I, --include-condition-codes]" + eol + "\t\t1) All times are in GMT." + eol + "\t\t2) Only one security can be specified." + eol + "To retrieve historical data: " + eol + "\t-r, --request " + HISTORICAL_DATA_REQUEST + eol + "\t[-S, --security <security = {IBM US Equity, MSFT US Equity}>]" + eol + "\t[-f, --field <field = PX_LAST>]" + eol).setMetaVar("requestType").setDefaultValue(REFERENCE_DATA_REQUEST).setChoices(REFERENCE_DATA_REQUEST, REFERENCE_DATA_REQUEST_OVERRIDE, REFERENCE_DATA_REQUEST_TABLE_OVERRIDE, INTRADAY_BAR_REQUEST, INTRADAY_TICK_REQUEST, HISTORICAL_DATA_REQUEST).setAction(value -> {
            this.requestType = value;
        });
        argParser.addGroup(argGroupRequest);
    }

    private void setDefaultStartAndEndTime() {
        Calendar calendar = RequestOptions.getPreviousTradingDate();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        this.startDateTime = sdf.format(calendar.getTime());
        calendar.add(12, 5);
        this.defaultIntradayTickEndDateTime = sdf.format(calendar.getTime());
        calendar.add(12, 55);
        this.defaultIntradayBarEndDateTime = sdf.format(calendar.getTime());
    }

    private static Calendar getPreviousTradingDate() {
        Calendar previousTradingDate = Calendar.getInstance();
        previousTradingDate.roll(5, -1);
        int dayOfWeek = previousTradingDate.get(7);
        if (dayOfWeek == 1) {
            previousTradingDate.roll(5, -2);
        } else if (dayOfWeek == 7) {
            previousTradingDate.roll(5, -1);
        }
        previousTradingDate.set(11, 14);
        previousTradingDate.set(12, 30);
        previousTradingDate.set(13, 0);
        return previousTradingDate;
    }

    private void appendOverride(String overrideStr) {
        String[] fieldIdAndValue = overrideStr.split("=");
        if (fieldIdAndValue.length != 2) {
            throw new IllegalArgumentException("Invalid override " + overrideStr);
        }
        this.overrides.add(new Override(fieldIdAndValue[0], fieldIdAndValue[1]));
    }

    public void setDefaultValues() {
        if (this.securities.isEmpty()) {
            if (this.requestType.equals(REFERENCE_DATA_REQUEST_TABLE_OVERRIDE)) {
                this.securities.add("FHR 3709 FA Mtge");
            } else {
                this.securities.add("IBM US Equity");
                this.securities.add("MSFT US Equity");
            }
        }
        if (this.fields.isEmpty()) {
            if (this.requestType.equals(REFERENCE_DATA_REQUEST_TABLE_OVERRIDE)) {
                this.fields.add("MTG_CASH_FLOW");
                this.fields.add("SETTLE_DT");
            } else {
                this.fields.add("PX_LAST");
                if (this.requestType.equals(REFERENCE_DATA_REQUEST_OVERRIDE)) {
                    this.fields.add("DS002");
                    this.fields.add("EQY_WEIGHTED_AVG_PX");
                }
            }
        }
        if (this.overrides.isEmpty() && this.requestType.equals(REFERENCE_DATA_REQUEST_OVERRIDE)) {
            this.overrides.addAll(Arrays.asList(new Override("VWAP_START_TIME", "9:30"), new Override("VWAP_END_TIME", "11:30")));
        }
        if (this.endDateTime == null) {
            this.endDateTime = this.requestType.equals(INTRADAY_BAR_REQUEST) ? this.defaultIntradayBarEndDateTime : this.defaultIntradayTickEndDateTime;
        }
    }

    public static class Override {
        public String fieldId;
        public String value;

        public Override(String fieldId, String value) {
            this.fieldId = fieldId;
            this.value = value;
        }
    }
}

