/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.util;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.Subscription;
import com.bloomberglp.blpapi.SubscriptionList;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class SubscriptionOptions {
    static final String DEFAULT_SERVICE = "//blp/mktdata";
    static final String DEFAULT_TOPIC_PREFIX = "/ticker/";
    private static final String DEFAULT_TOPIC = "IBM US Equity";
    public String service;
    public final List<String> fields = new ArrayList<String>();
    private final List<String> topics = new ArrayList<String>();
    private final List<String> options = new ArrayList<String>();
    private String topicPrefix;

    private SubscriptionOptions(ArgParser argParser, boolean isSnapshot) {
        String eol = System.lineSeparator();
        Arg argService = new Arg("-s", "--service").setMetaVar("service").setDescription("service name").setDefaultValue(DEFAULT_SERVICE).setAction(value -> {
            this.service = value;
        });
        Arg argTopic = new Arg("-t", "--topic").setMetaVar("topic").setDescription("Topic to subscribe. " + eol + "Can be one of the following:" + eol + "* Instrument" + eol + "* Instrument qualified with a prefix" + eol + "* Instrument qualified with a service and a prefix").setDefaultValue(DEFAULT_TOPIC).setMode(ArgMode.MULTIPLE_VALUES).setAction(this.topics::add);
        Arg argField = new Arg("-f", "--field").setMetaVar("field").setDescription("field to subscribe").setMode(ArgMode.MULTIPLE_VALUES).setAction(this.fields::add);
        Arg argOption = new Arg("-o", "--option").setMetaVar("option").setDescription("subscription options").setMode(ArgMode.MULTIPLE_VALUES).setAction(this.options::add);
        Arg argTopicPrefix = new Arg("-x", "--topic-prefix").setMetaVar("prefix").setDescription("The topic prefix to be used for subscriptions").setDefaultValue(DEFAULT_TOPIC_PREFIX).setAction(value -> {
            this.topicPrefix = value;
        });
        ArgGroup groupSubscription = new ArgGroup("Subscriptions", argService, argTopic, argField, argOption, argTopicPrefix);
        if (!isSnapshot) {
            Arg argInterval = new Arg("-i", "--interval").setDescription("subscription option that specifies a time in seconds to intervalize the subscriptions").setAction(this::parseInterval);
            groupSubscription.add(argInterval);
        }
        argParser.addGroup(groupSubscription);
    }

    public SubscriptionOptions(ArgParser argParser) {
        this(argParser, false);
    }

    public static SubscriptionOptions forSnapshot(ArgParser argParser) {
        return new SubscriptionOptions(argParser, true);
    }

    private void parseInterval(String value) {
        double interval;
        try {
            interval = Double.parseDouble(value);
        }
        catch (NumberFormatException ex2) {
            throw new IllegalArgumentException("Invalid interval " + value, ex2);
        }
        this.options.add("interval=" + interval);
    }

    public SubscriptionList createSubscriptionList(BiFunction<Integer, String, CorrelationID> correlationIdGenerator) {
        SubscriptionList subscriptions = new SubscriptionList();
        for (int i2 = 0; i2 < this.topics.size(); ++i2) {
            String topic = this.topics.get(i2);
            Subscription subscription = new Subscription(topic, this.fields, this.options, correlationIdGenerator.apply(i2, topic));
            subscriptions.add(subscription);
        }
        return subscriptions;
    }

    public Map<String, String> createSubscriptionStrings() {
        HashMap<String, String> subStrings = new HashMap<String, String>();
        for (String userTopic : this.topics) {
            Subscription sub = new Subscription(userTopic, this.fields, this.options);
            subStrings.put(userTopic, sub.subscriptionString());
        }
        return subStrings;
    }

    public void setSessionOptions(SessionOptions sessionOptions) {
        sessionOptions.setDefaultSubscriptionService(this.service);
        sessionOptions.setDefaultTopicPrefix(this.topicPrefix);
    }
}

