/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.util.argparser;

import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArgParser {
    private final ArgGroup argGroupGeneral;
    private final String title;
    private final Class<?> exampleClass;
    private final List<Arg> args = new ArrayList<Arg>();
    private final Map<String, Integer> argIndices = new HashMap<String, Integer>();
    private final List<ArgGroup> argGroups = new ArrayList<ArgGroup>();
    private Map<Integer, List<String>> values = new HashMap<Integer, List<String>>();

    public ArgParser(String title, Class<?> exampleClass) {
        Objects.requireNonNull(title, "title must not be null");
        Objects.requireNonNull(exampleClass, "exampleClass must not be null");
        this.title = title;
        this.exampleClass = exampleClass;
        Arg argHelp = new Arg("-h", "--help").setDescription("Show this help message and exit").setMode(ArgMode.NO_VALUE).setAction(value -> {
            this.printHelp();
            System.exit(0);
        });
        this.argGroupGeneral = new ArgGroup("General", argHelp);
        this.addGroup(this.argGroupGeneral);
    }

    public Arg addArg(String ... forms) {
        Arg arg = new Arg(forms);
        this.validateAndAdd(arg);
        this.argGroupGeneral.add(arg);
        return arg;
    }

    public ArgParser addGroup(ArgGroup group) {
        if (group.getArgs().isEmpty()) {
            throw new IllegalArgumentException("No arguments are defined in group " + group);
        }
        group.getArgs().forEach(this::validateAndAdd);
        this.argGroups.add(group);
        return this;
    }

    public void parse(String[] cmdLineArgs) {
        for (int i2 = 0; i2 < cmdLineArgs.length; ++i2) {
            String option = cmdLineArgs[i2];
            Integer index = this.argIndices.get(option);
            if (index == null) {
                throw new IllegalArgumentException("Unknown argument " + option);
            }
            Arg arg = this.args.get(index);
            List argValues = this.values.computeIfAbsent(index, k2 -> new ArrayList());
            ArgMode argMode = arg.getMode();
            if (!argMode.allowMultipleValues() && !argValues.isEmpty()) {
                throw new IllegalArgumentException("Option " + arg + " must be specified only once.");
            }
            String value = null;
            if (argMode.requiresValue()) {
                if (i2 + 1 == cmdLineArgs.length) {
                    throw new IllegalArgumentException("Option " + arg + " is missing a value");
                }
                if (!arg.isValidChoice(value = cmdLineArgs[++i2])) {
                    throw new IllegalArgumentException("Option " + arg + ": invalid choice '" + value + "' (choose from " + arg.getChoices() + ")");
                }
            }
            argValues.add(value);
            if (arg.getAction() == null) continue;
            arg.getAction().accept(value);
        }
        for (int index = 0; index < this.args.size(); ++index) {
            List<String> argValues = this.values.get(index);
            if (argValues != null && !argValues.isEmpty()) continue;
            Arg arg = this.args.get(index);
            String defaultValue = arg.getDefaultValue();
            if (defaultValue == null) {
                if (!arg.isRequired()) continue;
                throw new IllegalArgumentException("Missing option " + arg);
            }
            argValues = new ArrayList<String>();
            this.values.put(index, argValues);
            argValues.add(defaultValue);
            if (arg.getAction() == null) continue;
            arg.getAction().accept(defaultValue);
        }
    }

    private void validateAndAdd(Arg arg) {
        if (this.argIndices.containsKey(arg.getShortForm()) || this.argIndices.containsKey(arg.getLongForm())) {
            throw new IllegalArgumentException("Argument " + arg + " already exists");
        }
        int index = this.args.size();
        this.args.add(arg);
        if (arg.getShortForm() != null) {
            this.argIndices.put(arg.getShortForm(), index);
        }
        if (arg.getLongForm() != null) {
            this.argIndices.put(arg.getLongForm(), index);
        }
    }

    public void printHelp() {
        PrintWriter pw = new PrintWriter(System.out);
        this.printHelp(pw);
        pw.flush();
    }

    public void printHelp(PrintWriter pw) {
        pw.println(this.title);
        pw.println("Usage: java " + this.exampleClass.getName() + " [-h|--help] [options]");
        for (ArgGroup group : this.argGroups) {
            pw.println();
            group.printHelp(pw);
        }
    }
}

