/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.impl.infr.util.e;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public final class Datetime
implements Cloneable {
    public static final short YEAR = 128;
    public static final byte MONTH = 64;
    public static final byte DAY_OF_MONTH = 32;
    public static final byte HOUR = 16;
    public static final byte MINUTE = 8;
    public static final byte SECOND = 4;
    public static final byte MILLISECOND = 2;
    public static final byte TIME_ZONE_OFFSET = 1;
    public static final short DATE = 224;
    public static final short TIME = 28;
    public static final short TIMEMILLI = 30;
    public static final short MICROSECOND = 258;
    public static final short NANOSECOND = 770;
    public static final short PICOSECOND = 1794;
    private int m;
    private short[] n;
    private Calendar o;
    private long p;
    private int q = 1000;
    private int r = 1000000;
    private long s = 1000000000L;

    public Datetime() {
        this.f();
    }

    public Datetime(Datetime datetime) {
        this.f();
        this.o = null;
        this.m = datetime.m;
        this.p = datetime.p;
        System.arraycopy(datetime.n, 0, this.n, 0, this.n.length);
    }

    public Datetime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.f();
        this.setDatetime(n2, n3, n4, n5, n6, n7, n8);
    }

    public Datetime(int n2, int n3, int n4) {
        this.f();
        this.setDate(n2, n3, n4);
    }

    public Datetime(int n2, int n3, int n4, int n5) {
        this.f();
        this.setTime(n2, n3, n4, n5);
    }

    public Datetime(Calendar calendar) {
        this.f();
        this.setDatetimeTz(calendar);
    }

    private void f() {
        this.n = new short[8];
        this.clear();
    }

    public int year() {
        return this.n[0];
    }

    public int month() {
        return this.n[1];
    }

    public int dayOfMonth() {
        return this.n[2];
    }

    public int hour() {
        return this.n[3];
    }

    public int minute() {
        return this.n[4];
    }

    public int second() {
        return this.n[5];
    }

    public int milliSecond() {
        return this.millisecond();
    }

    public int millisecond() {
        return this.n[6];
    }

    public int microsecond() {
        return (int)((this.p + (long)this.millisecond() * 1000000000L) / 1000000L);
    }

    public int nanosecond() {
        return (int)((this.p + (long)this.millisecond() * 1000000000L) / 1000L);
    }

    public long picosecond() {
        return this.p + (long)this.millisecond() * 1000000000L;
    }

    public int timezoneOffsetMinutes() {
        return this.n[7];
    }

    public Calendar calendar() {
        if (this.o == null) {
            this.o = Calendar.getInstance();
        }
        this.o.clear();
        if (this.hasParts(128)) {
            this.o.set(1, this.n[0]);
        }
        if (this.hasParts(64)) {
            this.o.set(2, this.n[1] - 1);
        }
        if (this.hasParts(32)) {
            this.o.set(5, this.n[2]);
        }
        if (this.hasParts(16)) {
            this.o.set(11, this.n[3]);
        }
        if (this.hasParts(8)) {
            this.o.set(12, this.n[4]);
        }
        if (this.hasParts(4)) {
            this.o.set(13, this.n[5]);
        }
        if (this.hasParts(2)) {
            this.o.set(14, this.n[6]);
        }
        if (this.hasParts(1)) {
            if (this.n[7] == 0) {
                this.o.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                Calendar calendar = Calendar.getInstance();
                TimeZone timeZone = calendar.getTimeZone();
                Calendar calendar2 = this.hasParts(128) ? this.o : calendar;
                int n2 = ((calendar2.get(11) * 60 + calendar2.get(12)) * 60 + calendar2.get(13)) * 1000 + calendar2.get(14);
                int n3 = timeZone.getOffset(calendar2.get(0), calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(7), n2) / 60000;
                if (n3 != this.n[7]) {
                    this.o.setTimeZone(TimeZone.getTimeZone("GMT"));
                    if (this.hasParts(16)) {
                        this.o.setTimeInMillis(this.o.getTimeInMillis() + (long)(this.n[7] * 60 * 1000));
                    }
                }
            }
        }
        return this.o;
    }

    @Deprecated
    public boolean isValidField(int n2) {
        return this.hasParts(n2);
    }

    public int parts() {
        return this.m;
    }

    public boolean hasParts(int n2) {
        return n2 == (this.m & n2);
    }

    public boolean isValid() {
        if ((this.hasParts(128) || this.hasParts(64) || this.hasParts(32)) && !this.g()) {
            return false;
        }
        return !this.hasParts(16) && !this.hasParts(8) && !this.hasParts(4) && !this.hasParts(2) || this.h();
    }

    public void setDatetime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.setYear(n2);
        this.setMonth(n3);
        this.setDayOfMonth(n4);
        this.setHour(n5);
        this.setMinute(n6);
        this.setSecond(n7);
        this.setMillisecond(n8);
    }

    public void setDatetimeTz(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setDatetime(n2, n3, n4, n5, n6, n7, n8);
        this.setTimezoneOffsetMinutes(n9);
    }

    public void setDate(int n2, int n3, int n4) {
        this.setYear(n2);
        this.setMonth(n3);
        this.setDayOfMonth(n4);
    }

    public void setDateTz(int n2, int n3, int n4, int n5) {
        this.setDate(n2, n3, n4);
        this.setTimezoneOffsetMinutes(n5);
    }

    public void setTime(int n2, int n3, int n4, int n5) {
        this.setHour(n2);
        this.setMinute(n3);
        this.setSecond(n4);
        this.setMillisecond(n5);
    }

    public void setTimeTz(int n2, int n3, int n4, int n5, int n6) {
        this.setTime(n2, n3, n4, n5);
        this.setTimezoneOffsetMinutes(n6);
    }

    public void setDatetimeTz(Calendar calendar) {
        this.setDatetime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        int n2 = ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
        int n3 = calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), n2) / 60000;
        this.setTimezoneOffsetMinutes(n3);
    }

    public void setYear(int n2) {
        this.n[0] = (short)n2;
        this.m |= 0x80;
    }

    public void setMonth(int n2) {
        this.n[1] = (byte)n2;
        this.m |= 0x40;
    }

    public void setDayOfMonth(int n2) {
        this.n[2] = (byte)n2;
        this.m |= 0x20;
    }

    public void setHour(int n2) {
        this.n[3] = (byte)n2;
        this.m |= 0x10;
    }

    public void setMinute(int n2) {
        this.n[4] = (byte)n2;
        this.m |= 8;
    }

    public void setSecond(int n2) {
        this.n[5] = (byte)n2;
        this.m |= 4;
    }

    public void setMilliSecond(int n2) {
        this.setMillisecond(n2);
    }

    public void setMillisecond(int n2) {
        this.n[6] = (short)n2;
        this.m |= 2;
    }

    public void setMicrosecond(int n2) {
        this.setMillisecond(n2 / this.q % 1000);
        this.p = (long)(n2 % 1000) * 1000000L;
        this.m |= 0x102;
    }

    public void setNanosecond(int n2) {
        this.setMillisecond(n2 / this.r % 1000);
        this.p = (long)n2 % 1000000L * 1000L;
        this.m |= 0x302;
    }

    public void setPicosecond(long l2) {
        this.setMillisecond((int)(l2 / this.s % 1000L));
        this.p = l2 % 1000000000L;
        this.m |= 0x702;
    }

    public void setTimezoneOffsetMinutes(int n2) {
        this.n[7] = (short)n2;
        this.m |= 1;
    }

    public void clear() {
        this.m = 0;
        this.n[0] = 1;
        this.n[1] = 1;
        this.n[2] = 1;
        this.n[3] = 24;
        this.n[4] = 0;
        this.n[5] = 0;
        this.n[6] = 0;
        this.n[7] = 0;
        this.o = null;
        this.p = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Datetime) {
            Datetime datetime = (Datetime)object;
            if ((this.m & 0xFF) == (datetime.m & 0xFF) && Arrays.equals(this.n, datetime.n) && this.p == datetime.p) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return new Datetime(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        char c2 = '\u0000';
        if (this.hasParts(128) || this.hasParts(64) || this.hasParts(32)) {
            stringBuilder.append(e.j(this));
            c2 = 'T';
        }
        if (this.hasParts(16) || this.hasParts(8) || this.hasParts(4) || this.hasParts(2)) {
            if (c2 != '\u0000') {
                stringBuilder.append(c2);
            }
            stringBuilder.append(e.l(this));
        }
        if (this.hasParts(1)) {
            e.g(stringBuilder, this);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        Long l2 = new Long((long)(this.n[0] + this.n[1] + this.n[2] * 3600000 + this.n[3] * 3600000 + this.n[4] * 60000 + this.n[5] * 1000 + this.n[6] + this.n[7]) + this.p);
        return l2.hashCode();
    }

    private boolean a(int n2) {
        return 0 == n2 % 4 && (n2 <= 1752 || 0 != n2 % 100 || 0 == n2 % 400);
    }

    private boolean g() {
        int n2 = this.year();
        int n3 = this.month();
        int n4 = this.dayOfMonth();
        if (n2 <= 0 || n2 > 9999 || n3 <= 0 || n3 > 12 || n4 <= 0 || n4 > 31) {
            return false;
        }
        if (n2 == 1752 && n3 == 9 && n4 > 2 && n4 < 14) {
            return false;
        }
        if (n4 < 29) {
            return true;
        }
        switch (n3) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return true;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return n4 <= 30;
            }
            case 2: {
                if (this.a(n2)) {
                    return n4 <= 29;
                }
                return n4 <= 28;
            }
        }
        return true;
    }

    private boolean h() {
        int n2 = this.hour();
        int n3 = this.minute();
        int n4 = this.second();
        long l2 = this.picosecond();
        if (n2 == 24) {
            return n3 == 0 && n4 == 0 && l2 == 0L;
        }
        return n2 >= 0 && n2 < 24 && n3 >= 0 && n3 < 60 && n4 >= 0 && n4 < 60 && l2 >= 0L && l2 < 1000000000000L;
    }
}

