/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi.impl;

import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapi.impl.kG;
import com.bloomberglp.blpapi.impl.kH;
import com.bloomberglp.blpapi.impl.kf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class bj
extends TlsOptions {
    private static final kG M = kH.bC("TlsOptionsImpl");
    private final SSLContext sa;
    private final KeyStore sb;
    private final KeyStore sc;
    private int sd;
    private int se;

    private static void a(Object object, String string) {
        if (object == null) {
            M.c("Parameter %1$s has null value", string);
            throw new NullPointerException(string + " must have a non-null value");
        }
    }

    private bj(SSLContext sSLContext, KeyStore keyStore, KeyStore keyStore2) {
        this.sa = sSLContext;
        this.sb = keyStore;
        this.sc = keyStore2;
        this.sd = 10000;
        this.se = 20000;
    }

    private static KeyStore a(InputStream inputStream, char[] cArray) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, TlsOptions.TlsInitializationException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(inputStream, cArray);
        Enumeration<String> enumeration = keyStore.aliases();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new TlsOptions.TlsInitializationException("provided client credentials don't have a secret key");
        }
        return keyStore;
    }

    private static KeyStore b(InputStream inputStream) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, TlsOptions.TlsInitializationException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
        if (collection.isEmpty()) {
            throw new TlsOptions.TlsInitializationException("no trusted certificates");
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        int n2 = 0;
        for (X509Certificate x509Certificate : collection) {
            x509Certificate.checkValidity();
            String string = x509Certificate.getSubjectX500Principal().getName();
            String string2 = String.format("%s%d", string, n2++);
            keyStore.setCertificateEntry(string2, x509Certificate);
        }
        return keyStore;
    }

    private static SSLContext a(KeyStore keyStore, char[] cArray, KeyStore keyStore2) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException, KeyManagementException {
        char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
        String string = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string);
        M.e("Using algorithm %1$s for KeyManagerFactory", keyManagerFactory.getAlgorithm());
        keyManagerFactory.init(keyStore, cArray2);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(keyStore2);
        SSLContext sSLContext = SSLContext.getInstance(kf.tP());
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    private static List<X509Certificate> a(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            return null;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (!(certificate instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)certificate;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    public static bj a(InputStream inputStream, char[] cArray, InputStream inputStream2) throws TlsOptions.TlsInitializationException {
        try {
            KeyStore keyStore = bj.a(inputStream, cArray);
            KeyStore keyStore2 = bj.b(inputStream2);
            return new bj(bj.a(keyStore, cArray, keyStore2), keyStore, keyStore2);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            M.b("Got UnrecoverableKeyException: %1$s", (Object)unrecoverableKeyException.getMessage(), unrecoverableKeyException);
            throw new TlsOptions.TlsInitializationException(unrecoverableKeyException.getMessage(), unrecoverableKeyException);
        }
        catch (KeyManagementException keyManagementException) {
            M.b("Got KeyManagementException: %1$s", (Object)keyManagementException.getMessage(), keyManagementException);
            throw new TlsOptions.TlsInitializationException(keyManagementException.getMessage(), keyManagementException);
        }
        catch (CertificateException certificateException) {
            M.b("Got CertificateException: %1$s", (Object)certificateException.getMessage(), certificateException);
            throw new TlsOptions.TlsInitializationException(certificateException.getMessage(), certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            M.b("Got KeyStoreException: %1$s", (Object)keyStoreException.getMessage(), keyStoreException);
            throw new TlsOptions.TlsInitializationException(keyStoreException.getMessage(), keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            M.b("Got NoSuchAlgorithmException: %1$s", (Object)noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            throw new TlsOptions.TlsInitializationException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            M.b("Got IOException: %1$s", (Object)iOException.getMessage(), iOException);
            throw new TlsOptions.TlsInitializationException(iOException.getMessage(), iOException);
        }
    }

    public static bj a(String string, char[] cArray, String string2) throws TlsOptions.TlsInitializationException {
        M.bu("Creating TlsOptions from files");
        bj.a(string, "clientCredentialsFileName");
        bj.a(cArray, "clientCredentialsPassword");
        bj.a(string2, "trustedCertificatesFileName");
        File file = new File(string);
        if (file.length() > 0x6400000L) {
            throw new IllegalArgumentException("Client credentials file mustn't be larger than 100 MB");
        }
        File file2 = new File(string2);
        if (file2.length() > 0x6400000L) {
            throw new IllegalArgumentException("Trusted certificates file musn't be larger than 100 MB");
        }
        FileInputStream fileInputStream = null;
        InputStream inputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStream = new FileInputStream(file2);
            bj bj2 = bj.a(fileInputStream, cArray, inputStream);
            return bj2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            M.b("Got FileNotFoundException: %1$s", (Object)fileNotFoundException.getMessage(), fileNotFoundException);
            throw new TlsOptions.TlsInitializationException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    M.b("Failed to close client credentials file: %1$s", (Object)iOException.getMessage(), iOException);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    M.b("Failed to close trusted certificates file: %1$s", (Object)iOException.getMessage(), iOException);
                }
            }
        }
    }

    public static bj a(SSLContext sSLContext) {
        M.bu("Creating TlsOptions from SSLContext");
        bj.a(sSLContext, "sslContext");
        return new bj(sSLContext, null, null);
    }

    @Override
    public SSLContext getSslContext() {
        return this.sa;
    }

    @Override
    public int getTlsHandshakeTimeout() {
        return this.sd;
    }

    @Override
    public void setTlsHandshakeTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("TLSTimeout must be positive value");
        }
        this.sd = n2;
    }

    @Override
    public int getCrlTimeout() {
        return this.se;
    }

    @Override
    public void setCrlTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("CrlTimeout must be positive value");
        }
        this.se = n2;
    }

    public List<X509Certificate> gS() throws KeyStoreException {
        return bj.a(this.sc);
    }
}

