/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventFormatter;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.ProviderEventHandler;
import com.bloomberglp.blpapi.ProviderSession;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Topic;
import com.bloomberglp.blpapi.TopicList;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.MaxEventsOption;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ContributionsExample {
    private static final String DEFAULT_MKT_DATA_TOPIC = "/ticker/AUDEUR Curncy";
    private static final String DEFAULT_PAGE_DATA_TOPIC = "/page/220/660/1";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final Name MKT_DATA = Name.getName("MarketData");
    private static final Name BID = Name.getName("BID");
    private static final Name ASK = Name.getName("ASK");
    private static final Name BID_SIZE = Name.getName("BID_SIZE");
    private static final Name ASK_SIZE = Name.getName("ASK_SIZE");
    private static final Name PAGE_DATA = Name.getName("PageData");
    private static final Name ROW_UPDATE = Name.getName("rowUpdate");
    private static final Name ROW_NUM = Name.getName("rowNum");
    private static final Name SPAN_UPDATE = Name.getName("spanUpdate");
    private static final Name START_COL = Name.getName("startCol");
    private static final Name LENGTH = Name.getName("length");
    private static final Name TEXT = Name.getName("text");
    private static final Name ATTR = Name.getName("attr");
    private static final Name CONTRIBUTION_ID = Name.getName("contributorId");
    private static final Name PRODUCT_CODE = Name.getName("productCode");
    private static final Name PAGE_NUMBER = Name.getName("pageNumber");
    private String serviceName = "//blp/mpfbapi";
    private String topic = null;
    private volatile boolean running = true;
    private boolean isPageEnabled = false;
    private int contributionId = 8563;
    private ConnectionAndAuthOptions connectionAndAuthOptions;
    private MaxEventsOption maxEventsOption;

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Contribute market or page data to a topic", ContributionsExample.class);
        this.connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        this.maxEventsOption = new MaxEventsOption(argParser);
        ArgGroup argGroupContribution = new ArgGroup("Contribution Options", new Arg[0]);
        argGroupContribution.add("-s", "--service").setDescription("service name").setMetaVar("service").setDefaultValue(this.serviceName).setAction(value -> {
            this.serviceName = value;
        });
        argGroupContribution.add("-t", "--topic").setDescription("topic to contribute (mktdata default: '/ticker/AUDEUR Curncy', page default: '/page/220/660/1')").setMetaVar("topic").setAction(value -> {
            this.topic = value;
        });
        argGroupContribution.add("-C", "--contribution-id").setDescription("contributor id. Ignored unless page is enabled").setMetaVar("contributionId").setDefaultValue(String.valueOf(this.contributionId)).setAction(value -> {
            this.contributionId = Integer.parseInt(value);
        });
        argGroupContribution.add("-P", "--page").setDescription("enable page contributions").setMode(ArgMode.NO_VALUE).setAction(value -> {
            this.isPageEnabled = true;
        });
        argParser.addGroup(argGroupContribution);
        argParser.parse(args);
        if (this.topic == null || this.topic.isEmpty()) {
            this.topic = this.isPageEnabled ? DEFAULT_PAGE_DATA_TOPIC : DEFAULT_MKT_DATA_TOPIC;
        } else if (this.topic.charAt(0) != '/') {
            this.topic = "/" + this.topic;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws Exception {
        if (!this.parseCommandLine(args)) {
            return;
        }
        ProviderSession session = new ProviderSession(this.connectionAndAuthOptions.createSessionOption("Contributions"), new MyEventHandler());
        try {
            if (!session.start()) {
                System.err.println("Failed to start session");
                return;
            }
            TopicList topicList = new TopicList();
            topicList.add(this.serviceName + this.topic, new CorrelationID(this.topic));
            session.createTopics(topicList, ProviderSession.ResolveMode.AUTO_REGISTER_SERVICES);
            Service service = session.getService(this.serviceName);
            if (service == null) {
                System.err.println("Open service failed: " + this.serviceName);
                return;
            }
            if (topicList.statusAt(0) != TopicList.Status.CREATED) {
                System.err.println("Topic " + this.serviceName + this.topic + " not created.");
                return;
            }
            Topic topicObj = session.getTopic(topicList.messageAt(0));
            int iteration = 0;
            while (iteration++ < this.maxEventsOption.getMaxEvents()) {
                if (!this.running) {
                    break;
                }
                Event event = service.createPublishEvent();
                EventFormatter eventFormatter = new EventFormatter(event);
                if (this.isPageEnabled) {
                    this.formatPageDataEvent(eventFormatter, topicObj);
                } else {
                    ContributionsExample.formatMktDataEvent(eventFormatter, topicObj, iteration);
                }
                System.out.println(TIME_FORMAT.format(new Date()) + " -");
                System.out.println("Publishing event: " + event);
                session.publish(event);
                Thread.sleep(10000L);
            }
        }
        finally {
            session.stop();
        }
    }

    private void formatPageDataEvent(EventFormatter eventFormatter, Topic topic) {
        eventFormatter.appendMessage(PAGE_DATA, topic);
        eventFormatter.pushElement(ROW_UPDATE);
        eventFormatter.appendElement();
        eventFormatter.setElement(ROW_NUM, 1);
        eventFormatter.pushElement(SPAN_UPDATE);
        eventFormatter.appendElement();
        eventFormatter.setElement(START_COL, 20);
        eventFormatter.setElement(LENGTH, 4);
        eventFormatter.setElement(TEXT, "TEST");
        eventFormatter.setElement(ATTR, "INTENSIFY");
        eventFormatter.popElement();
        eventFormatter.appendElement();
        eventFormatter.setElement(START_COL, 25);
        eventFormatter.setElement(LENGTH, 4);
        eventFormatter.setElement(TEXT, "PAGE");
        eventFormatter.setElement(ATTR, "BLINK");
        eventFormatter.popElement();
        eventFormatter.appendElement();
        eventFormatter.setElement(START_COL, 30);
        String timestamp = TIME_FORMAT.format(new Date());
        eventFormatter.setElement(LENGTH, timestamp.length());
        eventFormatter.setElement(TEXT, timestamp);
        eventFormatter.setElement(ATTR, "REVERSE");
        eventFormatter.popElement();
        eventFormatter.popElement();
        eventFormatter.popElement();
        eventFormatter.appendElement();
        eventFormatter.setElement(ROW_NUM, 2);
        eventFormatter.pushElement(SPAN_UPDATE);
        eventFormatter.appendElement();
        eventFormatter.setElement(START_COL, 20);
        eventFormatter.setElement(LENGTH, 9);
        eventFormatter.setElement(TEXT, "---------");
        eventFormatter.setElement(ATTR, "UNDERLINE");
        eventFormatter.popElement();
        eventFormatter.popElement();
        eventFormatter.popElement();
        eventFormatter.appendElement();
        eventFormatter.setElement(ROW_NUM, 3);
        eventFormatter.pushElement(SPAN_UPDATE);
        eventFormatter.appendElement();
        eventFormatter.setElement(START_COL, 10);
        eventFormatter.setElement(LENGTH, 9);
        eventFormatter.setElement(TEXT, "TEST LINE");
        eventFormatter.popElement();
        eventFormatter.appendElement();
        eventFormatter.setElement(START_COL, 23);
        eventFormatter.setElement(LENGTH, 5);
        eventFormatter.setElement(TEXT, "THREE");
        eventFormatter.popElement();
        eventFormatter.popElement();
        eventFormatter.popElement();
        eventFormatter.popElement();
        eventFormatter.setElement(CONTRIBUTION_ID, this.contributionId);
        eventFormatter.setElement(PRODUCT_CODE, 1);
        eventFormatter.setElement(PAGE_NUMBER, 1);
    }

    private static void formatMktDataEvent(EventFormatter eventFormatter, Topic topic, int value) {
        eventFormatter.appendMessage(MKT_DATA, topic);
        eventFormatter.setElement(BID, 0.5 * (double)value);
        eventFormatter.setElement(ASK, value);
        eventFormatter.setElement(BID_SIZE, 1200 + value);
        eventFormatter.setElement(ASK_SIZE, 1400 + value);
    }

    public static void main(String[] args) {
        ContributionsExample example = new ContributionsExample();
        try {
            example.run(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    class MyEventHandler
    implements ProviderEventHandler {
        MyEventHandler() {
        }

        @Override
        public void processEvent(Event event, ProviderSession session) {
            for (Message msg : event) {
                System.out.println("Message = " + msg);
                Name messageType = msg.messageType();
                if (event.eventType() != Event.EventType.SESSION_STATUS || !messageType.equals(Names.SESSION_TERMINATED) && !messageType.equals(Names.SESSION_STARTUP_FAILURE)) continue;
                ContributionsExample.this.running = false;
            }
        }
    }
}

