/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse.ReferenceDataRequests;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.RequestOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;
import java.util.Arrays;

public class MultipleRequestsOverrideExample {
    public static void main(String[] args) {
        try {
            MultipleRequestsOverrideExample.run(args);
            System.out.println("Press ENTER to quit");
            System.in.read();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        ArgParser argParser = new ArgParser("Multiple requests with override example", MultipleRequestsOverrideExample.class);
        ConnectionAndAuthOptions connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        try {
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return;
        }
        Session session = new Session(connectionAndAuthOptions.createSessionOption("Requester"));
        try {
            if (!session.start()) {
                System.err.println("Failed to connect!");
                return;
            }
            if (!session.openService("//blp/refdata")) {
                System.err.println("Failed to open //blp/refdata");
                return;
            }
            Service refDataService = session.getService("//blp/refdata");
            RequestOptions options = new RequestOptions();
            options.securities.addAll(Arrays.asList("IBM US Equity", "MSFT US Equity"));
            options.fields.addAll(Arrays.asList("PX_LAST", "DS002"));
            String fieldIdVwapStartTime = "VWAP_START_TIME";
            String fieldIdVwapEndTime = "VWAP_END_TIME";
            String startTime1 = "9:30";
            String endTime1 = "11:30";
            options.overrides.addAll(Arrays.asList(new RequestOptions.Override(fieldIdVwapStartTime, startTime1), new RequestOptions.Override(fieldIdVwapEndTime, endTime1)));
            Request request1 = ReferenceDataRequests.createRequest(refDataService, options);
            System.out.println("Sending request 1: " + request1);
            CorrelationID correlationId1 = new CorrelationID("request 1");
            session.sendRequest(request1, correlationId1);
            String startTime2 = "11:30";
            String endTime2 = "13:30";
            options.overrides.clear();
            options.overrides.addAll(Arrays.asList(new RequestOptions.Override(fieldIdVwapStartTime, startTime2), new RequestOptions.Override(fieldIdVwapEndTime, endTime2)));
            Request request2 = ReferenceDataRequests.createRequest(refDataService, options);
            System.out.println("Sending request 2: " + request2);
            CorrelationID correlationId2 = new CorrelationID("request 2");
            session.sendRequest(request2, correlationId2);
            int finalResponseCount = 0;
            while (finalResponseCount < 2) {
                Event event = session.nextEvent();
                Event.EventType eventType = event.eventType();
                for (Message msg : event) {
                    CorrelationID msgCorrelationId = msg.correlationID();
                    if (eventType == Event.EventType.REQUEST_STATUS) {
                        if (msg.messageType().equals(Names.REQUEST_FAILURE)) {
                            if (correlationId1.equals(msgCorrelationId)) {
                                System.out.println("Request 1 failed.");
                            } else if (correlationId2.equals(msgCorrelationId)) {
                                System.out.println("Request 2 failed.");
                            }
                            ++finalResponseCount;
                        }
                    } else if (eventType == Event.EventType.RESPONSE || eventType == Event.EventType.PARTIAL_RESPONSE) {
                        if (correlationId1.equals(msgCorrelationId)) {
                            System.out.println("Received response for request 1");
                        } else if (correlationId2.equals(msgCorrelationId)) {
                            System.out.println("Received response for request 2");
                        }
                        if (eventType == Event.EventType.RESPONSE) {
                            ++finalResponseCount;
                        }
                    }
                    System.out.println(msg);
                }
            }
        }
        finally {
            session.stop();
        }
    }
}

