(ns allgress.cereus.util
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [cljs.core.async :refer [chan put!]]
            [allgress.cereus.core :refer [listen!]]))

(enable-console-print!)
(def polymer-ready (atom false))

(if (some? (aget js/window "Polymer" "import"))
  (reset! polymer-ready true)
  (listen! js/window "WebComponentsReady" (fn [e] (reset! polymer-ready true))))

(defn import-polymer
  [urls]
  (let [c (chan)]
    (if @polymer-ready
      (.import js/Polymer (clj->js urls) (fn [] (put! c true)))
      (add-watch polymer-ready urls
                 (fn [_ _ _ _]
                   (remove-watch polymer-ready urls)
                   (.import js/Polymer (clj->js urls) #(put! c true)))))
    c))