(ns allgress.cereus.util
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [cljs.core.async :refer [chan put! close! timeout]]
            [allgress.cereus.core :refer [listen!]]
            [freactive.ui-common :as ui]
            [freactive.dom :refer [register-native-api!]]))

(enable-console-print!)
(def polymer-ready (atom false))

#_(def native-register-element (.-registerElement js/document))
#_(set! (.-registerElement js/document)
      (fn register-element
        [name options]
        (try
          (native-register-element name options)
          (catch js/Error e
            #_(.error js/console e)))))

(if (and
      (some? (aget js/window "Polymer"))
      (some? (aget js/window "Polymer" "Base"))
      (some? (aget js/window "Polymer" "Base" "importHref")))
  (reset! polymer-ready true)
  (listen! js/window "WebComponentsReady" (fn [e] (println "WebComponentsReady") (reset! polymer-ready true))))

(def polymer-api
  (reify ui/INativeAPI
    (native-queue [this f])
    (native-create-element [this elem-ns elem-name]
      (let [elem (if (some? elem-ns)
                   (.createElementNS js/document elem-ns elem-name)
                   (.createElement js/document elem-name))]
        elem))
    (native-create-text-node [this text]
      (.createTextNode text))
    (native-get-attr [this elem attr-ns attr-name]
      (if attr-ns
        (.getAttributeNS (.dom js/Polymer elem) attr-ns attr-name)
        (.getAttribute (.dom js/Polymer elem) attr-name)))
    (native-set-attr! [this elem attr-ns attr-name attr-val]
      (if attr-ns
        (.setAttributeNS (.dom js/Polymer elem) attr-ns attr-name attr-val)
        (.setAttribute (.dom js/Polymer elem) attr-name attr-val)))
    (native-remove-attr! [this elem attr-ns attr-name]
      (if attr-ns
        (.removeAttributeNS (.dom js/Polymer elem) attr-ns attr-name)
        (.removeAttribute (.dom js/Polymer elem) attr-name)))
    (native-insert [this parent elem before?]
      (if before?
        (.insertBefore (.dom js/Polymer parent) elem before?)
        (.appendChild (.dom js/Polymer parent) elem)))
    (native-replace [this elem new-elem old-elem]
      (.replaceChild (.dom js/Polymer elem) new-elem old-elem))
    (native-remove [this elem child-elem]
      (.removeChild (.dom js/Polymer elem) child-elem))
    (native-element? [this x]
      (instance? js/Node x))
    (native-text-node? [this x]
      (instance? js/Text x))
    (native-set-text-node! [this node text]
      (set! (.-textContent (.dom js/Polymer node)) text))
    (native-parent-node [this node]
      (.-parentNode (.dom js/Polymer node)))
    (native-last-child [this node]
      (.-lastChild (.dom js/Polymer node)))))

(defn import-polymer
  [url]
  (let [call-id (gensym)
        c (chan)
        cb (fn [e]
             (close! c))
        tag-name (as-> url s
                       (clojure.string/split s "/")
                       (last s)
                       (clojure.string/split s ".")
                       (first s))]
    (register-native-api! tag-name polymer-api)
    (if @polymer-ready
      (.importHref (.-Base js/Polymer) url cb)
      (add-watch polymer-ready call-id
                 (fn [_ _ _ _]
                   (remove-watch polymer-ready call-id)
                   (.importHref (.-Base js/Polymer) url cb))))
    c))