(ns alumbra.validator.selection-set.inline-spread
  (:require [invariant.core :as invariant]))

(defn- add-scope-type
  [{:keys [alumbra/type-condition] :as data}]
  (assoc data
         :validator/scope-type
         (:alumbra/type-name type-condition)))

(defn make-invariant
  [type invariant-fn self]
  (-> (invariant/on-current-value)
      (invariant/fmap add-scope-type)
      (invariant/is?
        (invariant/and
          (when invariant-fn
            (invariant-fn type))
          self))))
