(defproject amperity/sparkplug-core "0.1.9"
  :description "Clojure API for Apache Spark"
  :url "https://github.com/amperity/sparkplug"
  :scm {:dir ".."}
  :license {:name "Apache License 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}

  :monolith/inherit true

  :dependencies
  [[org.clojure/clojure "1.10.3"]
   [org.clojure/java.classpath "1.0.0"]
   [org.clojure/tools.logging "1.0.0"]]

  :source-paths ["src/clojure"]
  :java-source-paths ["src/java"]

  :profiles
  {:default
   [:base :system :user :provided :spark-3.1 :dev]

   :dev
   {:jvm-opts ["-server" "-Xmx2g"]
    :dependencies
    [[org.clojure/test.check "1.0.0"]]}

   :repl
   {:source-paths ["dev"]
    :dependencies
    [[org.clojure/tools.namespace "1.0.0"]]}

   :test
   {:jvm-opts ["-XX:-OmitStackTraceInFastThrow"]}

   :spark-3.1
   ^{:pom-scope :provided}
   {:dependencies
    [[org.apache.spark/spark-core_2.12 "3.1.3"]]}

   :spark-3.2
   ^{:pom-scope :provided}
   {:dependencies
    [[org.apache.spark/spark-core_2.12 "3.2.1"]]}})
