CREATE TABLE IF NOT EXISTS campaign_context
(id BIGINT AUTO_INCREMENT,
 op_id BIGINT NOT NULL,
 op_type VARCHAR(10) NOT NULL,
 site_id VARCHAR(256) NOT NULL,
 user_id VARCHAR(256) NOT NULL,
 session_id VARCHAR(50) NOT NULL,
 page VARCHAR(500) NULL,
 event VARCHAR(500) NULL,
 campaign_name VARCHAR(250) NULL,
 campaign_source VARCHAR(250) NULL,
 campaign_medium VARCHAR(250) NULL,
 campaign_term VARCHAR(250) NULL,
 campaign_content VARCHAR(250) NULL,
 created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
 PRIMARY KEY (id),
 FOREIGN KEY (user_id) REFERENCES users(user_id) ON UPDATE CASCADE,
 FOREIGN KEY (session_id) REFERENCES sessions(session_id) ON DELETE CASCADE,
 FOREIGN KEY (site_id) REFERENCES sites(site_id) ON DELETE CASCADE);
