(defproject andreacrotti/dateutils "0.1.0-SNAPSHOT"
  :description "Helper functions to deal with dates and time"
  :url "http://github.com/andreacrotti/dateutils"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [cljc.java-time "0.1.7"]]
  :repl-options {:init-ns dateutils.core}

  :plugins [[me.arrdem/lein-git-version "2.0.8"]]
  :aliases {"kaocha" ["run" "-m" "kaocha.runner"]}

  :git-version
  {:status-to-version
   (fn [{:keys [tag branch ahead? dirty?] :as git}]
     (if (and tag (not ahead?) (not dirty?))
       tag
       (let [[_ prefix patch] (re-find #"(\d+\.\d+)\.(\d+)" tag)
             patch            (Long/parseLong patch)
             patch+           (inc patch)]
         (format "%s.%d-%s-SNAPSHOT" prefix patch+ branch))))}
  :cljfmt {:indents {for-all [[:block 1]]
                     fdef [[:block 1]]
                     checking [[:inner 0]]}}

  :profiles {:dev {:dependencies [[andreacrotti/semver "0.2.1"]
                                  [lambdaisland/kaocha "0.0-389"]
                                  [lambdaisland/kaocha-cloverage "0.0-22"]
                                  [lambdaisland/kaocha-junit-xml "0.0-63"]]
                   :plugins [[jonase/eastwood "0.3.5"]
                             [lein-cljfmt "0.5.7"]]}}
  :deploy-repositories
  [["clojars" {:url "https://clojars.org/repo/"
               :sign-releases false
               :username :env/clojars_username
               :password :env/clojars_password}]])
