(ns antistock.api.client
  (:require [geo.transit :as geo]
            #?(:cljs [routes.core])
            #?(:clj [request.core :refer [defroutes]]
               :cljs [request.core :refer-macros [defroutes]])))
(def server
  {:scheme :https
   :server-name "api.antistock.net"})

(def ^:private transit-opts
  #?(:clj
     {:handlers
      (merge geo/read-handlers
             geo/write-handlers)}
     :cljs
     {:encoding-opts {:handlers geo/write-handlers}
      :decoding-opts {:handlers geo/read-handlers}}))

(defroutes routes
  ["/" :root]
  ["/continents" :continents]
  ["/continents/:id" :continent]
  ["/countries" :countries]
  ["/countries/:id" :country]
  ["/companies" :companies]
  ["/companies/:id" :company]
  ["/twitter/statuses" :twitter-statuses]
  ["/twitter/users" :twitter-users]
  ["/quotes" :quotes]
  ["/quotes/:id" :quote]
  {:accept "application/transit+json"
   :content-type "application/transit+json"
   :transit-opts transit-opts})
