(ns antistock.config.schema
  (:require [schema.core :as s]))

(def Api
  "The schema for the API service."
  {:bind-address s/Str
   :bind-port s/Int})

(def ApiClient
  "The schema for the API client."
  {:scheme (s/enum :http :https)
   :server-name s/Str
   :server-port s/Int})

(def Aws
  "The schema for the AWS service."
  {:access-key s/Str
   :account-number s/Str
   :secret-key s/Str})

(def Broker
  "The schema for the broker service."
  {:password s/Str
   :scheme (s/enum :amqp)
   :server-name s/Str
   :server-port s/Int
   :username s/Str
   :vhost s/Str})

(def Db
  "The schema for the database service."
  {:name s/Str
   :password s/Str
   :scheme (s/enum :postgresql)
   :server-name s/Str
   :server-port s/Int
   :username s/Str
   (s/optional-key :test) s/Bool})

(def Google
  "The schema for the database service."
  {:api-key s/Str
   :client-id s/Str
   :client-secret s/Str
   :redirect-uri s/Str})

(def Reload
  "The schema for the namespace reload service."
  {:disabled s/Bool
   :source-paths [s/Str]})

(def Web
  "The schema for the web service."
  {:bind-address s/Str
   :bind-port s/Int})

(def WebClient
  "The schema for the web client."
  {:scheme (s/enum :http :https)
   :server-name s/Str
   :server-port s/Int})

(def Config
  "The schema for the config."
  {:api Api
   :api-client ApiClient
   :aws Aws
   :broker Broker
   :db Db
   :google Google
   :reload Reload
   :web Web
   :web-client WebClient})
