(defproject antistock/config "0.1.1"
  :description "Antistock configuration"
  :url "https://bitbucket.org/r0man/antistock-config"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [prismatic/schema "0.3.3"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :deploy-repositories [["releases" :clojars]]
  :eastwood {:exclude-linters [:constant-test]}
  :profiles {:dev {:plugins [[jonase/eastwood "0.2.0"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}}
  :repositories {"releases" {:url "s3p://antistock/maven/releases"
                             :username [:gpg :env/as_aws_access_key_id]
                             :passphrase [:gpg :env/as_aws_secret_access_key]}
                 "snapshots" {:url "s3p://antistock/maven/snapshots"
                              :username [:gpg :env/as_aws_access_key_id]
                              :passphrase [:gpg :env/as_aws_secret_access_key]}})
