# README.antistock

## Usage

### API

The API server can be started on port 8080 with

```
lein run api
```

### Fixtures

Database fixtures can be deleted, loaded and dumped.

```
lein run fixtures delete
lein run fixtures load
lein run fixtures dump
```

### Load historical finance data for all quotes from Yahoo finance.

```
lein run historical
lein run historical -s 2013-01-01 -e 2013-01-31
```

### Import companies and quotes from NASDAQ.

```
lein run quotes
```

### Discover the Wikipedia urls of all companies and update them.

```
lein run wikipedia
```

### Update all companies from Wikipedia.

```
lein run wikipedia companies
```

### Update the Wikipedia page edits.

```
lein run wikipedia page-edits
```

### Load the Wikipedia page views.

```
lein run wikipedia views -s 2013-01-01 -e 2013-01-31
```

## Sentiment Analysis

[What are some open source sentiment analysis engines?](http://www.quora.com/Sentiment-Analysis/What-are-some-open-source-sentiment-analysis-engines)

## RabbitMQ

Enable the RabbitMQ management plugin.

```
sudo -u rabbitmq -i rabbitmq-plugins enable rabbitmq_management
```

Configure the RabbitMQ virtual hosts.

```
sudo -u rabbitmq -i rabbitmqctl add_vhost antistock.dev
sudo -u rabbitmq -i rabbitmqctl add_vhost antistock.test
```

Configure the RabbitMQ user for the development and test environments.

```
sudo -u rabbitmq -i rabbitmqctl add_user tiger scotch
sudo -u rabbitmq -i rabbitmqctl set_user_tags tiger administrator
sudo -u rabbitmq -i rabbitmqctl set_permissions -p antistock.dev tiger ".*" ".*" ".*"
sudo -u rabbitmq -i rabbitmqctl set_permissions -p antistock.test tiger ".*" ".*" ".*"
```

## PostgreSQL

### Configuring shared memory

The recommended method for configuring shared memory is to create a
file named /etc/sysctl.conf, containing variable assignments such as:

kernel.shmmax = 8246116352
kernel.shmall = 2013212

### Configuring PostgreSQL

# 1/4 of the total memory
shared_buffers = 4GB

# 1/2 of the total memory
effective_cache_size = 8GB

# max_connection * work_mem
work_mem = 50MB

### Create user

Create the PostgreSQL user "tiger" and assign the password "scotch".

```
createuser --superuser --pwprompt tiger
```

### Create database

Create the development and test databases.

```
createdb antistock_development
createdb antistock_test
```

### Migrations with Sqitch

Install [Sqitch](http://search.cpan.org/dist/App-Sqitch) via [CPAN](http://www.cpan.org).

```
sudo cpan App::Sqitch
sudo cpan DBD:Pg
```

Configure your Sqitch user and email settings.

```
sqitch config --user user.name "USERNAME"
sqitch config --user user.email "EMAIL"
```

## Mahout

### Clustering

```
lein cluster -s 2011-01-01 -e 2011-01-31
mahout clusterdump -i /tmp/cluster-price/output/clusters-5-final -o /dev/stdout -p /tmp/cluster-price/output/clusteredPoints/ -sp 10
mahout seqdumper -i /tmp/cluster-price/output/clusteredPoints -o /dev/stdout
```

### Deployment

### Heroku configuration

Configure the environment.

```
heroku config:set AS_API_BIND_ADDRESS="0.0.0.0"
heroku config:set AS_API_BIND_PORT="80"
heroku config:set AS_API_SCHEME="http"
heroku config:set AS_API_SERVER_NAME="api.antistock.net"
heroku config:set AS_API_SERVER_PORT="80"
heroku config:set AS_AWS_ACCESS_KEY="02KEZMVTWR8T2K48TV82"
heroku config:set AS_AWS_ACCOUNT_NUMBER="6313-6809-5177"
heroku config:set AS_AWS_SECRET_KEY="VltIXmjVQFlqDeDUD3vmK8dNUKOt/ao6wRqEfl12"
heroku config:set AS_BROKER_SERVER_NAME="antistock.net"
heroku config:set AS_BROKER_SERVER_PORT="5672"
heroku config:set AS_BROKER_USERNAME="antistock"
heroku config:set AS_BROKER_PASSWORD="antistock13+"
heroku config:set AS_BROKER_VHOST="antistock.net"
heroku config:set AS_DB_NAME="antistock_production"
heroku config:set AS_DB_PASSWORD="antistock13+"
heroku config:set AS_DB_SCHEME="postgresql"
heroku config:set AS_DB_SERVER_NAME="antistock.net"
heroku config:set AS_DB_SERVER_PORT="5432"
heroku config:set AS_DB_USERNAME="antistock"
heroku config:set AS_GOOGLE_API_KEY="ABQIAAAAPX7sbJ31IPm9rsCbgjHMnhQHNwmUDHs-GA1AjjGF_GZH5hY1GxR_IgnK4zGHBsQ9RmIB109FshjMjQ"
heroku config:set AS_GOOGLE_CLIENT_ID="912714014113.apps.googleusercontent.com"
heroku config:set AS_GOOGLE_CLIENT_SECRET="3JNDULltw7evS7bKkw4hchpM"
heroku config:set AS_GOOGLE_REDIRECT_URI="http://api.antistock.net/oauth/google/callback"
heroku config:set AS_WEB_BIND_ADDRESS="0.0.0.0"
heroku config:set AS_WEB_BIND_PORT="80"
heroku config:set AS_WEB_SCHEME="http"
heroku config:set AS_WEB_SERVER_NAME="www.antistock.net"
heroku config:set AS_WEB_SERVER_PORT="80"
```

Deploy the worker.

```
git push heroku master
```

### Apache Flume

```
flume-ng agent --conf $FLUME_HOME/conf --conf-file resources/flume.conf --name agent-1 -Dflume.root.logger=INFO,console
```

## License

Copyright (c) 2013 Antistock
