(ns antistock.core
  (:require [clojure.data.csv :as csv]
            [clojure.java.io :as io]
            [clojure.string :refer [trim]])
  (:import [javax.xml.transform OutputKeys TransformerFactory]))

(defn tab2csv [input output]
  (with-open [in-file (io/reader input)
              out-file (io/writer output)]
    (csv/write-csv out-file (csv/read-csv in-file :separator \tab))))

(defn but-idx [coll idx]
  (let [v (vec coll)]
    (concat (subvec v 0 idx)
            (subvec v (inc idx) (count coll)))))

(defn safe-trim [s]
  (if s (trim s)))

(defn ppxml [xml]
  (let [in (javax.xml.transform.stream.StreamSource.
            (java.io.StringReader. xml))
        writer (java.io.StringWriter.)
        out (javax.xml.transform.stream.StreamResult. writer)]
    (doto (.newTransformer (TransformerFactory/newInstance))
      (.setOutputProperty OutputKeys/INDENT "yes")
      (.setOutputProperty "{http://xml.apache.org/xslt}indent-amount" "2")
      (.setOutputProperty OutputKeys/METHOD "xml")
      (.transform in out))
    (-> out .getWriter .toString)))
