(ns antistock.system
  (:require [com.stuartsierra.component :as component]))

(defn on-shutdown
  "Run the function `f` on JVM shutdown."
  [f]
  (.addShutdownHook (Runtime/getRuntime) (Thread. f)))

(defmacro with-component
  "Create a new component with `new-form`, bind the started component
  to `component-sym`, evaluate `body` and stop the component again."
  [[component-sym new-form] & body]
  `(let [component# (component/start ~new-form)
         ~component-sym component#]
     (try ~@body
          (finally (component/stop component#)))))
