(ns antistock.json
  (:import [java.io File PrintWriter]
           [com.fasterxml.jackson.core JsonGenerator])
  (:refer-clojure :exclude [extend read-string second])
  (:require [antistock.time :refer :all]
            [cheshire.custom :refer [JSONable to-json]]
            [clojure.data.json :as json]
            [clojure.data.json :refer [-write JSONWriter]]
            [clojure.string :refer [blank?]]))

(defn json-str [s]
  (json/write-str s))

(defn read-json [s]
  (cond
   (and (string? s) (not (blank? s)))
   (json/read-str s :key-fn keyword)
   (instance? java.io.InputStream s)
   (let [s (slurp s)]
     (if-not (blank? s)
       (json/read-str s :key-fn keyword)))))

(defn read-string [s]
  (json/read-str s :key-fn keyword))

(defn- write-time [time ^PrintWriter out]
  (-write (format-time time) out))

(extend-type java.lang.Class
  JSONWriter
  (-write [class out]
    (-write (.getName class) out)))

(extend-type java.util.Date
  JSONWriter
  (-write [date out]
    (-write (format-time date) out)))

(extend-type java.sql.Timestamp
  JSONWriter
  (-write [timestamp out]
    (write-time timestamp out)))

(extend-type org.joda.time.DateTime
  JSONable
  (to-json [date-time ^JsonGenerator generator]
    (.writeString generator (format-time date-time)))
  JSONWriter
  (-write [date-time out]
    (write-time date-time out)))
