-- Deploy create-countries-table

BEGIN;

CREATE TABLE countries (
  id SERIAL PRIMARY KEY,
  continent_id INTEGER NOT NULL REFERENCES continents(id) ON DELETE CASCADE,
  name CITEXT UNIQUE NOT NULL,
  iso_3166_1_alpha_2 CITEXT UNIQUE NOT NULL,
  iso_3166_1_alpha_3 CITEXT UNIQUE NOT NULL,
  iso_3166_1_numeric INTEGER UNIQUE NOT NULL,
  fips_code CITEXT,
  geonames_id INTEGER UNIQUE,
  phone_prefix CITEXT,
  area INTEGER,
  population INTEGER,
  geom GEOMETRY(MULTIPOLYGON, 4326),
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX countries_name_fulltext_index ON countries USING gin(to_tsvector('english', name));
CREATE INDEX countries_geom_index ON countries USING gist(geom);

CREATE TRIGGER countries_created_at_trigger
  BEFORE INSERT ON countries FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER countries_updated_at_trigger
  BEFORE UPDATE ON countries FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
